//                                               -*- C++ -*-
/**
 * @file		StepC2.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-31 13:50:40
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
//Header
#include "StepC2.hxx"

// OT::UI::GUI
#include "QOTAction.hxx"
#include "Study.hxx"
#include "CentralDispersion.hxx"
#include "BlockC2.hxx"
#include "CalculationC3.hxx"

// Qt
#include <qobjectlist.h>
#include <qmessagebox.h>

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			StepC2::StepC2 ( QOTObject *parent, Study * study ) : Step ( parent, "Step C2" )
			{
				setName ( tr ( "Step C2" ) );
				setDescription ( tr ( "C2: Central Dispertion" ) );

				/* "Block creation" */
				const QString title = tr ( "&New Block C2" ) + "...";
				connect ( new QOTAction ( title, 0, this, "StepC2_newBlock" ), SIGNAL ( activated() ) , this, SLOT ( createBlock() ) );

				study_ = study;
				setRenameEnabled ( false );
			}


			StepC2::~StepC2()
			{}

			QString StepC2::getFullName() const
			{
				return getDescription();
			}

			void StepC2::createBlock()
			{
				QObjectList * blockBList = new QObjectList();
				study_->getStepB() ->getChildren ( blockBList, "OpenTURNS::UI::GUI::BlockB", true, false );

				const QString title = tr ( "Create Block" ) + " - OpenTURNS";
				QString msg = "";

				if ( blockBList->count() > 0 )
				{
					// there is at least one block B
					BlockB * blockB = NULL;
					if ( blockBList->count() == 1 )
					{
						blockB = ( BlockB* ) blockBList->at ( 0 );
					}
					else
					{
						blockB = ( BlockB* ) chooseQOTObject ( title, tr ( "Choose a block B" ), blockBList );
					}

					if ( blockB != NULL )
					{
						QObjectList * centralDispertionList = new QObjectList();
						blockB->getBlockA_ptr() ->getChildren ( centralDispertionList, "OpenTURNS::UI::GUI::CentralDispersion", true, false );

						if ( centralDispertionList->count() > 0 )
						{
							// there is at least one threshold exceedance

							CentralDispersion * centralDispertion = NULL;
							if ( centralDispertionList->count() == 1 )
							{
								centralDispertion = ( CentralDispersion* ) centralDispertionList->at ( 0 );
							}
							else
							{
								centralDispertion = ( CentralDispersion* ) chooseQOTObject ( title, tr ( "Choose a central dispertion" ), centralDispertionList );
							}

							if ( centralDispertion != NULL )
							{
								QObjectList * finalVariableList = new QObjectList();
								blockB->getBlockA_ptr() ->getChildren ( finalVariableList, "OpenTURNS::UI::GUI::FinalVariable", true, false );

								if ( finalVariableList->count() > 0 )
								{
									FinalVariable * finalVariable = NULL;
									if ( finalVariableList->count() == 1 )
									{
										finalVariable = ( FinalVariable* ) finalVariableList->at ( 0 );
									}
									else
									{
										finalVariable = ( FinalVariable* ) chooseQOTObject ( title, tr ( "Choose a final variable" ), finalVariableList );
									}

									if ( finalVariable != NULL )
									{
										BlockC2 * blockC2 = new BlockC2 ( this, "BlockC2" );
										blockC2->setBlockB_ptr ( blockB );
										blockC2->setCentralDispersion_ptr ( centralDispertion );
										blockC2->setFinalVariable_ptr ( finalVariable );

										new CalculationC2 ( blockC2, "CalculationC2" );
										listBlocks_.append ( blockC2 );
										emit updated();
									}
								}
								else
								{
									msg = tr ( "You must create at least one final variable." );
									QMessageBox::warning ( NULL, title, msg, QMessageBox::Ok, QMessageBox::NoButton );
								}
							}

						}
						else
						{
							msg = tr ( "You must create at least one central dispertion." );
							QMessageBox::warning ( NULL, title, msg, QMessageBox::Ok, QMessageBox::NoButton );
						}
					}

				}
				else
				{
					msg = tr ( "You must create at least one block in step B." );
					QMessageBox::warning ( NULL, title, msg, QMessageBox::Ok, QMessageBox::NoButton );
				}
			}

		}

	}

}
