//                                               -*- C++ -*-
/**
 * @file    StepB.cxx
 * @brief   There are three main steps in OpenTURNS to obtain a result. This is the second one.
 *
 * @author    Romuald Conty
 * @date      2006-06-12
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

// Header
#include "StepB.hxx"

// Qt
#include <qmessagebox.h>
#include <qinputdialog.h>

// OT::UI::GUI
#include "BlockB.hxx"
#include "BlockA.hxx"

#include "QOTAction.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			StepB::StepB ( QOTObject * parent ) : Step ( parent, "Step B" )
			{
				setName ( tr ( "Step B" ) );
				setDescription ( tr ( "Uncertainty sources quantification" ) );

				/* "Block creation" */
				const QString title = tr ( "&New Block B" ) + "...";
				connect ( new QOTAction ( title, 0, this, "StepB_newBlock" ), SIGNAL ( activated() ) , this, SLOT ( createBlock() ) );

			}

			StepB::~StepB()
			{
				listBlocks_.clear();
			}

			void StepB::createBlock()
			{
				bool ok;
				// Display inputbox for block's title
				QString title = tr ( "Create Block" ) + " - OpenTURNS";
				QString msg = tr ( "Enter block name :" );
				QString name = giveUniqueChildName ( "BlockB_1" );
				name = QInputDialog::getText ( title, msg, QLineEdit::Normal, name, &ok );

				if ( ok )
				{
					// user pressed OK
					if ( name.stripWhiteSpace().isEmpty() )
					{
						//user entered nothing
						msg = tr ( "Please enter a name to create your block" );
						QMessageBox::warning ( NULL, title, msg, QMessageBox::Ok, QMessageBox::NoButton );
					}
					else if ( child ( name.stripWhiteSpace().ascii(), "OpenTURNS::UI::GUI::Block", false ) )
					{
						// user entred an already used name
						msg = tr ( "This name is already used, please enter an another name to create your block" );
						QMessageBox::warning ( NULL, title, msg, QMessageBox::Ok, QMessageBox::NoButton );
					}
					else
					{
						// user entered an unused name
						QObjectList * childrenList = new QObjectList();
						( ( QOTObject* ) parent() ) -> getChildren ( childrenList, "OpenTURNS::UI::GUI::BlockA", true , false );
						if ( childrenList->count() == 1 )
						{
							BlockB * blockB = new BlockB ( this, name );
							blockB->setBlockA_ptr ( ( BlockA* ) childrenList->at ( 0 ) );
							listBlocks_.append ( blockB );
						}
						else
						{
							QStringList strings;
							for ( uint i = 0; i < childrenList->count(); i++ )
							{
								const QString blockAName = ( ( QOTObject* ) childrenList->at ( i ) ) ->getName();
								strings.append ( blockAName );
							}
							title = tr ( "Link with Block A" ) + " - OpenTURNS";
							msg = tr ( "Choose a block :" );
							QString blockA = QInputDialog::getItem ( title, msg, strings, 0, false, &ok );
							if ( ok )
							{
								for ( uint i = 0; i < childrenList->count(); i++ )
								{
									if ( ( ( QOTObject* ) childrenList->at ( i ) ) ->getName() == blockA )
									{
										BlockB * blockB = new BlockB ( this, name );
										blockB->setBlockA_ptr ( ( BlockA* ) childrenList->at ( i ) );
										listBlocks_.append ( blockB );
										break;
									}
								}
							}
						}
						delete childrenList;
						emit updated();
					}
				}
				else
				{
					// user pressed Cancel => nothing to do...
				}
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

