//                                               -*- C++ -*-
/**
 * @file		StepA.hxx
 * @brief		There are three main steps in OpenTURNS to obtain a result. This is the first one.
 *
 * @author		Romuald Conty
 * @date			2006-06-12
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef OPENTURNS_GUISTEPA_HXX
#define OPENTURNS_GUISTEPA_HXX

// OT::UI::GUI
#include "Step.hxx"
#include "BlockA.hxx"

// Qt
#include <qptrlist.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/**
			 * @class		StepA
			 * @brief		Represents the first Step needed to obtain a complete Study
			 *
			 * This class is the visual representation of the first Step to obtain a complete Study.
			 * It used to create and store one or more BlockA.
			 */
			class StepA : public Step
			{
					Q_OBJECT

				public:
					/** Default constructor */
					StepA ( QOTObject * parent );

					/** Destructor */
					virtual ~StepA();

				public slots:
					void createBlock();

				protected:
					QPtrList<Block> listBlocks_;
			}
			; /* class StepA */
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_GUISTEP_A_HXX */
