//                                               -*- C++ -*-
/**
 * @file		StepA.cxx
 * @brief		There are three main steps in OpenTURNS to obtain a result. This is the first one.
 *
 * @author		Romuald Conty
 * @date			2006-06-12
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

// Header
#include "StepA.hxx"

// Qt
#include <qmessagebox.h>
#include <qinputdialog.h>

// OT::UI::GUI
#include "QOTAction.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			StepA::StepA ( QOTObject * parent ) : Step ( parent, "Step A" )
			{
				setName ( tr ( "Step A" ) );
				setDescription ( tr ( "Criteria and study case" ) );

				/* "Block creation" */
				const QString title = tr ( "&New Block A" ) + "...";
				connect ( new QOTAction ( title, 0, this, "StepA_newBlock" ), SIGNAL ( activated() ) , this, SLOT ( createBlock() ) );

			}

			/** Destructor */
			StepA::~StepA()
			{
				listBlocks_.clear();
			}


			void StepA::createBlock()
			{
				bool ok;
				// Display inputbox for block's title
				const QString title = tr ( "Create Block" ) + " - OpenTURNS";
				QString msg = tr ( "Enter block name:" );
				QString name = giveUniqueChildName ( "BlockA_1" );
				name = QInputDialog::getText ( title, msg, QLineEdit::Normal, name, &ok );

				if ( ok )
				{
					// user pressed OK
					if ( name.stripWhiteSpace().isEmpty() )
					{
						//user entered nothing
						msg = tr ( "Please enter a name to create your block" );
						QMessageBox::warning ( NULL, title, msg, QMessageBox::Ok, QMessageBox::NoButton );
					}
					else if ( child ( name.stripWhiteSpace().ascii(), "OpenTURNS::UI::GUI::Block", false ) )
					{
						// user entred an already used name
						msg = tr ( "This name is already used, please enter an another name to create your block" );
						QMessageBox::warning ( NULL, title, msg, QMessageBox::Ok, QMessageBox::NoButton );
					}
					else
					{
						// user entered an unused name
						listBlocks_.append ( new BlockA ( this, name ) );
						emit updated();
					}
				}
				else
				{
					// user pressed Cancel => nothing to do...
				}
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

