//                                               -*- C++ -*-
/**
 * @file		Step.cxx
 * @brief		Generalization of Step*
 *
 * @author		Romuald Conty
 * @date		2006-06-12
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "Step.hxx"

// OT::UI::GUI

// Qt
#include <qinputdialog.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			Step::Step ( QOTObject * parent, const char * name ) : QOTObject ( parent, name )
			{}

			QString Step::getFullName() const
			{
				return getName() + " : " + getDescription();
			}

			Step::~Step()
			{}

			QOTObject* Step::chooseQOTObject ( const QString& caption, const QString& label, QObjectList* objectList )
			{
				QStringList strings;
				for ( uint i = 0; i < objectList->count(); i++ )
				{
					if ( objectList->at ( i ) ->inherits ( "OpenTURNS::UI::GUI::QOTObject" ) )
					{
						strings.append ( ( ( QOTObject* ) objectList->at ( i ) ) ->getName() );
					}
				}

				bool ok = false;
				QString selectedOTObject = QInputDialog::getItem ( caption, label, strings, 0, false, &ok );
				if ( ok )
				{
					for ( uint i = 0; i < objectList->count(); i++ )
					{
						if ( ( ( QOTObject* ) objectList->at ( i ) ) ->getName() == selectedOTObject )
						{
							return ( ( QOTObject* ) objectList->at ( i ) );
						}
					}
				}
				return NULL;
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */


