//                                               -*- C++ -*-
/**
 * @file		ResponseSurfaceFunction.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-22 10:20:35
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "ResponseSurfaceFunction.hxx"

// OT::UI::GUI
#include "BlockA.hxx"
#include "BlockFunctionProperty.hxx"
#include "NumericalScalarProperty.hxx"
#include "UnsignedLongProperty.hxx"
#include "NumericalSampleProperty.hxx"

// OT
#include "LinearLeastSquares.hxx"
#include "QuadraticLeastSquares.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			typedef OT::Uncertainty::Algorithm::LinearLeastSquares LinearLeastSquares;
			typedef OT::Uncertainty::Algorithm::QuadraticLeastSquares QuadraticLeastSquares;

			/** Default constructor */
			ResponseSurfaceFunction::ResponseSurfaceFunction ( QOTObject *parent, const char *name ) : Function ( parent, name )
			{
				Block * block = getParentBlock();
				Q_CHECK_PTR ( block );
				if ( ( block != NULL ) && ( block->isA ( "OpenTURNS::UI::GUI::BlockA" ) ) )
				{
					QOTProperty * blockFunctionProperty = new BlockFunctionProperty ( &parentNumericalMathFunction_, ( BlockA* ) block, this, "function" );
					blockFunctionProperty->setDefaultChoice();
				}

				polynomialDegree_ = 1;
				new UnsignedLongProperty ( &polynomialDegree_, true, this, "polynomial degree" );

				QOTProperty* numericalSampleProperty = new NumericalSampleProperty ( &numericalSample_, this, "sample" );
				numericalSampleProperty->setDefaultChoice();
			}

			/** Copy constructor */
			ResponseSurfaceFunction::ResponseSurfaceFunction ( const ResponseSurfaceFunction & other, QOTObject* parent ) : Function ( parent )
			{
				assignToMe ( other );
			}

			/** Destructor */
			ResponseSurfaceFunction::~ResponseSurfaceFunction()
			{}

			/** The function that actually realizes assignment between entry variables */
			void ResponseSurfaceFunction::assignToMe ( const ResponseSurfaceFunction & other )
			{
				Content::assignToMe ( other );
			}

			/** ResponseSurfaceFunction NumericalMathFunction accessor */
			NumericalMathFunction ResponseSurfaceFunction::getNumericalMathFunction()
			{
				qDebug ( "ResponseSurfaceFunction::getNumericalMathFunction()" );

				NumericalMathFunction numericalMathFunction;

				// if ( algorithm == "Least Squares" ) {
				try
				{
					switch ( polynomialDegree_ )
					{
						case 1:
						{
							LinearLeastSquares linearLeastSquares ( numericalSample_, parentNumericalMathFunction_ );
							linearLeastSquares.run();
							numericalMathFunction = linearLeastSquares.getResponseSurface();
						}
						break;
						case 2:
						{
							QuadraticLeastSquares quadraticLeastSquares ( numericalSample_, parentNumericalMathFunction_ );
							quadraticLeastSquares.run();
							numericalMathFunction = quadraticLeastSquares.getResponseSurface();
						}
						break;
					}
				}
				catch ( ... )
				{
					qWarning ( "Zzz !!!" );
				}
				/*
				  } else if ( algorithm == "taylor" ) {
				  try {
				  switch ( polynomialDegree_ ) {
				  case 1: {
				  LinearTaylor linearTaylor = LinearTaylor( center_, parentNumericalMathFunction_ );
				  linearTaylor.run();
				  numericalMathFunction = linearTaylor.getResponseSurface();
				  }
				  break;
				  case 2: {
				  QuadraticTaylor quadraticTaylor = QuadraticTaylor( center_, parentNumericalMathFunction_ );
				  quadraticTaylor.run();
				  numericalMathFunction = quadraticTaylor.getResponseSurface();
				  }
				  break;
				  }
				  } catch ( ... ) {
				  qWarning( "Zzz !!!" );
				  }
				  }

				*/

				return numericalMathFunction;
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

