//                                               -*- C++ -*-
/**
 * @file		QStreamRedirect.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-11-29 11:19:21
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#include "QStreamRedirect.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			QStreamRedirect::QStreamRedirect ( std::ostream &stream ) : QObject ( 0, 0 ), m_stream ( stream )
			{
				m_old_buf = stream.rdbuf();
				stream.rdbuf ( this );
			}

			QStreamRedirect::~QStreamRedirect()
			{
				m_stream.rdbuf ( m_old_buf );
			}

			std::streamsize QStreamRedirect::xsputn ( const char *p, std::streamsize n )
			{
				QString text;
				text = QString ( p );
				emit streamRedirected ( text );
				qDebug ( p );
				return n;
			}

		}
	}
}
