//                                               -*- C++ -*-
/**
 * @file		qpropertiestable.hxx
 * @brief 	Specialization of a QTable to display and edit properties
 *
 * @author	Romuald Conty
 * @date		2006-07-06 10:59:37
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIQPROPERTIESTABLE_HXX
#define OPENTURNS_GUIQPROPERTIESTABLE_HXX

// OT::UI::GUI
#include "Parameter.hxx"
#include "QOTObject.hxx"

// Qt
#include <qtable.h>
#include <qvaluelist.h>
#include <qvariant.h>

// Visual Component
//#include "QOTTableItem.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class QPropertiesTable : public QTable
			{
					Q_OBJECT

				public:
					QPropertiesTable ( QWidget * parent = 0, const char * name = 0 );
					~QPropertiesTable();

					void displayProperty ( QOTObject * object, const uint propertyIndex );

					void displayParameters ( QValueList<QVariant> * parameters, const QString& propertyName );
					void displayParameter ( Parameter& parameter, const QString & id );
				public slots:
					void displayProperties ( QOTObject * object );

				protected:
					QTableItem* setPropertyItem ( int row, const QString& property, const QString& value, bool writable = false );
					QTableItem* setPropertyItem ( int row, const QString& property, const QValueList<QVariant>& values, bool writable = false );
					QTableItem* setPropertyItem ( int row, const QString& property, QStringList strings, bool writable = false );

					QOTObject * object_;
					uint currentRow;

				protected slots:
					void propertyValueChanged ( int row, int col );
			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
