//                                               -*- C++ -*-
/**
 * @file    QOTProperty.hxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2006-12-18 11:29:13
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#ifndef OPENTURNS_UI_GUIQOTPROPERTY_HXX
#define OPENTURNS_UI_GUIQOTPROPERTY_HXX

// Qt
#include <qobject.h>
#include <qptrlist.h>
#include <quuid.h>

// OT
#include "OT.hxx"
#include "Object.hxx"
#include "QOTAction.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			class QOTObject;

			class QOTProperty : public QObject
			{
					Q_OBJECT
				public:

					enum PropertyType { NotEditable, SimpleText, MultipleChoice };

					QOTProperty ( const QOTProperty::PropertyType type, QObject *parent, const char *name );

					virtual ~QOTProperty();

					virtual QString getValue() = 0;
					virtual bool setValue ( QString value ) = 0;

					virtual QString getName();

					virtual QStringList getChoices();

					virtual void setDefaultChoice();

					QOTProperty::PropertyType getType() const;

					QOTActions getActions();

					bool isASubproperty();

					QString getUuid() const;

					QOTObject* getRootObject();

					int getRank();

					uint getLevel() const;

					QPtrList<QOTProperty> getSubproperties ( bool recursiveSearch );

					static void getProperties ( const QObject* startPoint, QPtrList<QOTProperty>* resultList, bool recursiveSearch );

				public slots:
					virtual void subpropertyUpdated ( QOTProperty* subproperty );

				signals:
					void updated();
					void updated ( QOTProperty* );
					void destroyed ( QOTProperty* );

				protected:
					void setType ( const QOTProperty::PropertyType type );

				private slots:
					void updatedExt();

				private:
					QUuid uuid_;
					QString name_;
					PropertyType type_;
					uint level_;

			};
			typedef QPtrList<QOTProperty> QOTProperties;

		}

	}

}

#endif
