//                                               -*- C++ -*-
/**
 * @file    QConcole.cxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2007-01-03 19:12:32
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "QConsole.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			QConsole::QConsole ( QWidget* parent, const char *name ) : QTextEdit ( parent, name )
			{
				ioRedirect_ = false;
				cout_ = NULL;
				cerr_ = NULL;

				this->setTextFormat ( Qt::LogText );
				QStyleSheetItem * stdoutStyle = new QStyleSheetItem ( this->styleSheet(), "stdout" );
				stdoutStyle->setColor ( "blue" );

				QStyleSheetItem * stderrStyle = new QStyleSheetItem ( this->styleSheet(), "stderr" );
				stderrStyle->setColor ( "red" );
				stderrStyle->setFontWeight ( QFont::Bold );
			}

			QConsole::~QConsole()
			{}

			void QConsole::writeText ( const QString& text )
			{
				append ( text );
			}

			void QConsole::writeStdOut ( const QString& stdout )
			{
				this->append ( "<stdout>" + stdout + "</stdout>" );
			}

			void QConsole::writeStdError ( const QString& stderr )
			{
				this->append ( "<stderr>" + stderr + "</stderr>" );
			}


			void QConsole::setIostreamRedirect ( bool ioRedirect )
			{
				if ( ioRedirect != ioRedirect_ )
				{
					if ( ioRedirect )
					{
						cout_ = new QStreamRedirect ( std::cout );
						connect ( cout_, SIGNAL ( streamRedirected ( const QString& ) ), this, SLOT ( writeStdOut ( const QString& ) ) );
						cerr_ = new QStreamRedirect ( std::cerr );
						connect ( cerr_, SIGNAL ( streamRedirected ( const QString& ) ), this, SLOT ( writeStdError ( const QString& ) ) );
					}
					else
					{
						cout_->disconnect ( this );
						delete cout_;
						cout_ = NULL;
						cerr_->disconnect ( this );
						delete cerr_;
						cerr_ = NULL;
					}
					std::cout << "Warning: cout stream is now here !" << std::endl;
					std::cerr << "Warning: cerr stream is now here !" << std::endl;

					ioRedirect_ = ioRedirect;
				}
			}
			/*
			// EXAMPLE 1
			Use it like this:

			QDebugStream cout( std::cout );
			QDebugStream cerr( std::cerr );

			std::cout << "Hello!";  // calls qDebug

			// EXAMPLE 2
			class mystreambuf:
			public std::basic_streambuf< char, std::char_traits< char > >
			{
			typedef
			std::basic_streambuf< char, std::char_traits< char > >
			::
			int_type
			int_type
			;
			typedef std::char_traits< char > traits_t;

			int_type overflow( int_type c )
			{
			std::cerr << traits_t::to_char_type( c );

			// in your code write c to your QT widget hwever that
			// is done .

			return c;
			}
			};

			int main()
			{
			mystreambuf mybuf;
			std::cout.rdbuf( &mybuf );

			std::cout << "here's some text";

			std::cerr << "\n";

			}
			*/

		}
	}
}
