//                                               -*- C++ -*-
/**
 * @file		GradientCalculationProperty.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-14 17:06:45
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#ifndef OPENTURNS_UI_GUIGARDIENTCALCULATIONPROPERTY_HXX
#define OPENTURNS_UI_GUIGARDIENTCALCULATIONPROPERTY_HXX

// OT::UI::GUI
#include "QOTProperty.hxx"

// OT
#include "OT.hxx"
#include "NumericalMathFunction.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			typedef OT::Base::Func::NumericalMathFunction NumericalMathFunction;

			class GradientCalculationProperty : public QOTProperty
			{
					Q_OBJECT
				public:
					GradientCalculationProperty ( NumericalMathFunction* numericalMathFunction, QObject* parent, const char* name );

					~GradientCalculationProperty();

					virtual QString getValue();
					virtual bool setValue ( QString value );

					QStringList getChoices();

				public slots:
					void generateGradient();

				protected:
					void autoconnect ( QOTProperty* subproperty );

				protected:
					QString value_;

					NumericalMathFunction* numericalMathFunction_;

					NumericalScalar step_;
			};

		}

	}

}

#endif
