//                                               -*- C++ -*-
/**
 * @file    FunctionParametersProperty.cxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2007-01-12 11:08:37
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "FunctionParametersProperty.hxx"

// OT::UI::GUI
#include "QOTAction.hxx"
#include "DescriptionProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			FunctionParametersProperty::FunctionParametersProperty ( Description* parameters, const bool editable, QObject* parent, const char* name ) : QOTProperty ( ( ( editable ) ? ( QOTProperty::SimpleText ) : ( QOTProperty::NotEditable ) ), parent, name )
			{
				Q_CHECK_PTR ( parameters );
				parameters_ = parameters;

				/** @todo change icon */
				QOTAction * actionAddParameter = new QOTAction ( tr ( "Add a parameter" ), 0, this, "Chapter_newObject" );
				connect ( actionAddParameter, SIGNAL ( activated() ) , this, SLOT ( addParameter() ) );

				for ( uint i = 0; i < parameters->getSize(); i++ )
				{
					subpropertyUpdated ( new DescriptionProperty ( parameters, i, true, this, QString ( QString ( "input" ) + QString::number ( i + 1 ) ).ascii() ) );
				}
			}


			FunctionParametersProperty::~FunctionParametersProperty()
			{}


			QString FunctionParametersProperty::getValue()
			{
				return QString::number ( parameters_->getSize() );
			}

			bool FunctionParametersProperty::setValue ( QString value )
			{
				bool converted;
				UnsignedLong parametersCount;
				parametersCount = value.toULong ( &converted );
				if ( converted && ( parametersCount != parameters_->getSize() ) )
				{
					setParametersCount ( parametersCount );
					return true;
				}
				return false;
			}

			void FunctionParametersProperty::setParametersCount ( UnsignedLong parametersCount )
			{
				if ( parametersCount != parameters_->getSize() )
				{

					if ( parametersCount > parameters_->getSize() )
					{
						const uint parametersCountBeforeResizing = parameters_->getSize();
						( *parameters_ ) = Description ( parametersCount );

						for ( uint i = parametersCountBeforeResizing; i < parametersCount; i++ )
						{
							subpropertyUpdated ( new DescriptionProperty ( parameters_, i, true, this, QString ( QString ( "input " ) + QString::number ( i + 1 ) ).ascii() ) );
						}
					}
					else
					{
						/** @todo write "remove parameter" method */
						( *parameters_ ) = Description ( parametersCount );
					}
					emit updated();
				}
			}

			void FunctionParametersProperty::addParameter()
			{
				setParametersCount ( parameters_->getSize() + 1 );
			}

		}

	}

}
