//                                               -*- C++ -*-
/**
 * @file		FinalVariable.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-21 09:59:47
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "FinalVariable.hxx"

// Qt
#include <qvariant.h>

// OT::UI::GUI
#include "BlockA.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			FinalVariable::FinalVariable ( QOTObject* parent, const char * name ) : Content ( parent, name )
			{
				Block* block = getParentBlock();
				Q_CHECK_PTR ( block );
				if ( ( block != NULL ) && ( block->isA ( "OpenTURNS::UI::GUI::BlockA" ) ) )
				{
					//new BlockFunctionProperty( &numericalMathFunction_, (BlockA*) block, this, "function" );
					variablesAssociationProperty_ = new VariablesAssociationProperty ( &numericalMathFunction_, ( BlockA* ) block, this, "function" );
					variablesAssociationProperty_->setDefaultChoice();
				}

				gradientCalculationProperty_ = new GradientCalculationProperty ( &numericalMathFunction_, this, "gradient calculation" );
				gradientCalculationProperty_->setDefaultChoice();

				hessianCalculationProperty_ = new HessianCalculationProperty ( &numericalMathFunction_, this, "hessian calculation" );
				hessianCalculationProperty_->setDefaultChoice();
			}

			/** Copy constructor */
			FinalVariable::FinalVariable ( const FinalVariable & other, QOTObject* parent ) : Content ( parent )
			{
				assignToMe ( other );
			}

			/** Destructor */
			FinalVariable::~FinalVariable()
			{}

			/** The function that actually realizes assignment between objects */
			void FinalVariable::assignToMe ( const FinalVariable & other )
			{
				Content::assignToMe ( other );
			}

			GradientCalculationProperty* FinalVariable::getGradientCalculationProperty()
			{
				return gradientCalculationProperty_;
			}

			HessianCalculationProperty* FinalVariable::getHessianCalculationProperty()
			{
				return hessianCalculationProperty_;
			}

			NumericalMathFunction FinalVariable::getNumericalMathFunction() const
			{
				return numericalMathFunction_;
			}

			Description FinalVariable::getInputVariables() const
			{
				return variablesAssociationProperty_->getInputVariables();
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

