//                                               -*- C++ -*-
/**
 * @file		EntryVariable.cxx
 * @brief		Store information about an entry variable
 *
 * @author		Romuald Conty
 * @date			2006-06-22
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "EntryVariable.hxx"

#include "NumericalScalarProperty.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			EntryVariable::EntryVariable ( QOTObject* parent, const char * name ) : Content ( parent, name )
			{
				typicalValue_ = 0.0;
				new NumericalScalarProperty ( &typicalValue_, true, this, "typical value" );
			}

			EntryVariable::EntryVariable ( const EntryVariable & other, QOTObject* parent ) : Content ( parent )
			{
				assignToMe ( other );
			}
			/** Comparison operator */
			bool EntryVariable::operator == ( const EntryVariable & other ) const
			{
				return ( ( getName() == other.getName() ) && ( getDescription() == other.getDescription() ) && ( getValue() == other.getValue() ) );
			}

			/** Destructor */
			EntryVariable::~EntryVariable()
			{}

			/** The function that actually realizes assignment between objects */
			void EntryVariable::assignToMe ( const EntryVariable & other )
			{
				Content::assignToMe ( other );
				setValue ( other.getValue() );
			}

			/** EntryVariable value accessor */
			bool EntryVariable::setValue ( const QString& value )
			{
				bool valid = false;
				typicalValue_ = value.stripWhiteSpace().toDouble ( &valid );
				return valid;
			}

			/** EntryVariable value accessor */
			void EntryVariable::setValue ( const double& value )
			{
				typicalValue_ = value;
			}

			double EntryVariable::getValue() const
			{
				return typicalValue_;
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

