//                                               -*- C++ -*-
/**
 * @file		DeterministicCriterion.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-25 12:07:15
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIDETERMINISTICCRITERION_HXX
#define OPENTURNS_GUIDETERMINISTICCRITERION_HXX

//OT::UI::GUI
#include "Criterion.hxx"

// OT
#include "NumericalPoint.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			typedef OT::Base::Type::NumericalPoint NumericalPoint;

			class DeterministicCriterion : public Criterion
			{
					Q_OBJECT

				public:
					/** Default constructor */
					DeterministicCriterion ( QOTObject *parent, const char *name = 0 );

					/** Copy constructor */
					DeterministicCriterion ( const DeterministicCriterion & other, QOTObject* parent );

					/** Destructor */
					virtual ~DeterministicCriterion();

					/** The function that actually realizes assignment between objects */
					void assignToMe ( const DeterministicCriterion & other );

					NumericalPoint getLowerBound() const;
					NumericalPoint getUpperBound() const;
					NumericalPoint getDiscretisation() const;

				protected:
					NumericalPoint lowerBound_;
					NumericalPoint upperBound_;
					NumericalPoint discretisation_;

			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
