//                                               -*- C++ -*-
/**
 * @file		Criterion.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-28 10:15:07
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
//Header
#include "Criterion.hxx"

// OT::UI::GUI
#include "BlockA.hxx"
#include "FinalVariableProperty.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			Criterion::Criterion ( QOTObject *parent, const char *name ) : Content ( parent, name )
			{
				delete Content::actionCopy_;

				BlockA* blockA = ( BlockA* ) getParentBlock();
				finalVariable_ = Description ( 1 );

				QOTProperty* finalVariableProperty = new FinalVariableProperty ( &finalVariable_, 0, blockA, this, "final variable" );
				finalVariableProperty->setDefaultChoice();
			}

			/** Copy constructor */
			Criterion::Criterion ( const Criterion & other, QOTObject* parent ) : Content ( parent )
			{
				assignToMe ( other );
			}

			/** Destructor */
			Criterion::~Criterion()
			{}

			/** The function that actually realizes assignment between objects */
			void Criterion::assignToMe ( const Criterion & other )
			{
				Content::assignToMe ( other );
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

