//                                               -*- C++ -*-
/**
 * @file			Chapter.hxx
 * @brief
 *
 * @author		Romuald Conty
 * @date			2006-07-12 15:26:31
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUICHAPTER_HXX
#define OPENTURNS_GUICHAPTER_HXX

// OT::UI::GUI
#include "QOTObject.hxx"
#include "Block.hxx"

// Qt
#include <qlistview.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class Chapter : public QOTObject
			{
					Q_OBJECT

				public:
					/** Default constructor */
					Chapter ( QOTObject *parent, const char *name, const QStringList contentClassesName );

					/** Destructor */
					~Chapter();

					/** Chapter title accessor */
					void setTitle ( const QString& title );

					/** Chapter title accessor */
					QString getTitle() const;

					/** Chapter fullname (name + title) accessor */
					QString getFullName() const;

					/** Chapter children classes name */
					const QStringList* getChildrenClassesName() const;

					/** Function used to find the parent Block of a Content */
					Block* getParentBlock();

					/** Function used to check if chapter can create a child with class name childrenClassName  */
					bool canCreateChild ( const QString& childrenClassName );

				public slots:
					/** Qt slot, invoked by user, used to create a child to this chapter */
					void createChild();

					/** Qt slot, invoked by user, used to duplicate 'brother' */
					void createChild ( QOTObject * brother );

				signals:
					void childCreated ( QOTObject * otObject );

				protected:
					QString title_;
					QStringList childrenClassesName_;
			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */


#endif
