//                                               -*- C++ -*-
/**
 * @file    BlockB.hxx
 * @brief   BlockB is used to link BlockA's variables to a distribution
 *
 * @author  Romuald Conty
 * @date    2006-08-28 15:04:21
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "BlockB.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			BlockB::BlockB ( QOTObject* parent, const char* name ) : Block ( parent, name )
			{
				blockA_ = NULL;
			}

			BlockB::~BlockB()
			{}

			bool BlockB::setBlockA ( const QString& blockAName )
			{
				QObject * otParent = findParent ( "OpenTURNS::UI::GUI::Study" );
				Q_CHECK_PTR ( otParent );
				if ( otParent != NULL )
				{
					QObjectList * childrenList = new QObjectList();
					( ( QOTObject* ) otParent ) ->getChildren ( childrenList, "OpenTURNS::UI::GUI::BlockA", true, false );
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						if ( ( ( QOTObject* ) childrenList->at ( i ) ) ->getName() == blockAName )
						{
							setBlockA_ptr ( ( BlockA* ) childrenList->at ( i ) );
							return true;
						}
					}
				}
				return false;
			}

			QString BlockB::getBlockA() const
			{
				QString blockAName = "";
				if ( blockA_ != NULL )
				{
					blockAName = blockA_->getName();
				}
				return blockAName;
			}

			void BlockB::setBlockA_ptr ( BlockA* blockA )
			{
				if ( blockA_ != blockA )
				{
					blockA_ = blockA;
					Q_CHECK_PTR ( blockA_ );
					Chapter* entryVariablesChapter = blockA_->getChapter ( "OpenTURNS::UI::GUI::EntryVariable" );
					connect ( entryVariablesChapter, SIGNAL ( childCreated ( QOTObject* ) ), this, SLOT ( createEntryVariableType ( QOTObject* ) ) );

					QObjectList * childrenList = new QObjectList();
					blockA_->getChildren ( childrenList, "OpenTURNS::UI::GUI::EntryVariable", true, false );
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						createEntryVariableType ( ( QOTObject* ) childrenList->at ( i ) );
					}
					emit updated();
				}
			}

			BlockA* BlockB::getBlockA_ptr()
			{
				return blockA_;
			}

			/** BlockB entry variable finder (from entry variable pointer) */
			EntryVariableType* BlockB::findEntryVariableType_ptr ( EntryVariable* entryVariable )
			{
				EntryVariableType* entryVariableType = NULL;
				if ( entryVariable != NULL )
				{
					for ( uint i = 0; i<entryVariableTypes_.count(); i++ )
					{
						if ( entryVariableTypes_.at ( i )->getEntryVariable_ptr() == entryVariable )
						{
							return entryVariableType = entryVariableTypes_.at ( i );
						}
					}
				}
				return entryVariableType;
			}

			/** BlockB entry variable finder (from entry variable name) */
			EntryVariableType* BlockB::findEntryVariableType_ptr ( const QString& entryVariableName )
			{
				EntryVariableType* entryVariableType = NULL;
				if ( entryVariableName != "" )
				{
					for ( uint i = 0; i<entryVariableTypes_.count(); i++ )
					{
						if ( entryVariableTypes_.at ( i )->getEntryVariable_ptr()->getName() == entryVariableName )
						{
							entryVariableType = entryVariableTypes_.at ( i );
							return entryVariableType;
						}
					}
				}
				return entryVariableType;
			}

			/** BlockB entry variable finder (from entry variable type name) */
			EntryVariableType* BlockB::getEntryVariableType_ptr ( const QString& entryVariableTypeName )
			{
				EntryVariableType* entryVariableType = NULL;
				if ( entryVariableTypeName != "" )
				{
					for ( uint i = 0; i<entryVariableTypes_.count(); i++ )
					{
						if ( entryVariableTypes_.at ( i )->getName() == entryVariableTypeName )
						{
							entryVariableType = entryVariableTypes_.at ( i );
							return entryVariableType;
						}
					}
				}
				return entryVariableType;
			}

			void BlockB::createEntryVariableType ( QOTObject* otObject )
			{
				entryVariableTypes_.append ( new EntryVariableType ( this, "EntryVariableType", ( EntryVariable* ) otObject ) );
			}
		} /* namespace GUI */
	} /* namespace UI */
}

