xemacs from openturns import *
from openturns_viewer import ViewImage
from math import *



# BETA 1
beta_1 = Beta(2.0, 3.0, 0.0, 2.0)
pdf_beta_1 =  beta_1.drawPDF()
pdf_beta_1.setTitle("PDF - Beta(r,t,a,b)")
draw = pdf_beta_1.getDrawable(0)
draw.setLegendName("Beta(2.0, 3.0, 0.0, 2.0)")
pdf_beta_1.setDrawable(draw,0)
pdf_beta_1.draw("pdf_Beta_1")
ViewImage(pdf_beta_1.getBitmap())


# BETA 2
beta_2 = Beta(1.0, 2.0, 0.0, 2.0)
pdf_beta_2 =  beta_2.drawPDF()
pdf_beta_2.setTitle("PDF - Beta(r,t,a,b)")
draw = pdf_beta_2.getDrawable(0)
draw.setLegendName("Beta(1.0, 2.0, 0.0, 2.0)")
pdf_beta_2.setDrawable(draw,0)
pdf_beta_2.draw("pdf_Beta_2")
ViewImage(pdf_beta_2.getBitmap())



# BETA 3
beta_3 = Beta(2.0, 4.0, 0.0, 2.0)
pdf_beta_3 =  beta_3.drawPDF()
pdf_beta_3.setTitle("PDF - Beta(r,t,a,b)")
draw = pdf_beta_3.getDrawable(0)
draw.setLegendName("Beta(2.0, 4.0, 0.0, 2.0))")
pdf_beta_3.setDrawable(draw,0)
pdf_beta_3.draw("pdf_Beta_3")
ViewImage(pdf_beta_3.getBitmap())


# BETA 4
beta_4 = Beta(2.0, 2.5, 0.0, 2.0)
pdf_beta_4 =  beta_4.drawPDF()
pdf_beta_4.setTitle("PDF - Beta(r,t,a,b)")
draw = pdf_beta_4.getDrawable(0)
draw.setLegendName("Beta(2.0, 2.5, 0.0, 2.0))")
pdf_beta_4.setDrawable(draw,0)
pdf_beta_4.draw("pdf_Beta_4")
ViewImage(pdf_beta_4.getBitmap())

# BETA 5
beta_5 = Beta(0.5, 1.0, 0.0, 2.0)
pdf_beta_5 =  beta_5.drawPDF()
pdf_beta_5.setTitle("PDF - Beta(r,t,a,b)")
draw = pdf_beta_5.getDrawable(0)
draw.setLegendName("Beta(0.5, 1.0, 0.0, 2.0))")
pdf_beta_5.setDrawable(draw,0)
pdf_beta_5.draw("pdf_Beta_5")
ViewImage(pdf_beta_5.getBitmap())

# BETA 6
beta_6 = Beta(0.5, 2.0, 0.0, 2.0)
pdf_beta_6 =  beta_6.drawPDF()
pdf_beta_6.setTitle("PDF - Beta(r,t,a,b)")
draw = pdf_beta_6.getDrawable(0)
draw.setLegendName("Beta(0.5, 2.0, 0.0, 2.0)")
collDraw= DrawableCollection(1)
collDraw[0] = draw
pdf_beta_6.setDrawable(draw,0)
pdf_beta_6.draw("pdf_Beta_6")
ViewImage(pdf_beta_6.getBitmap())

# BETA 7
beta_7 = Beta(6, 12.0, 0.0, 2.0)
pdf_beta_7 =  beta_7.drawPDF()
pdf_beta_7.setTitle("PDF - Beta(r,t,a,b)")
draw = pdf_beta_7.getDrawable(0)
draw.setLegendName("Beta(6.0, 12.0, 0.0, 2.0)")
pdf_beta_7.setDrawable(draw,0)
pdf_beta_7.draw("pdf_Beta_7")
ViewImage(pdf_beta_7.getBitmap())

# Exponential

exponential = Exponential()
pdf_exponential =  exponential.drawPDF()
pdf_exponential.setTitle("PDF - Exponential(lambda, gamma)")
draw = pdf_exponential.getDrawable(0)
draw.setLegendName("Exponential(1.0, 0.0)")
pdf_exponential.setDrawable(draw,0)
pdf_exponential.draw("pdf_Exponential")
ViewImage(pdf_exponential.getBitmap())


# Gamma

gamma_1 = Gamma()
pdf_gamma_1 =  gamma_1.drawPDF()
pdf_gamma_1.setTitle("PDF - Gamma(k, lambda, gamma)")
draw_1 = pdf_gamma_1.getDrawable(0)
draw_1.setLegendName("Gamma(1.0, 1.0, 0.0)")
pdf_gamma_1.setDrawable(draw_1,0)
pdf_gamma_1.draw("pdf_Gamma_1")
ViewImage(pdf_gamma_1.getBitmap())


gamma_2 = Gamma(2.5, 1.0, 0.0)
pdf_gamma_2 =  gamma_2.drawPDF()
pdf_gamma_2.setTitle("PDF - Gamma(k, lambda, gamma)")
draw_2 = pdf_gamma_2.getDrawable(0)
draw_2.setLegendName("Gamma(2.5, 1.0, 0.0)")
pdf_gamma_2.setDrawable(draw_2,0)
pdf_gamma_2.draw("pdf_Gamma_2")
ViewImage(pdf_gamma_2.getBitmap())



gamma_3 = Gamma(0.5, 1.0, 0.0)
pdf_gamma_3 =  gamma_3.drawPDF()
pdf_gamma_3.setTitle("PDF - Gamma(k, lambda, gamma)")
draw_3 = pdf_gamma_3.getDrawable(0)
draw_3.setLegendName("Gamma(0.5, 1.0, 0.0)")
collDraw_3 = DrawableCollection(1)
collDraw_3[0] = draw_3
pdf_gamma_3.setDrawables(collDraw_3)
pdf_gamma_3.draw("pdf_Gamma_3")
ViewImage(pdf_gamma_3.getBitmap())


# gumbel

gumbel = Gumbel(1.0, 1.0)
pdf_gumbel =  gumbel.drawPDF()
pdf_gumbel.setTitle("PDF - Gumbel(alpha, beta)")
draw = pdf_gumbel.getDrawable(0)
draw.setLegendName("Gumbel(1.0, 1.0)")
pdf_gumbel.setDrawable(draw,0)
pdf_gumbel.draw("pdf_Gumbel")
ViewImage(pdf_gumbel.getBitmap())



# logistic

logistic = Logistic(0.0, 1.0)
pdf_logistic =  logistic.drawPDF()
pdf_logistic.setTitle("PDF - Logistic(alpha, beta)")
draw = pdf_logistic.getDrawable(0)
draw.setLegendName("Logistic(0.0, 1.0)")
pdf_logistic.setDrawable(draw,0)
pdf_logistic.draw("pdf_Logistic")
ViewImage(pdf_logistic.getBitmap())


# logNormal

logNormal = LogNormal(1.0, 0.5, 0.0)
pdf_logNormal =  logNormal.drawPDF()
pdf_logNormal.setTitle("PDF - LogNormal(mu_l, sigma_l, gamma)")
draw = pdf_logNormal.getDrawable(0)
draw.setLegendName("LogNormal(1.0, 0.5, 0.0)")
pdf_logNormal.setDrawable(draw,0)
pdf_logNormal.draw("pdf_LogNormal")
ViewImage(pdf_logNormal.getBitmap())




# NonCentralStudent

nonCentralStudent = NonCentralStudent(4.5, 0.0, 0.0)
pdf_nonCentralStudent =  nonCentralStudent.drawPDF()
pdf_nonCentralStudent.setTitle("PDF - NonCentralStudent(nu, delta, gamma)")
draw = pdf_nonCentralStudent.getDrawable(0)
draw.setLegendName("NonCentralStudent(4.5, 0.0, 0.0)")
pdf_nonCentralStudent.setDrawable(draw,0)
pdf_nonCentralStudent.draw("pdf_NonCentralStudent")
ViewImage(pdf_nonCentralStudent.getBitmap())


# Normal

normal = Normal(2.0, 1.0)
pdf_normal =  normal.drawPDF()
pdf_normal.setTitle("PDF - Normal(mu, sigma)")
draw = pdf_normal.getDrawable(0)
draw.setLegendName("Normal(2.0, 1.0)")
pdf_normal.setDrawable(draw,0)
pdf_normal.draw("pdf_Normal")
ViewImage(pdf_normal.getBitmap())



# Student

student = Student(3.0, 1.0)
pdf_student =  student.drawPDF()
pdf_student.setTitle("PDF - Student(mu, sigma)")
draw = pdf_student.getDrawable(0)
draw.setLegendName("Student(3.0, 1.0)")
pdf_student.setDrawable(draw,0)
pdf_student.draw("pdf_Student")
ViewImage(pdf_student.getBitmap())

# Triangular

triangular = Triangular(1.0, 3.0, 4.0)
pdf_triangular =  triangular.drawPDF()
pdf_triangular.setTitle("PDF - Triangular(a, m, b)")
draw = pdf_triangular.getDrawable(0)
draw.setLegendName("Triangular(1.0, 3.0, 4.0)")
pdf_triangular.setDrawable(draw,0)
pdf_triangular.draw("pdf_Triangular")
ViewImage(pdf_triangular.getBitmap())


# TruncatedNormal

truncatedNormal_1 = TruncatedNormal(2.0, 1.0, 1.5, 2.5)
pdf_truncatedNormal_1 =  truncatedNormal_1.drawPDF()
pdf_truncatedNormal_1.setTitle("PDF - TruncatedNormal(mu_n, sigma_n, a, b)")
draw = pdf_truncatedNormal_1.getDrawable(0)
draw.setLegendName("TruncatedNormal(2.0, 1.0, 1.5, 2.5)")
pdf_truncatedNormal_1.setDrawable(draw,0)
pdf_truncatedNormal_1.draw("pdf_TruncatedNormal_1")
ViewImage(pdf_truncatedNormal_1.getBitmap())



truncatedNormal_2 = TruncatedNormal(2.0, 1.0, -1.0, 5.0)
pdf_truncatedNormal_2 =  truncatedNormal_2.drawPDF()
pdf_truncatedNormal_2.setTitle("PDF - TruncatedNormal(mu_n, sigma_n, a, b)")
draw = pdf_truncatedNormal_2.getDrawable(0)
draw.setLegendName("TruncatedNormal(2.0, 1.0, -1.0, 5.0)")
pdf_truncatedNormal_2.setDrawable(draw,0)
pdf_truncatedNormal_2.draw("pdf_TruncatedNormal_2")
ViewImage(pdf_truncatedNormal_2.getBitmap())


truncatedNormal_3 = TruncatedNormal(2.0, 1.0, 2.0, 5.0)
pdf_truncatedNormal_3 =  truncatedNormal_3.drawPDF()
pdf_truncatedNormal_3.setTitle("PDF - TruncatedNormal(mu_n, sigma_n, a, b)")
draw = pdf_truncatedNormal_3.getDrawable(0)
draw.setLegendName("TruncatedNormal(2.0, 1.0, 2.0, 5.0)")
pdf_truncatedNormal_3.setDrawable(draw,0)
pdf_truncatedNormal_3.draw("pdf_TruncatedNormal_3")
ViewImage(pdf_truncatedNormal_3.getBitmap())


truncatedNormal_4 = TruncatedNormal(2.0, 1.0, 5.0, 8.0)
pdf_truncatedNormal_4 =  truncatedNormal_4.drawPDF()
pdf_truncatedNormal_4.setTitle("PDF - TruncatedNormal(mu_n, sigma_n, a, b)")
draw = pdf_truncatedNormal_4.getDrawable(0)
draw.setLegendName("TruncatedNormal(2.0, 1.0, 5.0, 8.0)")
pdf_truncatedNormal_4.setDrawable(draw,0)
pdf_truncatedNormal_4.draw("pdf_TruncatedNormal_4")
ViewImage(pdf_truncatedNormal_4.getBitmap())


# Uniform

uniform = Uniform(0.0, 1.0)
pdf_uniform =  uniform.drawPDF()
pdf_uniform.setTitle("PDF - Uniform(a, b)")
draw = pdf_uniform.getDrawable(0)
draw.setLegendName("Uniform(0.0, 1.0)")
pdf_uniform.setDrawable(draw,0)
pdf_uniform.draw("pdf_Uniform")
ViewImage(pdf_uniform.getBitmap())


# Weibull

weibull_1 = Weibull(1.0, 1.0, 0.0)
pdf_weibull_1 =  weibull_1.drawPDF()
pdf_weibull_1.setTitle("PDF - Weibull(e, beta, gamma)")
draw_1 = pdf_weibull_1.getDrawable(0)
draw_1.setLegendName("Weibull(1.0, 1.0, 0.0)")
pdf_weibull_1.setDrawable(draw_1,0)
pdf_weibull_1.draw("pdf_Weibull_1")
ViewImage(pdf_weibull_1.getBitmap())


weibull_2 = Weibull(2.0, 1.0, 0.0, Weibull.MUSIGMA)
pdf_weibull_2 =  weibull_2.drawPDF()
pdf_weibull_2.setTitle("PDF - Weibull(mu, sigma, gamma)")
draw_2 = pdf_weibull_2.getDrawable(0)
draw_2.setLegendName("Weibull(2.0, 1.0, 0.0)")
pdf_weibull_2.setDrawable(draw_2,0)
pdf_weibull_2.draw("pdf_Weibull_2")
ViewImage(pdf_weibull_2.getBitmap())
