from openturns import *
from openturns_viewer import ViewImage
from math import *

numCop = 5
collCop = CopulaCollection(numCop)
descCop = Description(numCop)
scaling = NumericalPoint(numCop)
nlevels = UnsignedLongCollection(numCop)

# Graph 1 : Normal copula

R = CorrelationMatrix(2)
R[0,1] = 0.8
collCop[0] = Copula(NormalCopula(R))
descCop[0] = "Normal copula, rho=0.8"
scaling[0] = 0.4
nlevels[0] = 50

# Graph 2 : Frank copula
theta = 9.2
collCop[1] = Copula(FrankCopula(theta))
descCop[1] = "Frank copula, theta=9.2"
scaling[1] = 1.0
nlevels[1] = 50

## Graph 3 : Gumbel copula
theta = 2.5
collCop[2] = Copula(GumbelCopula(theta))
descCop[2] = "Gumbel copula, theta=2.5"
scaling[2] = 0.2
nlevels[2] = 50

## Graph 4 : Clayton copula
theta = 2.5
collCop[3] = Copula(ClaytonCopula(theta))
descCop[3] = "Clayton copula, theta=2.5"
scaling[3] = 0.2
nlevels[3] = 50

## Graph 5 : Independent Copula
collCop[4] = Copula(IndependentCopula(2))
descCop[4] = "Independent copula"
scaling[4] = 1.0
nlevels[4] = 2



# Draw the iso curve

xMin = NumericalPoint(2)
xMin[0] = 0.0
xMin[1] = 0.0
xMax = NumericalPoint(2)
xMax[0] = 1.0
xMax[1] = 1.0
pointNumber = NumericalPoint(2)
pointNumber[0] = 301
pointNumber[1] = 301

for indCop in range(collCop.getSize()):
  copula_isoPDF = collCop[indCop].drawPDF(xMin, xMax, pointNumber)
  contourCopula = copula_isoPDF.getDrawables()[0]
  zmin = contourCopula.getData().getMin()[0]
  zmax = scaling[indCop]*contourCopula.getData().getMax()[0]
  dim = nlevels[indCop]
  levels = NumericalPoint(dim)
  for i in range(dim) :
    levels[i] = zmin + (zmax-zmin)*i/(dim-1.0)
  contourCopula.setLevels(levels)
  copula_isoPDF.setDrawable(contourCopula, 0)
  copula_isoPDF.setTitle(descCop[indCop])
  copula_isoPDF.setLegendPosition("bottomright")
  copula_isoPDF.draw(collCop[indCop].getName())
  ViewImage(copula_isoPDF.getBitmap())

