#                                               -*- Autoconf -*-
#
#  ot_debug.m4
#
#  (C) Copyright 2005-2007 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
#  Id:      $Id: ot_debug.m4 862 2008-06-26 11:50:17Z dutka $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check whether debug statements should be included
#
# OT_DEBUG( level )
# -----------------
#
AC_DEFUN([OT_DEBUG],
[
  AC_ARG_ENABLE([debug],
                AC_HELP_STRING([--enable-debug@<:@=@%:@@:>@], [Add debug information.
	                       Debug level can be specified in the range @<:@0:9@:>@. Default is level ]m4_default([$1],3)[.]),
			       [test x${enableval} = xyes && enableval=m4_default([$1],3)], [enableval=m4_default([$1],3)])
  DEBUG_LEVEL=0

  test $enableval = "no" && enableval=0

  # We test if enableval has only digits
  val=`echo ${enableval} | tr -d "1234567890"`
  if test -z $val
  then
    if test ${enableval} -ge 1 && test ${enableval} -le 9
    then
      DEBUG_LEVEL=${enableval}
      OT_CPPFLAGS=""
      OT_CFLAGS="-g -Wall"
      OT_FFLAGS="-g -Wall"
      OT_CXXFLAGS="-g -Wall"
      AC_SUBST(OT_CPPFLAGS)
      AC_SUBST(OT_CFLAGS)
      AC_SUBST(OT_FFLAGS)
      AC_SUBST(OT_CXXFLAGS)
    fi
  else
    AC_MSG_ERROR([Debug option : invalid argument. Must be a positive integer.])
  fi

  AC_MSG_NOTICE([Debug level is $DEBUG_LEVEL])

  AC_DEFINE_UNQUOTED(OT_DEBUG_LEVEL, $DEBUG_LEVEL, [Add debug information])
])
