/*
 * libopensync - A synchronization framework
 * Copyright (C) 2006  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2006  NetNix Finland Ltd <netnix@netnix.fi>
 * Copyright (C) 2008  Daniel Gollub <gollub@b1-systems.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 * Author: Armin Bauer <armin.bauer@opensync.org>
 * Author: Daniel Friedrich <daniel.friedrich@opensync.org>
 *
 */

#ifndef OPENSYNC_ARCHIVE_PRIVATE_H_
#define OPENSYNC_ARCHIVE_PRIVATE_H_

/**
 * @defgroup OSyncArchivePrivate OpenSync Archive Module Private
 * @ingroup OSyncPrivate
 * @defgroup OSyncArchivePrivateAPI OpenSync Archive Private
 * @ingroup OSyncArchivePrivate
 * @brief The private part of the OSyncArchive API
 *
 */
/*@{*/

/**
 * @brief Represent a Archive object
 */
struct OSyncArchive {
	/** The reference counter for this object */
	int ref_count;
	/**  */
	OSyncDB *db;
	/**  */
};

/*@}*/

#endif /* OPENSYNC_ARCHIVE_PRIVATE_H_ */

