/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGNodePtr.h"
#include "OSGStereoCameraDecorator.h"

OSG_USING_NAMESPACE

/***************************************************************************\
 *                            Description                                  *
\***************************************************************************/

/*! \class osg::StereoCameraDecorator
    \ingroup PageSystemWindowCameraDecoratorsStereo

The abstract base class for stereo camera decorators, see \ref
PageSystemWindowCameraDecoratorsStereo for a description.

The basic parameters are given by the _sfEyeSeparation and _sfLeftEye fields.

*/

/*----------------------- constructors & destructors ----------------------*/

StereoCameraDecorator::StereoCameraDecorator(void) :
    Inherited()
{
}

StereoCameraDecorator::StereoCameraDecorator(const StereoCameraDecorator &source) :
    Inherited(source)
{
}

StereoCameraDecorator::~StereoCameraDecorator(void)
{
}

/*----------------------------- class specific ----------------------------*/

void StereoCameraDecorator::initMethod (void)
{
}

void StereoCameraDecorator::changed(BitVector, UInt32)
{
}

void StereoCameraDecorator::dump(      UInt32    , 
                         const BitVector ) const
{
    SLOG << "Dump StereoCameraDecorator NI" << std::endl;
}


/*-------------------------------------------------------------------------*/
/*                              cvs id's                                   */

#ifdef __sgi
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static char cvsid_cpp[] = "@(#)$Id: $";
    static char cvsid_hpp[] = OSGSTEREOCAMERADECORATOR_HEADER_CVSID;
    static char cvsid_inl[] = OSGSTEREOCAMERADECORATOR_INLINE_CVSID;
}
