/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class TextureChunk
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGTEXTURECHUNKBASE_H_
#define _OSGTEXTURECHUNKBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGStateChunk.h> // Parent

#include <OSGImageFields.h> // Image type
#include <OSGGLenumFields.h> // InternalFormat type
#include <OSGGLenumFields.h> // ExternalFormat type
#include <OSGBoolFields.h> // Scale type
#include <OSGUInt32Fields.h> // Frame type
#include <OSGGLenumFields.h> // MinFilter type
#include <OSGGLenumFields.h> // MagFilter type
#include <OSGGLenumFields.h> // WrapS type
#include <OSGGLenumFields.h> // WrapT type
#include <OSGGLenumFields.h> // WrapR type
#include <OSGGLenumFields.h> // EnvMode type
#include <OSGColor4fFields.h> // EnvColor type
#include <OSGGLenumFields.h> // EnvCombineRGB type
#include <OSGGLenumFields.h> // EnvCombineAlpha type
#include <OSGReal32Fields.h> // EnvScaleRGB type
#include <OSGReal32Fields.h> // EnvScaleAlpha type
#include <OSGGLenumFields.h> // EnvSource0RGB type
#include <OSGGLenumFields.h> // EnvSource1RGB type
#include <OSGGLenumFields.h> // EnvSource2RGB type
#include <OSGGLenumFields.h> // EnvSource0Alpha type
#include <OSGGLenumFields.h> // EnvSource1Alpha type
#include <OSGGLenumFields.h> // EnvSource2Alpha type
#include <OSGGLenumFields.h> // EnvOperand0RGB type
#include <OSGGLenumFields.h> // EnvOperand1RGB type
#include <OSGGLenumFields.h> // EnvOperand2RGB type
#include <OSGGLenumFields.h> // EnvOperand0Alpha type
#include <OSGGLenumFields.h> // EnvOperand1Alpha type
#include <OSGGLenumFields.h> // EnvOperand2Alpha type
#include <OSGGLenumFields.h> // GLId type
#include <OSGInt32Fields.h> // IgnoreGLForAspect type
#include <OSGBoolFields.h> // PointSprite type
#include <OSGReal32Fields.h> // Priority type
#include <OSGGLenumFields.h> // ShaderOperation type
#include <OSGGLenumFields.h> // ShaderInput type
#include <OSGReal32Fields.h> // ShaderOffsetMatrix type
#include <OSGReal32Fields.h> // ShaderOffsetScale type
#include <OSGReal32Fields.h> // ShaderOffsetBias type
#include <OSGGLenumFields.h> // ShaderRGBADotProduct type
#include <OSGUInt8Fields.h> // ShaderCullModes type
#include <OSGVec3fFields.h> // ShaderConstEye type
#include <OSGReal32Fields.h> // LodBias type
#include <OSGGLenumFields.h> // Target type
#include <OSGInt32Fields.h> // DirtyLeft type
#include <OSGInt32Fields.h> // DirtyMinX type
#include <OSGInt32Fields.h> // DirtyMaxX type
#include <OSGInt32Fields.h> // DirtyMinY type
#include <OSGInt32Fields.h> // DirtyMaxY type
#include <OSGInt32Fields.h> // DirtyMinZ type
#include <OSGInt32Fields.h> // DirtyMaxZ type
#include <OSGReal32Fields.h> // Anisotropy type
#include <OSGColor4fFields.h> // BorderColor type
#include <OSGUInt32Fields.h> // BorderWidth type
#include <OSGUInt32Fields.h> // NPOTMatrixScale type

#include <OSGTextureChunkFields.h>

OSG_BEGIN_NAMESPACE

class TextureChunk;
class BinaryDataHandler;

//! \brief TextureChunk Base Class.

class OSG_SYSTEMLIB_DLLMAPPING TextureChunkBase : public StateChunk
{
  private:

    typedef StateChunk    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef TextureChunkPtr  Ptr;

    enum
    {
        ImageFieldId                = Inherited::NextFieldId,
        InternalFormatFieldId       = ImageFieldId                + 1,
        ExternalFormatFieldId       = InternalFormatFieldId       + 1,
        ScaleFieldId                = ExternalFormatFieldId       + 1,
        FrameFieldId                = ScaleFieldId                + 1,
        MinFilterFieldId            = FrameFieldId                + 1,
        MagFilterFieldId            = MinFilterFieldId            + 1,
        WrapSFieldId                = MagFilterFieldId            + 1,
        WrapTFieldId                = WrapSFieldId                + 1,
        WrapRFieldId                = WrapTFieldId                + 1,
        EnvModeFieldId              = WrapRFieldId                + 1,
        EnvColorFieldId             = EnvModeFieldId              + 1,
        EnvCombineRGBFieldId        = EnvColorFieldId             + 1,
        EnvCombineAlphaFieldId      = EnvCombineRGBFieldId        + 1,
        EnvScaleRGBFieldId          = EnvCombineAlphaFieldId      + 1,
        EnvScaleAlphaFieldId        = EnvScaleRGBFieldId          + 1,
        EnvSource0RGBFieldId        = EnvScaleAlphaFieldId        + 1,
        EnvSource1RGBFieldId        = EnvSource0RGBFieldId        + 1,
        EnvSource2RGBFieldId        = EnvSource1RGBFieldId        + 1,
        EnvSource0AlphaFieldId      = EnvSource2RGBFieldId        + 1,
        EnvSource1AlphaFieldId      = EnvSource0AlphaFieldId      + 1,
        EnvSource2AlphaFieldId      = EnvSource1AlphaFieldId      + 1,
        EnvOperand0RGBFieldId       = EnvSource2AlphaFieldId      + 1,
        EnvOperand1RGBFieldId       = EnvOperand0RGBFieldId       + 1,
        EnvOperand2RGBFieldId       = EnvOperand1RGBFieldId       + 1,
        EnvOperand0AlphaFieldId     = EnvOperand2RGBFieldId       + 1,
        EnvOperand1AlphaFieldId     = EnvOperand0AlphaFieldId     + 1,
        EnvOperand2AlphaFieldId     = EnvOperand1AlphaFieldId     + 1,
        GLIdFieldId                 = EnvOperand2AlphaFieldId     + 1,
        IgnoreGLForAspectFieldId    = GLIdFieldId                 + 1,
        PointSpriteFieldId          = IgnoreGLForAspectFieldId    + 1,
        PriorityFieldId             = PointSpriteFieldId          + 1,
        ShaderOperationFieldId      = PriorityFieldId             + 1,
        ShaderInputFieldId          = ShaderOperationFieldId      + 1,
        ShaderOffsetMatrixFieldId   = ShaderInputFieldId          + 1,
        ShaderOffsetScaleFieldId    = ShaderOffsetMatrixFieldId   + 1,
        ShaderOffsetBiasFieldId     = ShaderOffsetScaleFieldId    + 1,
        ShaderRGBADotProductFieldId = ShaderOffsetBiasFieldId     + 1,
        ShaderCullModesFieldId      = ShaderRGBADotProductFieldId + 1,
        ShaderConstEyeFieldId       = ShaderCullModesFieldId      + 1,
        LodBiasFieldId              = ShaderConstEyeFieldId       + 1,
        TargetFieldId               = LodBiasFieldId              + 1,
        DirtyLeftFieldId            = TargetFieldId               + 1,
        DirtyMinXFieldId            = DirtyLeftFieldId            + 1,
        DirtyMaxXFieldId            = DirtyMinXFieldId            + 1,
        DirtyMinYFieldId            = DirtyMaxXFieldId            + 1,
        DirtyMaxYFieldId            = DirtyMinYFieldId            + 1,
        DirtyMinZFieldId            = DirtyMaxYFieldId            + 1,
        DirtyMaxZFieldId            = DirtyMinZFieldId            + 1,
        AnisotropyFieldId           = DirtyMaxZFieldId            + 1,
        BorderColorFieldId          = AnisotropyFieldId           + 1,
        BorderWidthFieldId          = BorderColorFieldId          + 1,
        NPOTMatrixScaleFieldId      = BorderWidthFieldId          + 1,
        NextFieldId                 = NPOTMatrixScaleFieldId      + 1
    };

    static const OSG::BitVector ImageFieldMask;
    static const OSG::BitVector InternalFormatFieldMask;
    static const OSG::BitVector ExternalFormatFieldMask;
    static const OSG::BitVector ScaleFieldMask;
    static const OSG::BitVector FrameFieldMask;
    static const OSG::BitVector MinFilterFieldMask;
    static const OSG::BitVector MagFilterFieldMask;
    static const OSG::BitVector WrapSFieldMask;
    static const OSG::BitVector WrapTFieldMask;
    static const OSG::BitVector WrapRFieldMask;
    static const OSG::BitVector EnvModeFieldMask;
    static const OSG::BitVector EnvColorFieldMask;
    static const OSG::BitVector EnvCombineRGBFieldMask;
    static const OSG::BitVector EnvCombineAlphaFieldMask;
    static const OSG::BitVector EnvScaleRGBFieldMask;
    static const OSG::BitVector EnvScaleAlphaFieldMask;
    static const OSG::BitVector EnvSource0RGBFieldMask;
    static const OSG::BitVector EnvSource1RGBFieldMask;
    static const OSG::BitVector EnvSource2RGBFieldMask;
    static const OSG::BitVector EnvSource0AlphaFieldMask;
    static const OSG::BitVector EnvSource1AlphaFieldMask;
    static const OSG::BitVector EnvSource2AlphaFieldMask;
    static const OSG::BitVector EnvOperand0RGBFieldMask;
    static const OSG::BitVector EnvOperand1RGBFieldMask;
    static const OSG::BitVector EnvOperand2RGBFieldMask;
    static const OSG::BitVector EnvOperand0AlphaFieldMask;
    static const OSG::BitVector EnvOperand1AlphaFieldMask;
    static const OSG::BitVector EnvOperand2AlphaFieldMask;
    static const OSG::BitVector GLIdFieldMask;
    static const OSG::BitVector IgnoreGLForAspectFieldMask;
    static const OSG::BitVector PointSpriteFieldMask;
    static const OSG::BitVector PriorityFieldMask;
    static const OSG::BitVector ShaderOperationFieldMask;
    static const OSG::BitVector ShaderInputFieldMask;
    static const OSG::BitVector ShaderOffsetMatrixFieldMask;
    static const OSG::BitVector ShaderOffsetScaleFieldMask;
    static const OSG::BitVector ShaderOffsetBiasFieldMask;
    static const OSG::BitVector ShaderRGBADotProductFieldMask;
    static const OSG::BitVector ShaderCullModesFieldMask;
    static const OSG::BitVector ShaderConstEyeFieldMask;
    static const OSG::BitVector LodBiasFieldMask;
    static const OSG::BitVector TargetFieldMask;
    static const OSG::BitVector DirtyLeftFieldMask;
    static const OSG::BitVector DirtyMinXFieldMask;
    static const OSG::BitVector DirtyMaxXFieldMask;
    static const OSG::BitVector DirtyMinYFieldMask;
    static const OSG::BitVector DirtyMaxYFieldMask;
    static const OSG::BitVector DirtyMinZFieldMask;
    static const OSG::BitVector DirtyMaxZFieldMask;
    static const OSG::BitVector AnisotropyFieldMask;
    static const OSG::BitVector BorderColorFieldMask;
    static const OSG::BitVector BorderWidthFieldMask;
    static const OSG::BitVector NPOTMatrixScaleFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFImagePtr          *getSFImage          (void);
           SFGLenum            *getSFInternalFormat (void);
           SFGLenum            *getSFExternalFormat (void);
           SFBool              *getSFScale          (void);
           SFUInt32            *getSFFrame          (void);
           SFGLenum            *getSFMinFilter      (void);
           SFGLenum            *getSFMagFilter      (void);
           SFGLenum            *getSFWrapS          (void);
           SFGLenum            *getSFWrapT          (void);
           SFGLenum            *getSFWrapR          (void);
           SFGLenum            *getSFEnvMode        (void);
           SFColor4f           *getSFEnvColor       (void);
           SFGLenum            *getSFEnvCombineRGB  (void);
           SFGLenum            *getSFEnvCombineAlpha(void);
           SFReal32            *getSFEnvScaleRGB    (void);
           SFReal32            *getSFEnvScaleAlpha  (void);
           SFGLenum            *getSFEnvSource0RGB  (void);
           SFGLenum            *getSFEnvSource1RGB  (void);
           SFGLenum            *getSFEnvSource2RGB  (void);
           SFGLenum            *getSFEnvSource0Alpha(void);
           SFGLenum            *getSFEnvSource1Alpha(void);
           SFGLenum            *getSFEnvSource2Alpha(void);
           SFGLenum            *getSFEnvOperand0RGB (void);
           SFGLenum            *getSFEnvOperand1RGB (void);
           SFGLenum            *getSFEnvOperand2RGB (void);
           SFGLenum            *getSFEnvOperand0Alpha(void);
           SFGLenum            *getSFEnvOperand1Alpha(void);
           SFGLenum            *getSFEnvOperand2Alpha(void);
           SFGLenum            *getSFGLId           (void);
           SFInt32             *getSFIgnoreGLForAspect(void);
           SFBool              *getSFPointSprite    (void);
           SFReal32            *getSFPriority       (void);
           SFGLenum            *getSFShaderOperation(void);
           SFGLenum            *getSFShaderInput    (void);
           MFReal32            *getMFShaderOffsetMatrix(void);
           SFReal32            *getSFShaderOffsetScale(void);
           SFReal32            *getSFShaderOffsetBias(void);
           SFGLenum            *getSFShaderRGBADotProduct(void);
           SFUInt8             *getSFShaderCullModes(void);
           SFVec3f             *getSFShaderConstEye (void);
           SFReal32            *getSFLodBias        (void);
           SFGLenum            *getSFTarget         (void);
           SFInt32             *getSFDirtyLeft      (void);
           SFInt32             *getSFDirtyMinX      (void);
           SFInt32             *getSFDirtyMaxX      (void);
           SFInt32             *getSFDirtyMinY      (void);
           SFInt32             *getSFDirtyMaxY      (void);
           SFInt32             *getSFDirtyMinZ      (void);
           SFInt32             *getSFDirtyMaxZ      (void);
           SFReal32            *getSFAnisotropy     (void);
           SFColor4f           *getSFBorderColor    (void);
           SFUInt32            *getSFBorderWidth    (void);
           SFUInt32            *getSFNPOTMatrixScale(void);

           ImagePtr            &getImage          (void);
     const ImagePtr            &getImage          (void) const;
           GLenum              &getInternalFormat (void);
     const GLenum              &getInternalFormat (void) const;
           GLenum              &getExternalFormat (void);
     const GLenum              &getExternalFormat (void) const;
           bool                &getScale          (void);
     const bool                &getScale          (void) const;
           UInt32              &getFrame          (void);
     const UInt32              &getFrame          (void) const;
           GLenum              &getMinFilter      (void);
     const GLenum              &getMinFilter      (void) const;
           GLenum              &getMagFilter      (void);
     const GLenum              &getMagFilter      (void) const;
           GLenum              &getWrapS          (void);
     const GLenum              &getWrapS          (void) const;
           GLenum              &getWrapT          (void);
     const GLenum              &getWrapT          (void) const;
           GLenum              &getWrapR          (void);
     const GLenum              &getWrapR          (void) const;
           GLenum              &getEnvMode        (void);
     const GLenum              &getEnvMode        (void) const;
           Color4f             &getEnvColor       (void);
     const Color4f             &getEnvColor       (void) const;
           GLenum              &getEnvCombineRGB  (void);
     const GLenum              &getEnvCombineRGB  (void) const;
           GLenum              &getEnvCombineAlpha(void);
     const GLenum              &getEnvCombineAlpha(void) const;
           Real32              &getEnvScaleRGB    (void);
     const Real32              &getEnvScaleRGB    (void) const;
           Real32              &getEnvScaleAlpha  (void);
     const Real32              &getEnvScaleAlpha  (void) const;
           GLenum              &getEnvSource0RGB  (void);
     const GLenum              &getEnvSource0RGB  (void) const;
           GLenum              &getEnvSource1RGB  (void);
     const GLenum              &getEnvSource1RGB  (void) const;
           GLenum              &getEnvSource2RGB  (void);
     const GLenum              &getEnvSource2RGB  (void) const;
           GLenum              &getEnvSource0Alpha(void);
     const GLenum              &getEnvSource0Alpha(void) const;
           GLenum              &getEnvSource1Alpha(void);
     const GLenum              &getEnvSource1Alpha(void) const;
           GLenum              &getEnvSource2Alpha(void);
     const GLenum              &getEnvSource2Alpha(void) const;
           GLenum              &getEnvOperand0RGB (void);
     const GLenum              &getEnvOperand0RGB (void) const;
           GLenum              &getEnvOperand1RGB (void);
     const GLenum              &getEnvOperand1RGB (void) const;
           GLenum              &getEnvOperand2RGB (void);
     const GLenum              &getEnvOperand2RGB (void) const;
           GLenum              &getEnvOperand0Alpha(void);
     const GLenum              &getEnvOperand0Alpha(void) const;
           GLenum              &getEnvOperand1Alpha(void);
     const GLenum              &getEnvOperand1Alpha(void) const;
           GLenum              &getEnvOperand2Alpha(void);
     const GLenum              &getEnvOperand2Alpha(void) const;
           GLenum              &getGLId           (void);
     const GLenum              &getGLId           (void) const;
           Int32               &getIgnoreGLForAspect(void);
     const Int32               &getIgnoreGLForAspect(void) const;
           bool                &getPointSprite    (void);
     const bool                &getPointSprite    (void) const;
           Real32              &getPriority       (void);
     const Real32              &getPriority       (void) const;
           GLenum              &getShaderOperation(void);
     const GLenum              &getShaderOperation(void) const;
           GLenum              &getShaderInput    (void);
     const GLenum              &getShaderInput    (void) const;
           Real32              &getShaderOffsetScale(void);
     const Real32              &getShaderOffsetScale(void) const;
           Real32              &getShaderOffsetBias(void);
     const Real32              &getShaderOffsetBias(void) const;
           GLenum              &getShaderRGBADotProduct(void);
     const GLenum              &getShaderRGBADotProduct(void) const;
           UInt8               &getShaderCullModes(void);
     const UInt8               &getShaderCullModes(void) const;
           Vec3f               &getShaderConstEye (void);
     const Vec3f               &getShaderConstEye (void) const;
           Real32              &getLodBias        (void);
     const Real32              &getLodBias        (void) const;
           GLenum              &getTarget         (void);
     const GLenum              &getTarget         (void) const;
           Int32               &getDirtyLeft      (void);
     const Int32               &getDirtyLeft      (void) const;
           Int32               &getDirtyMinX      (void);
     const Int32               &getDirtyMinX      (void) const;
           Int32               &getDirtyMaxX      (void);
     const Int32               &getDirtyMaxX      (void) const;
           Int32               &getDirtyMinY      (void);
     const Int32               &getDirtyMinY      (void) const;
           Int32               &getDirtyMaxY      (void);
     const Int32               &getDirtyMaxY      (void) const;
           Int32               &getDirtyMinZ      (void);
     const Int32               &getDirtyMinZ      (void) const;
           Int32               &getDirtyMaxZ      (void);
     const Int32               &getDirtyMaxZ      (void) const;
           Real32              &getAnisotropy     (void);
     const Real32              &getAnisotropy     (void) const;
           Color4f             &getBorderColor    (void);
     const Color4f             &getBorderColor    (void) const;
           UInt32              &getBorderWidth    (void);
     const UInt32              &getBorderWidth    (void) const;
           UInt32              &getNPOTMatrixScale(void);
     const UInt32              &getNPOTMatrixScale(void) const;
           Real32              &getShaderOffsetMatrix(const UInt32 index);
           MFReal32            &getShaderOffsetMatrix(void);
     const MFReal32            &getShaderOffsetMatrix(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setImage          ( const ImagePtr &value );
     void setInternalFormat ( const GLenum &value );
     void setExternalFormat ( const GLenum &value );
     void setScale          ( const bool &value );
     void setFrame          ( const UInt32 &value );
     void setMinFilter      ( const GLenum &value );
     void setMagFilter      ( const GLenum &value );
     void setWrapS          ( const GLenum &value );
     void setWrapT          ( const GLenum &value );
     void setWrapR          ( const GLenum &value );
     void setEnvMode        ( const GLenum &value );
     void setEnvColor       ( const Color4f &value );
     void setEnvCombineRGB  ( const GLenum &value );
     void setEnvCombineAlpha( const GLenum &value );
     void setEnvScaleRGB    ( const Real32 &value );
     void setEnvScaleAlpha  ( const Real32 &value );
     void setEnvSource0RGB  ( const GLenum &value );
     void setEnvSource1RGB  ( const GLenum &value );
     void setEnvSource2RGB  ( const GLenum &value );
     void setEnvSource0Alpha( const GLenum &value );
     void setEnvSource1Alpha( const GLenum &value );
     void setEnvSource2Alpha( const GLenum &value );
     void setEnvOperand0RGB ( const GLenum &value );
     void setEnvOperand1RGB ( const GLenum &value );
     void setEnvOperand2RGB ( const GLenum &value );
     void setEnvOperand0Alpha( const GLenum &value );
     void setEnvOperand1Alpha( const GLenum &value );
     void setEnvOperand2Alpha( const GLenum &value );
     void setGLId           ( const GLenum &value );
     void setIgnoreGLForAspect( const Int32 &value );
     void setPointSprite    ( const bool &value );
     void setPriority       ( const Real32 &value );
     void setShaderOperation( const GLenum &value );
     void setShaderInput    ( const GLenum &value );
     void setShaderOffsetScale( const Real32 &value );
     void setShaderOffsetBias( const Real32 &value );
     void setShaderRGBADotProduct( const GLenum &value );
     void setShaderCullModes( const UInt8 &value );
     void setShaderConstEye ( const Vec3f &value );
     void setLodBias        ( const Real32 &value );
     void setTarget         ( const GLenum &value );
     void setDirtyLeft      ( const Int32 &value );
     void setDirtyMinX      ( const Int32 &value );
     void setDirtyMaxX      ( const Int32 &value );
     void setDirtyMinY      ( const Int32 &value );
     void setDirtyMaxY      ( const Int32 &value );
     void setDirtyMinZ      ( const Int32 &value );
     void setDirtyMaxZ      ( const Int32 &value );
     void setAnisotropy     ( const Real32 &value );
     void setBorderColor    ( const Color4f &value );
     void setBorderWidth    ( const UInt32 &value );
     void setNPOTMatrixScale( const UInt32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  TextureChunkPtr      create          (void); 
    static  TextureChunkPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFImagePtr          _sfImage;
    SFGLenum            _sfInternalFormat;
    SFGLenum            _sfExternalFormat;
    SFBool              _sfScale;
    SFUInt32            _sfFrame;
    SFGLenum            _sfMinFilter;
    SFGLenum            _sfMagFilter;
    SFGLenum            _sfWrapS;
    SFGLenum            _sfWrapT;
    SFGLenum            _sfWrapR;
    SFGLenum            _sfEnvMode;
    SFColor4f           _sfEnvColor;
    SFGLenum            _sfEnvCombineRGB;
    SFGLenum            _sfEnvCombineAlpha;
    SFReal32            _sfEnvScaleRGB;
    SFReal32            _sfEnvScaleAlpha;
    SFGLenum            _sfEnvSource0RGB;
    SFGLenum            _sfEnvSource1RGB;
    SFGLenum            _sfEnvSource2RGB;
    SFGLenum            _sfEnvSource0Alpha;
    SFGLenum            _sfEnvSource1Alpha;
    SFGLenum            _sfEnvSource2Alpha;
    SFGLenum            _sfEnvOperand0RGB;
    SFGLenum            _sfEnvOperand1RGB;
    SFGLenum            _sfEnvOperand2RGB;
    SFGLenum            _sfEnvOperand0Alpha;
    SFGLenum            _sfEnvOperand1Alpha;
    SFGLenum            _sfEnvOperand2Alpha;
    SFGLenum            _sfGLId;
    SFInt32             _sfIgnoreGLForAspect;
    SFBool              _sfPointSprite;
    SFReal32            _sfPriority;
    SFGLenum            _sfShaderOperation;
    SFGLenum            _sfShaderInput;
    MFReal32            _mfShaderOffsetMatrix;
    SFReal32            _sfShaderOffsetScale;
    SFReal32            _sfShaderOffsetBias;
    SFGLenum            _sfShaderRGBADotProduct;
    SFUInt8             _sfShaderCullModes;
    SFVec3f             _sfShaderConstEye;
    SFReal32            _sfLodBias;
    SFGLenum            _sfTarget;
    SFInt32             _sfDirtyLeft;
    SFInt32             _sfDirtyMinX;
    SFInt32             _sfDirtyMaxX;
    SFInt32             _sfDirtyMinY;
    SFInt32             _sfDirtyMaxY;
    SFInt32             _sfDirtyMinZ;
    SFInt32             _sfDirtyMaxZ;
    SFReal32            _sfAnisotropy;
    SFColor4f           _sfBorderColor;
    SFUInt32            _sfBorderWidth;
    SFUInt32            _sfNPOTMatrixScale;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    TextureChunkBase(void);
    TextureChunkBase(const TextureChunkBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~TextureChunkBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      TextureChunkBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      TextureChunkBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const TextureChunkBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef TextureChunkBase *TextureChunkBaseP;

typedef osgIF<TextureChunkBase::isNodeCore,
              CoredNodePtr<TextureChunk>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet TextureChunkNodePtr;

typedef RefPtr<TextureChunkPtr> TextureChunkRefPtr;

OSG_END_NAMESPACE

#define OSGTEXTURECHUNKBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGTEXTURECHUNKBASE_H_ */
