/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class BalancedMultiWindow
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGBALANCEDMULTIWINDOWBASE_H_
#define _OSGBALANCEDMULTIWINDOWBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include "OSGSystemDef.h"

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGMultiDisplayWindow.h> // Parent

#include <OSGBoolFields.h> // Balance type
#include <OSGBoolFields.h> // BestCut type
#include <OSGBoolFields.h> // ShowBalancing type
#include <OSGUInt32Fields.h> // TileSize type
#include <OSGBoolFields.h> // Short type

#include "OSGBalancedMultiWindowFields.h"

OSG_BEGIN_NAMESPACE

class BalancedMultiWindow;
class BinaryDataHandler;

//! \brief BalancedMultiWindow Base Class.

class OSG_SYSTEMLIB_DLLMAPPING BalancedMultiWindowBase : public MultiDisplayWindow
{
  private:

    typedef MultiDisplayWindow    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef BalancedMultiWindowPtr  Ptr;

    enum
    {
        BalanceFieldId       = Inherited::NextFieldId,
        BestCutFieldId       = BalanceFieldId       + 1,
        ShowBalancingFieldId = BestCutFieldId       + 1,
        TileSizeFieldId      = ShowBalancingFieldId + 1,
        ShortFieldId         = TileSizeFieldId      + 1,
        NextFieldId          = ShortFieldId         + 1
    };

    static const OSG::BitVector BalanceFieldMask;
    static const OSG::BitVector BestCutFieldMask;
    static const OSG::BitVector ShowBalancingFieldMask;
    static const OSG::BitVector TileSizeFieldMask;
    static const OSG::BitVector ShortFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFBool              *getSFBalance        (void);
           SFBool              *getSFBestCut        (void);
           SFBool              *getSFShowBalancing  (void);
           SFUInt32            *getSFTileSize       (void);
           SFBool              *getSFShort          (void);

           bool                &getBalance        (void);
     const bool                &getBalance        (void) const;
           bool                &getBestCut        (void);
     const bool                &getBestCut        (void) const;
           bool                &getShowBalancing  (void);
     const bool                &getShowBalancing  (void) const;
           UInt32              &getTileSize       (void);
     const UInt32              &getTileSize       (void) const;
           bool                &getShort          (void);
     const bool                &getShort          (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setBalance        ( const bool &value );
     void setBestCut        ( const bool &value );
     void setShowBalancing  ( const bool &value );
     void setTileSize       ( const UInt32 &value );
     void setShort          ( const bool &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  BalancedMultiWindowPtr      create          (void); 
    static  BalancedMultiWindowPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFBool              _sfBalance;
    SFBool              _sfBestCut;
    SFBool              _sfShowBalancing;
    SFUInt32            _sfTileSize;
    SFBool              _sfShort;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    BalancedMultiWindowBase(void);
    BalancedMultiWindowBase(const BalancedMultiWindowBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~BalancedMultiWindowBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      BalancedMultiWindowBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      BalancedMultiWindowBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const BalancedMultiWindowBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef BalancedMultiWindowBase *BalancedMultiWindowBaseP;

typedef osgIF<BalancedMultiWindowBase::isNodeCore,
              CoredNodePtr<BalancedMultiWindow>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet BalancedMultiWindowNodePtr;

typedef RefPtr<BalancedMultiWindowPtr> BalancedMultiWindowRefPtr;

OSG_END_NAMESPACE

#define OSGBALANCEDMULTIWINDOWBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGBALANCEDMULTIWINDOWBASE_H_ */
