/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class AVCodecGrabForeground!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEAVCODECGRABFOREGROUNDINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGAVCodecGrabForegroundBase.h"
#include "OSGAVCodecGrabForeground.h"


OSG_USING_NAMESPACE

const OSG::BitVector  AVCodecGrabForegroundBase::ActiveFieldMask = 
    (TypeTraits<BitVector>::One << AVCodecGrabForegroundBase::ActiveFieldId);

const OSG::BitVector  AVCodecGrabForegroundBase::NameFieldMask = 
    (TypeTraits<BitVector>::One << AVCodecGrabForegroundBase::NameFieldId);

const OSG::BitVector  AVCodecGrabForegroundBase::KbitFieldMask = 
    (TypeTraits<BitVector>::One << AVCodecGrabForegroundBase::KbitFieldId);

const OSG::BitVector  AVCodecGrabForegroundBase::FpsFieldMask = 
    (TypeTraits<BitVector>::One << AVCodecGrabForegroundBase::FpsFieldId);

const OSG::BitVector  AVCodecGrabForegroundBase::CodecidFieldMask = 
    (TypeTraits<BitVector>::One << AVCodecGrabForegroundBase::CodecidFieldId);

const OSG::BitVector  AVCodecGrabForegroundBase::FlipFieldMask = 
    (TypeTraits<BitVector>::One << AVCodecGrabForegroundBase::FlipFieldId);

const OSG::BitVector  AVCodecGrabForegroundBase::AutoWriteFieldMask = 
    (TypeTraits<BitVector>::One << AVCodecGrabForegroundBase::AutoWriteFieldId);

const OSG::BitVector AVCodecGrabForegroundBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var bool            AVCodecGrabForegroundBase::_sfActive
    Activate the grabber.
*/
/*! \var std::string     AVCodecGrabForegroundBase::_sfName
    The filename template. %d is replaced by the frame number.
*/
/*! \var UInt32          AVCodecGrabForegroundBase::_sfKbit
    The data rate to use in kbit.
*/
/*! \var UInt32          AVCodecGrabForegroundBase::_sfFps
    The frame rate to use in fps.
*/
/*! \var UInt32          AVCodecGrabForegroundBase::_sfCodecid
    The codecid to use. See avcodec.h fore options.
*/
/*! \var bool            AVCodecGrabForegroundBase::_sfFlip
    Flag to flip frames before encode them.
*/
/*! \var bool            AVCodecGrabForegroundBase::_sfAutoWrite
    Flag to start/stop automatic writing after each grab.
*/

//! AVCodecGrabForeground description

FieldDescription *AVCodecGrabForegroundBase::_desc[] = 
{
    new FieldDescription(SFBool::getClassType(), 
                     "active", 
                     ActiveFieldId, ActiveFieldMask,
                     false,
                     (FieldAccessMethod) &AVCodecGrabForegroundBase::getSFActive),
    new FieldDescription(SFString::getClassType(), 
                     "name", 
                     NameFieldId, NameFieldMask,
                     false,
                     (FieldAccessMethod) &AVCodecGrabForegroundBase::getSFName),
    new FieldDescription(SFUInt32::getClassType(), 
                     "kbit", 
                     KbitFieldId, KbitFieldMask,
                     false,
                     (FieldAccessMethod) &AVCodecGrabForegroundBase::getSFKbit),
    new FieldDescription(SFUInt32::getClassType(), 
                     "fps", 
                     FpsFieldId, FpsFieldMask,
                     false,
                     (FieldAccessMethod) &AVCodecGrabForegroundBase::getSFFps),
    new FieldDescription(SFUInt32::getClassType(), 
                     "codecid", 
                     CodecidFieldId, CodecidFieldMask,
                     false,
                     (FieldAccessMethod) &AVCodecGrabForegroundBase::getSFCodecid),
    new FieldDescription(SFBool::getClassType(), 
                     "flip", 
                     FlipFieldId, FlipFieldMask,
                     false,
                     (FieldAccessMethod) &AVCodecGrabForegroundBase::getSFFlip),
    new FieldDescription(SFBool::getClassType(), 
                     "autoWrite", 
                     AutoWriteFieldId, AutoWriteFieldMask,
                     false,
                     (FieldAccessMethod) &AVCodecGrabForegroundBase::getSFAutoWrite)
};


FieldContainerType AVCodecGrabForegroundBase::_type(
    "AVCodecGrabForeground",
    "GrabForeground",
    NULL,
    (PrototypeCreateF) &AVCodecGrabForegroundBase::createEmpty,
    AVCodecGrabForeground::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(AVCodecGrabForegroundBase, AVCodecGrabForegroundPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &AVCodecGrabForegroundBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &AVCodecGrabForegroundBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr AVCodecGrabForegroundBase::shallowCopy(void) const 
{ 
    AVCodecGrabForegroundPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const AVCodecGrabForeground *>(this)); 

    return returnValue; 
}

UInt32 AVCodecGrabForegroundBase::getContainerSize(void) const 
{ 
    return sizeof(AVCodecGrabForeground); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void AVCodecGrabForegroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((AVCodecGrabForegroundBase *) &other, whichField);
}
#else
void AVCodecGrabForegroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((AVCodecGrabForegroundBase *) &other, whichField, sInfo);
}
void AVCodecGrabForegroundBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void AVCodecGrabForegroundBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

AVCodecGrabForegroundBase::AVCodecGrabForegroundBase(void) :
    _sfActive                 (bool(false)), 
    _sfName                   (), 
    _sfKbit                   (UInt32(1400)), 
    _sfFps                    (UInt32(25)), 
    _sfCodecid                (UInt32(0)), 
    _sfFlip                   (bool(true)), 
    _sfAutoWrite              (bool(true)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

AVCodecGrabForegroundBase::AVCodecGrabForegroundBase(const AVCodecGrabForegroundBase &source) :
    _sfActive                 (source._sfActive                 ), 
    _sfName                   (source._sfName                   ), 
    _sfKbit                   (source._sfKbit                   ), 
    _sfFps                    (source._sfFps                    ), 
    _sfCodecid                (source._sfCodecid                ), 
    _sfFlip                   (source._sfFlip                   ), 
    _sfAutoWrite              (source._sfAutoWrite              ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

AVCodecGrabForegroundBase::~AVCodecGrabForegroundBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 AVCodecGrabForegroundBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ActiveFieldMask & whichField))
    {
        returnValue += _sfActive.getBinSize();
    }

    if(FieldBits::NoField != (NameFieldMask & whichField))
    {
        returnValue += _sfName.getBinSize();
    }

    if(FieldBits::NoField != (KbitFieldMask & whichField))
    {
        returnValue += _sfKbit.getBinSize();
    }

    if(FieldBits::NoField != (FpsFieldMask & whichField))
    {
        returnValue += _sfFps.getBinSize();
    }

    if(FieldBits::NoField != (CodecidFieldMask & whichField))
    {
        returnValue += _sfCodecid.getBinSize();
    }

    if(FieldBits::NoField != (FlipFieldMask & whichField))
    {
        returnValue += _sfFlip.getBinSize();
    }

    if(FieldBits::NoField != (AutoWriteFieldMask & whichField))
    {
        returnValue += _sfAutoWrite.getBinSize();
    }


    return returnValue;
}

void AVCodecGrabForegroundBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ActiveFieldMask & whichField))
    {
        _sfActive.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NameFieldMask & whichField))
    {
        _sfName.copyToBin(pMem);
    }

    if(FieldBits::NoField != (KbitFieldMask & whichField))
    {
        _sfKbit.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FpsFieldMask & whichField))
    {
        _sfFps.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CodecidFieldMask & whichField))
    {
        _sfCodecid.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FlipFieldMask & whichField))
    {
        _sfFlip.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoWriteFieldMask & whichField))
    {
        _sfAutoWrite.copyToBin(pMem);
    }


}

void AVCodecGrabForegroundBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ActiveFieldMask & whichField))
    {
        _sfActive.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NameFieldMask & whichField))
    {
        _sfName.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (KbitFieldMask & whichField))
    {
        _sfKbit.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FpsFieldMask & whichField))
    {
        _sfFps.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CodecidFieldMask & whichField))
    {
        _sfCodecid.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FlipFieldMask & whichField))
    {
        _sfFlip.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoWriteFieldMask & whichField))
    {
        _sfAutoWrite.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void AVCodecGrabForegroundBase::executeSyncImpl(      AVCodecGrabForegroundBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ActiveFieldMask & whichField))
        _sfActive.syncWith(pOther->_sfActive);

    if(FieldBits::NoField != (NameFieldMask & whichField))
        _sfName.syncWith(pOther->_sfName);

    if(FieldBits::NoField != (KbitFieldMask & whichField))
        _sfKbit.syncWith(pOther->_sfKbit);

    if(FieldBits::NoField != (FpsFieldMask & whichField))
        _sfFps.syncWith(pOther->_sfFps);

    if(FieldBits::NoField != (CodecidFieldMask & whichField))
        _sfCodecid.syncWith(pOther->_sfCodecid);

    if(FieldBits::NoField != (FlipFieldMask & whichField))
        _sfFlip.syncWith(pOther->_sfFlip);

    if(FieldBits::NoField != (AutoWriteFieldMask & whichField))
        _sfAutoWrite.syncWith(pOther->_sfAutoWrite);


}
#else
void AVCodecGrabForegroundBase::executeSyncImpl(      AVCodecGrabForegroundBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ActiveFieldMask & whichField))
        _sfActive.syncWith(pOther->_sfActive);

    if(FieldBits::NoField != (NameFieldMask & whichField))
        _sfName.syncWith(pOther->_sfName);

    if(FieldBits::NoField != (KbitFieldMask & whichField))
        _sfKbit.syncWith(pOther->_sfKbit);

    if(FieldBits::NoField != (FpsFieldMask & whichField))
        _sfFps.syncWith(pOther->_sfFps);

    if(FieldBits::NoField != (CodecidFieldMask & whichField))
        _sfCodecid.syncWith(pOther->_sfCodecid);

    if(FieldBits::NoField != (FlipFieldMask & whichField))
        _sfFlip.syncWith(pOther->_sfFlip);

    if(FieldBits::NoField != (AutoWriteFieldMask & whichField))
        _sfAutoWrite.syncWith(pOther->_sfAutoWrite);



}

void AVCodecGrabForegroundBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<AVCodecGrabForegroundPtr>::_type("AVCodecGrabForegroundPtr", "GrabForegroundPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(AVCodecGrabForegroundPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(AVCodecGrabForegroundPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGAVCODECGRABFOREGROUNDBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGAVCODECGRABFOREGROUNDBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGAVCODECGRABFOREGROUNDFIELDS_HEADER_CVSID;
}

