/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsUniversalJoint!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEPHYSICSUNIVERSALJOINTINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGPhysicsUniversalJointBase.h"
#include "OSGPhysicsUniversalJoint.h"


OSG_USING_NAMESPACE

const OSG::BitVector  PhysicsUniversalJointBase::AnchorFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsUniversalJointBase::AnchorFieldId);

const OSG::BitVector  PhysicsUniversalJointBase::Axis1FieldMask = 
    (TypeTraits<BitVector>::One << PhysicsUniversalJointBase::Axis1FieldId);

const OSG::BitVector  PhysicsUniversalJointBase::Axis2FieldMask = 
    (TypeTraits<BitVector>::One << PhysicsUniversalJointBase::Axis2FieldId);

const OSG::BitVector PhysicsUniversalJointBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Vec3f           PhysicsUniversalJointBase::_sfAnchor
    
*/
/*! \var Vec3f           PhysicsUniversalJointBase::_sfAxis1
    
*/
/*! \var Vec3f           PhysicsUniversalJointBase::_sfAxis2
    
*/

//! PhysicsUniversalJoint description

FieldDescription *PhysicsUniversalJointBase::_desc[] = 
{
    new FieldDescription(SFVec3f::getClassType(), 
                     "anchor", 
                     AnchorFieldId, AnchorFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsUniversalJointBase::getSFAnchor),
    new FieldDescription(SFVec3f::getClassType(), 
                     "axis1", 
                     Axis1FieldId, Axis1FieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsUniversalJointBase::getSFAxis1),
    new FieldDescription(SFVec3f::getClassType(), 
                     "axis2", 
                     Axis2FieldId, Axis2FieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsUniversalJointBase::getSFAxis2)
};


FieldContainerType PhysicsUniversalJointBase::_type(
    "PhysicsUniversalJoint",
    "PhysicsJoint",
    NULL,
    (PrototypeCreateF) &PhysicsUniversalJointBase::createEmpty,
    PhysicsUniversalJoint::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(PhysicsUniversalJointBase, PhysicsUniversalJointPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &PhysicsUniversalJointBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &PhysicsUniversalJointBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr PhysicsUniversalJointBase::shallowCopy(void) const 
{ 
    PhysicsUniversalJointPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const PhysicsUniversalJoint *>(this)); 

    return returnValue; 
}

UInt32 PhysicsUniversalJointBase::getContainerSize(void) const 
{ 
    return sizeof(PhysicsUniversalJoint); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsUniversalJointBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((PhysicsUniversalJointBase *) &other, whichField);
}
#else
void PhysicsUniversalJointBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((PhysicsUniversalJointBase *) &other, whichField, sInfo);
}
void PhysicsUniversalJointBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void PhysicsUniversalJointBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

PhysicsUniversalJointBase::PhysicsUniversalJointBase(void) :
    _sfAnchor                 (), 
    _sfAxis1                  (), 
    _sfAxis2                  (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

PhysicsUniversalJointBase::PhysicsUniversalJointBase(const PhysicsUniversalJointBase &source) :
    _sfAnchor                 (source._sfAnchor                 ), 
    _sfAxis1                  (source._sfAxis1                  ), 
    _sfAxis2                  (source._sfAxis2                  ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

PhysicsUniversalJointBase::~PhysicsUniversalJointBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 PhysicsUniversalJointBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
    {
        returnValue += _sfAnchor.getBinSize();
    }

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
    {
        returnValue += _sfAxis1.getBinSize();
    }

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
    {
        returnValue += _sfAxis2.getBinSize();
    }


    return returnValue;
}

void PhysicsUniversalJointBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
    {
        _sfAnchor.copyToBin(pMem);
    }

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
    {
        _sfAxis1.copyToBin(pMem);
    }

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
    {
        _sfAxis2.copyToBin(pMem);
    }


}

void PhysicsUniversalJointBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
    {
        _sfAnchor.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
    {
        _sfAxis1.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
    {
        _sfAxis2.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsUniversalJointBase::executeSyncImpl(      PhysicsUniversalJointBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
        _sfAnchor.syncWith(pOther->_sfAnchor);

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
        _sfAxis1.syncWith(pOther->_sfAxis1);

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
        _sfAxis2.syncWith(pOther->_sfAxis2);


}
#else
void PhysicsUniversalJointBase::executeSyncImpl(      PhysicsUniversalJointBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (AnchorFieldMask & whichField))
        _sfAnchor.syncWith(pOther->_sfAnchor);

    if(FieldBits::NoField != (Axis1FieldMask & whichField))
        _sfAxis1.syncWith(pOther->_sfAxis1);

    if(FieldBits::NoField != (Axis2FieldMask & whichField))
        _sfAxis2.syncWith(pOther->_sfAxis2);



}

void PhysicsUniversalJointBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<PhysicsUniversalJointPtr>::_type("PhysicsUniversalJointPtr", "PhysicsJointPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(PhysicsUniversalJointPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(PhysicsUniversalJointPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGPhysicsUniversalJointBase.cpp,v 1.2 2006/02/20 17:04:21 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGPHYSICSUNIVERSALJOINTBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPHYSICSUNIVERSALJOINTBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPHYSICSUNIVERSALJOINTFIELDS_HEADER_CVSID;
}

