/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ProxyBuilder!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEPROXYBUILDERINST

#include <stdlib.h>
#include <stdio.h>

#include <OpenSG/OSGConfig.h>

#include "OSGProxyBuilderBase.h"
#include "OSGProxyBuilder.h"


OSG_USING_NAMESPACE

const OSG::BitVector ProxyBuilderBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 



FieldContainerType ProxyBuilderBase::_type(
    "ProxyBuilder",
    "Geometry",
    NULL,
    (PrototypeCreateF) &ProxyBuilderBase::createEmpty,
    ProxyBuilder::initMethod,
    NULL,
    0);

//OSG_FIELD_CONTAINER_DEF(ProxyBuilderBase, ProxyBuilderPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ProxyBuilderBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ProxyBuilderBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr ProxyBuilderBase::shallowCopy(void) const 
{ 
    ProxyBuilderPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const ProxyBuilder *>(this)); 

    return returnValue; 
}

UInt32 ProxyBuilderBase::getContainerSize(void) const 
{ 
    return sizeof(ProxyBuilder); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ProxyBuilderBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ProxyBuilderBase *) &other, whichField);
}
#else
void ProxyBuilderBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ProxyBuilderBase *) &other, whichField, sInfo);
}
void ProxyBuilderBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ProxyBuilderBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ProxyBuilderBase::ProxyBuilderBase(void) :
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ProxyBuilderBase::ProxyBuilderBase(const ProxyBuilderBase &source) :
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ProxyBuilderBase::~ProxyBuilderBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ProxyBuilderBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);


    return returnValue;
}

void ProxyBuilderBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);


}

void ProxyBuilderBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ProxyBuilderBase::executeSyncImpl(      ProxyBuilderBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);


}
#else
void ProxyBuilderBase::executeSyncImpl(      ProxyBuilderBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);



}

void ProxyBuilderBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OpenSG/OSGSFieldTypeDef.inl>
#include <OpenSG/OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ProxyBuilderPtr>::_type("ProxyBuilderPtr", "GeometryPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ProxyBuilderPtr, );
OSG_DLLEXPORT_MFIELD_DEF1(ProxyBuilderPtr, );

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGPROXYBUILDERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPROXYBUILDERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPROXYBUILDERFIELDS_HEADER_CVSID;
}

