# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/whiteboard_hander.py
# Author: OpenRPG Team
# Maintainer:
# Version:
#   $Id: miniatures_handler.py,v 1.36 2007/02/12 02:29:08 digitalxero Exp $
#
# Description: Miniature layer handler
#
__version__ = "$Id: miniatures_handler.py,v 1.36 2007/02/12 02:29:08 digitalxero Exp $"


from base_handler import *
#from miniatures import *
from min_dialogs import *
import thread
import time
import mimetypes
import urllib
import xml.dom.minidom as minidom
import wx


LABEL_TOOL = wx.NewId()
LAYER_TOOL = wx.NewId()
MIN_LIST_TOOL = wx.NewId()
MIN_TOOL = wx.NewId()
MIN_URL = wx.NewId()
SERIAL_TOOL = wx.NewId()

MIN_REMOVE = wx.NewId()
MIN_PROP_DLG = wx.NewId()
MIN_FACING_NONE = wx.NewId()
MIN_FACING_MATCH = wx.NewId()
MIN_FACING_EAST = wx.NewId()
MIN_FACING_WEST = wx.NewId()
MIN_FACING_NORTH = wx.NewId()
MIN_FACING_SOUTH = wx.NewId()
MIN_FACING_NORTHEAST = wx.NewId()
MIN_FACING_SOUTHEAST = wx.NewId()
MIN_FACING_SOUTHWEST = wx.NewId()
MIN_FACING_NORTHWEST = wx.NewId()
MIN_HEADING_NONE = wx.NewId()
MIN_HEADING_MATCH = wx.NewId()
MIN_HEADING_EAST = wx.NewId()
MIN_HEADING_WEST = wx.NewId()
MIN_HEADING_NORTH = wx.NewId()
MIN_HEADING_SOUTH = wx.NewId()
MIN_HEADING_NORTHEAST = wx.NewId()
MIN_HEADING_SOUTHEAST = wx.NewId()
MIN_HEADING_SOUTHWEST = wx.NewId()
MIN_HEADING_NORTHWEST = wx.NewId()
MIN_HEADING_SUBMENU = wx.NewId()
MIN_FACING_SUBMENU = wx.NewId()
MIN_ALIGN_SUBMENU = wx.NewId()
MIN_ALIGN_GRID_CENTER = wx.NewId()
MIN_ALIGN_GRID_TL = wx.NewId()
MIN_TITLE_HACK = wx.NewId()
MIN_TO_GAMETREE = wx.NewId()

MIN_BACK_ONE = wx.NewId()
MIN_FORWARD_ONE = wx.NewId()
MIN_TO_BACK = wx.NewId()
MIN_TO_FRONT = wx.NewId()
MIN_LOCK_BACK = wx.NewId()
MIN_LOCK_FRONT = wx.NewId()
MIN_FRONTBACK_UNLOCK = wx.NewId()
MIN_ZORDER_SUBMENU = wx.NewId()
MIN_SHOW_HIDE = wx.NewId()

MAP_REFRESH_MINI_URLS = wx.NewId()


class miniatures_handler(base_layer_handler):

    def __init__(self, parent, id, canvas):
        self.sel_min = None
        self.auto_label = 1
        self.use_serial = 1
        self.auto_label_cb = None
        base_layer_handler.__init__(self, parent, id, canvas)
        self.lasttime=time.clock()

    def build_ctrls(self):
        base_layer_handler.build_ctrls(self)

        # add controls in reverse order! (unless you want them after the default tools)

        self.auto_label_cb = wx.CheckBox(self, wx.ID_ANY, ' Auto Label ', (-1,-1),(-1,-1))
        self.auto_label_cb.SetValue(self.auto_label)
        self.min_url = wx.ComboBox(self, wx.ID_ANY, "http://", style=wx.CB_DROPDOWN | wx.CB_SORT)
        self.localBrowse = wx.Button(self, wx.ID_ANY, 'Browse')
        minilist = createMaskedButton( self, orpg.dirpath.dir_struct["icon"]+'questionhead.gif', 'Edit miniature properties', wx.ID_ANY)
        miniadd = wx.Button(self, wx.ID_OK, "Add Miniature", style=wx.BU_EXACTFIT)

        self.sizer.Add(self.auto_label_cb,0,wx.ALIGN_CENTER)
        self.sizer.Add(self.min_url, 1, wx.ALIGN_CENTER)
        self.sizer.Add(miniadd, 0, wx.EXPAND)
        self.sizer.Add(self.localBrowse, 0, wx.EXPAND)
        self.sizer.Add(wx.Size(20,25))
        self.sizer.Add(minilist, 0, wx.EXPAND )


        self.Bind(wx.EVT_BUTTON, self.on_min_list, minilist)
        self.Bind(wx.EVT_BUTTON, self.on_miniature, miniadd)
        self.Bind(wx.EVT_BUTTON, self.on_browse, self.localBrowse)
        self.Bind(wx.EVT_CHECKBOX, self.on_label, self.auto_label_cb)

    def on_browse(self, evt):
        dlg = wx.FileDialog(None, "Select a Miniture to load", wildcard="Image files (*.bmp, *.gif, *.jpg, *.png)|*.bmp;*.gif;*.jpg;*.png", style=wx.OPEN)

        if not dlg.ShowModal() == wx.ID_OK:
            dlg.Destroy()
            return

        file = open(dlg.GetPath(), "rb")
        imgdata = file.read()
        file.close()

        filename = dlg.GetFilename()
        (imgtype,j) = mimetypes.guess_type(filename)

        postdata = urllib.urlencode({'filename':filename, 'imgdata':imgdata, 'imgtype':imgtype})

        thread.start_new_thread(self.canvas.layers['miniatures'].upload, (postdata, dlg.GetPath()))


    def build_menu(self,label = "Miniature"):
        base_layer_handler.build_menu(self,label)

        self.main_menu.AppendSeparator()
        self.main_menu.Append(LABEL_TOOL,"&Auto label","",1)
        self.main_menu.Check(LABEL_TOOL,self.auto_label)
        self.main_menu.Append(SERIAL_TOOL,"&Number minis","",1)
        self.main_menu.Check(SERIAL_TOOL, self.use_serial)
        self.main_menu.Append(MAP_REFRESH_MINI_URLS,"&Refresh miniatures")       #  Add the menu item

        self.canvas.Bind(wx.EVT_MENU, self.on_map_board_menu_item, id=MAP_REFRESH_MINI_URLS)          #  Set the handler
        self.canvas.Bind(wx.EVT_MENU, self.on_label, id=LABEL_TOOL)
        self.canvas.Bind(wx.EVT_MENU, self.on_serial, id=SERIAL_TOOL)

        # build miniature meenu

        self.min_menu = wx.Menu()

        # Rectangles and hexagons require slightly different menus because of
        # facing and heading possibilities.
        heading_menu = wx.Menu()
        face_menu = wx.Menu()
        face_menu.Append(MIN_FACING_NONE,"&None")
        face_menu.Append(MIN_FACING_NORTH,"&North")
        face_menu.Append(MIN_FACING_NORTHEAST,"Northeast")
        face_menu.Append(MIN_FACING_EAST,"East")
        face_menu.Append(MIN_FACING_SOUTHEAST,"Southeast")
        face_menu.Append(MIN_FACING_SOUTH,"&South")
        face_menu.Append(MIN_FACING_SOUTHWEST,"Southwest")
        face_menu.Append(MIN_FACING_WEST,"West")
        face_menu.Append(MIN_FACING_NORTHWEST,"Northwest")
        heading_menu.Append(MIN_HEADING_NONE,"&None")
        heading_menu.Append(MIN_HEADING_NORTH,"&North")
        heading_menu.Append(MIN_HEADING_NORTHEAST,"Northeast")
        heading_menu.Append(MIN_HEADING_EAST,"East")
        heading_menu.Append(MIN_HEADING_SOUTHEAST,"Southeast")
        heading_menu.Append(MIN_HEADING_SOUTH,"&South")
        heading_menu.Append(MIN_HEADING_SOUTHWEST,"Southwest")
        heading_menu.Append(MIN_HEADING_WEST,"West")
        heading_menu.Append(MIN_HEADING_NORTHWEST,"Northwest")


        align_menu = wx.Menu()
        align_menu.Append(MIN_ALIGN_GRID_CENTER,"&Center")
        align_menu.Append(MIN_ALIGN_GRID_TL,"&Top-Left")

        #  This is a hack to simulate a menu title, due to problem in Linux
        if wx.Platform == '__WXMSW__':
            self.min_menu.SetTitle(label)
        else:
            self.min_menu.Append(MIN_TITLE_HACK,label)
            self.min_menu.AppendSeparator()


        self.min_menu.Append(MIN_SHOW_HIDE,"Show / Hide")
        self.min_menu.Append(MIN_REMOVE,"&Remove")

        self.min_menu.Append(MIN_TO_GAMETREE,"To &Gametree")

        self.min_menu.AppendMenu(MIN_HEADING_SUBMENU,"Set &Heading",heading_menu)
        self.min_menu.AppendMenu(MIN_FACING_SUBMENU,"Set &Facing",face_menu)
        self.min_menu.AppendMenu(MIN_ALIGN_SUBMENU,"Snap-to &Alignment",align_menu)
        self.min_menu.AppendSeparator()
        zorder_menu = wx.Menu()
        zorder_menu.Append(MIN_BACK_ONE,"Back one")
        zorder_menu.Append(MIN_FORWARD_ONE,"Forward one")
        zorder_menu.Append(MIN_TO_BACK,"To back")
        zorder_menu.Append(MIN_TO_FRONT,"To front")
        zorder_menu.AppendSeparator()
        zorder_menu.Append(MIN_LOCK_BACK,"Lock to back")
        zorder_menu.Append(MIN_LOCK_FRONT,"Lock to front")
        zorder_menu.Append(MIN_FRONTBACK_UNLOCK,"Unlock Front/Back")
        self.min_menu.AppendMenu(MIN_ZORDER_SUBMENU, "Miniature Z-Order",zorder_menu)

        #self.min_menu.Append(MIN_LOCK,"&Lock")
        self.min_menu.AppendSeparator()
        self.min_menu.Append(MIN_PROP_DLG,"&Properties")

        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_SHOW_HIDE)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_REMOVE)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_TO_GAMETREE)
        #self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_LOCK)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_PROP_DLG)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FACING_NONE)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FACING_EAST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FACING_WEST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FACING_NORTH)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FACING_SOUTH)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FACING_NORTHEAST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FACING_SOUTHEAST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FACING_SOUTHWEST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FACING_NORTHWEST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_HEADING_NONE)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_HEADING_EAST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_HEADING_WEST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_HEADING_NORTH)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_HEADING_SOUTH)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_HEADING_NORTHEAST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_HEADING_SOUTHEAST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_HEADING_SOUTHWEST)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_HEADING_NORTHWEST)

        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_ALIGN_GRID_CENTER)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_ALIGN_GRID_TL)

        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_BACK_ONE)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FORWARD_ONE)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_TO_BACK)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_TO_FRONT)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_LOCK_BACK)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_LOCK_FRONT)
        self.canvas.Bind(wx.EVT_MENU, self.on_min_menu_item, id=MIN_FRONTBACK_UNLOCK)



    def do_min_menu(self,pos):
        self.canvas.PopupMenu(self.min_menu,pos)


    def do_min_select_menu(self,min_list,pos):
        self.min_select_menu = wx.Menu()
        self.min_select_menu.SetTitle("Select Miniature")
        menu_list = []
        loop_count = 0
        try:
            for m in min_list:
                menu_list.append(loop_count)
### Either use the miniatures label for the selection list

                if min_list[loop_count].label:
                    self.min_select_menu.Append(menu_list[loop_count],min_list[loop_count].label)
###
### Or use part of the images filename as an identifier
                else:
                    string_split = string.split(min_list[loop_count].path,"/",)
                    last_string = string_split[len(string_split)-1]
                    self.min_select_menu.Append(menu_list[loop_count],'Unlabeled - ' + last_string[:len(last_string)-4])
###
                self.canvas.Bind(wx.EVT_MENU, self.min_selected, id=menu_list[loop_count])
                loop_count += 1
            self.canvas.PopupMenu(self.min_select_menu,pos)
        except:
            pass

    def min_selected(self,evt):
        self.canvas.Refresh(False)
        self.canvas.send_map_data()
        self.canvas.layers['miniatures'].id = evt.GetId()

    def on_left_down(self, evt):
        session = self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM) and (session.my_role() <> session.ROLE_PLAYER) and (session.use_roles()):
            self.top_frame.openrpg.get_component("chat").InfoPost("You must be either a player or GM to use the miniature Layer")
            return
        min = 0
        dc = wx.ClientDC(self.canvas)
        self.canvas.PrepareDC(dc)
        dc.SetUserScale(self.canvas.layers['grid'].mapscale,self.canvas.layers['grid'].mapscale)
        pos = evt.GetLogicalPosition(dc)
        #pos = evt.GetPosition()
        if self.canvas.layers['miniatures'].id < 0:
            self.min_list =  self.canvas.layers['miniatures'].find_miniature(pos, True)
        min = None
        if not self.sel_min:
            try:
                if self.canvas.layers['miniatures'].id < 0:
                    if len(self.min_list) > 1:
                        self.do_min_select_menu(self.min_list,evt.GetPosition())
                    elif len(self.min_list) == 1:
                        min = self.min_list[0]
            except:
                pass
            if self.canvas.layers['miniatures'].id >= 0:
                min = self.min_list[self.canvas.layers['miniatures'].id]
                self.canvas.layers['miniatures'].id = -1

        if self.sel_min:
            grid = self.canvas.layers['grid']
            grid_pos = grid.grid_hit_test(pos)
            if grid_pos:
                topLeft = grid.get_top_corner(grid_pos)#  get the top corner for this grid cell
                if self.sel_min.snap_to_align == SNAPTO_ALIGN_CENTER:
                    if grid.get_mode() == 1:
                        x = ((topLeft.x/grid.size_ratio)-grid.unit_offset)+((grid.unit_widest/2) - (self.sel_min.bmp.GetWidth()/2))
                        y = topLeft.y + ((grid.unit_size_y - self.sel_min.bmp.GetHeight()) /2)
                    elif grid.get_mode() == 2:
                        x = (topLeft.x)-(self.sel_min.bmp.GetWidth()/2)
                        y = (topLeft.y)-(self.sel_min.bmp.GetHeight())
                    else:
                        x = topLeft.x + ((grid.unit_size - self.sel_min.bmp.GetWidth()) / 2)
                        y = topLeft.y + ((grid.unit_size_y - self.sel_min.bmp.GetHeight()) /2)

                else:
                    x = topLeft.x
                    y = topLeft.y
                self.sel_min.pos = cmpPoint(int(x),int(y))                                           #  Set the pos attribute
            else:
                self.sel_min.pos = cmpPoint(int(pos.x),int(pos.y))
            self.sel_min.selected = False
            self.sel_min = None
            self.canvas.Refresh(False)
            self.canvas.send_map_data()
        elif min:
            if self.sel_min:
                self.sel_min.selected = False
            self.sel_min = min
            self.sel_min.selected = True
            self.sel_min.draw(dc, self)
            self.lastx=pos.x
            self.lasty=pos.y
        del dc

    def on_left_up(self,evt):
        pass
#        if (self.sel_min):
#            self.on_left_down(evt)


    def on_right_down(self, evt):
        session = self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM) and (session.my_role()<>session.ROLE_PLAYER) and (session.use_roles()):
            self.top_frame.openrpg.get_component("chat").InfoPost("You must be either a player or GM to use the miniature Layer")
            return
        min = 0
        self.sel_rmin = None
        dc = wx.ClientDC(self.canvas)
        self.canvas.PrepareDC(dc)
        dc.SetUserScale(self.canvas.layers['grid'].mapscale,self.canvas.layers['grid'].mapscale)
        pos = evt.GetLogicalPosition(dc)
        #pos = evt.GetPosition()
        if self.canvas.layers['miniatures'].id < 0:
            min_list = self.canvas.layers['miniatures'].find_miniature(pos)
        if not self.sel_rmin:
            try:
                if self.canvas.layers['miniatures'].id < 0:
                    if len(min_list) > 1:
                        self.do_min_select_menu(min_list,evt.GetPosition())
                    elif len(min_list) == 1:
                        min = min_list[0]
            except:
                base_layer_handler.on_right_down(self,evt)
                #self.do_map_board_menu(evt.GetPosition())

            if self.canvas.layers['miniatures'].id >= 0:
                min = min_list[self.canvas.layers['miniatures'].id]
                self.canvas.layers['miniatures'].id = -1

        #  End of left_down addition

            if min:
                self.sel_rmin = min
                pos = evt.GetPosition()
                #self.build_menu(min.label)
                self.do_min_menu(evt.GetPosition())
                self.sel_rmin = None
            elif self.sel_rmin:
                self.sel_rmin = None
                self.sel_rmin.selected = False
                self.Refresh(False)

        else:                                          # if not min_list, i.e. we right-clicked on the map board

            base_layer_handler.on_right_down(self,evt)
            #self.do_map_board_menu(evt.GetPosition())

        del dc

    def on_min_menu_item(self,evt):

        id = evt.GetId()
        if id == MIN_REMOVE:
            self.canvas.layers['miniatures'].del_miniature(self.sel_rmin)
            self.canvas.send_map_data()
        elif id == MIN_TO_GAMETREE:
            min_xml = self.sel_rmin.toxml(action="new")
            node_begin = "<nodehandler module='map_miniature_nodehandler' class='map_miniature_handler' name='"

            if self.sel_rmin.label:
                node_begin += self.sel_rmin.label + "'"
            else:
                node_begin += "Unnamed Miniature'"

            node_begin += ">"
            gametree = self.canvas.frame.openrpg.get_component('tree')
            node_xml = node_begin + min_xml + '</nodehandler>'
            #print "Sending this XML to insert_xml:" + node_xml
            gametree.insert_xml(node_xml)
        elif id == MIN_SHOW_HIDE:
            if self.sel_rmin.hide:
                self.sel_rmin.hide = 0
            else:
                self.sel_rmin.hide = 1
            self.canvas.send_map_data()
        elif id == MIN_FACING_NONE:
            self.sel_rmin.face = FACE_NONE
            self.canvas.send_map_data()
        elif id == MIN_FACING_EAST:
            self.sel_rmin.face = FACE_EAST
            self.canvas.send_map_data()
        elif id == MIN_FACING_WEST:
            self.sel_rmin.face = FACE_WEST
            self.canvas.send_map_data()
        elif id == MIN_FACING_NORTH:
            self.sel_rmin.face = FACE_NORTH
            self.canvas.send_map_data()
        elif id == MIN_FACING_SOUTH:
            self.sel_rmin.face = FACE_SOUTH
            self.canvas.send_map_data()
        elif id == MIN_FACING_NORTHEAST:
            self.sel_rmin.face = FACE_NORTHEAST
            self.canvas.send_map_data()
        elif id == MIN_FACING_SOUTHEAST:
            self.sel_rmin.face = FACE_SOUTHEAST
            self.canvas.send_map_data()
        elif id == MIN_FACING_SOUTHWEST:
            self.sel_rmin.face = FACE_SOUTHWEST
            self.canvas.send_map_data()
        elif id == MIN_FACING_NORTHWEST:
            self.sel_rmin.face = FACE_NORTHWEST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_NONE:
            self.sel_rmin.heading = FACE_NONE
            self.canvas.send_map_data()
        elif id == MIN_HEADING_EAST:
            self.sel_rmin.heading = FACE_EAST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_WEST:
            self.sel_rmin.heading = FACE_WEST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_NORTH:
            self.sel_rmin.heading = FACE_NORTH
            self.canvas.send_map_data()
        elif id == MIN_HEADING_SOUTH:
            self.sel_rmin.heading = FACE_SOUTH
            self.canvas.send_map_data()
        elif id == MIN_HEADING_NORTHEAST:
            self.sel_rmin.heading = FACE_NORTHEAST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_SOUTHEAST:
            self.sel_rmin.heading = FACE_SOUTHEAST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_SOUTHWEST:
            self.sel_rmin.heading = FACE_SOUTHWEST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_NORTHWEST:
            self.sel_rmin.heading = FACE_NORTHWEST
            self.canvas.send_map_data()
        elif id == MIN_ALIGN_GRID_CENTER:
            self.sel_rmin.snap_to_align = SNAPTO_ALIGN_CENTER
            self.canvas.send_map_data()
        elif id == MIN_ALIGN_GRID_TL:
            self.sel_rmin.snap_to_align = SNAPTO_ALIGN_TL
            self.canvas.send_map_data()
        elif id == MIN_PROP_DLG:
            dlg = min_edit_dialog(self.canvas.frame.GetParent(),self.sel_rmin)
            if dlg.ShowModal() == wx.ID_OK:
                self.canvas.send_map_data()

        elif id == MIN_BACK_ONE:
            #  This assumes that we always start out with a z-order
            #     that starts at 0 and goes up to the number of
            #     minis - 1.  If this isn't the case, then execute
            #     a self.canvas.layers['miniatures'].collapse_zorder()
            #     before getting the oldz to test


            #  Save the selected minis current z-order
            oldz = self.sel_rmin.zorder

            # Make sure the mini isn't sticky front or back
            if (oldz != MIN_STICKY_BACK) and (oldz != MIN_STICKY_FRONT):
##                print "old z-order = " + str(oldz)

                self.sel_rmin.zorder -= 1

                #  Re-collapse to normalize
                #  Note:  only one update (with the final values) will be sent
                self.canvas.layers['miniatures'].collapse_zorder()


        elif id == MIN_FORWARD_ONE:
            #  This assumes that we always start out with a z-order
            #     that starts at 0 and goes up to the number of
            #     minis - 1.  If this isn't the case, then execute
            #     a self.canvas.layers['miniatures'].collapse_zorder()
            #     before getting the oldz to test

            #  Save the selected minis current z-order
            oldz = self.sel_rmin.zorder
##            print "old z-order = " + str(oldz)

            self.sel_rmin.zorder += 1

            #  Re-collapse to normalize
            #  Note:  only one update (with the final values) will be sent
            self.canvas.layers['miniatures'].collapse_zorder()


        elif id == MIN_TO_FRONT:
            #  This assumes that we always start out with a z-order
            #     that starts at 0 and goes up to the number of
            #     minis - 1.  If this isn't the case, then execute
            #     a self.canvas.layers['miniatures'].collapse_zorder()
            #     before getting the oldz to test

            #  Save the selected minis current z-order
            oldz = self.sel_rmin.zorder

            # Make sure the mini isn't sticky front or back
            if (oldz != MIN_STICKY_BACK) and (oldz != MIN_STICKY_FRONT):
##                print "old z-order = " + str(oldz)

                #  The new z-order will be one more than the last index
                newz = len(self.canvas.layers['miniatures'].miniatures)
##                print "new z-order = " + str(newz)

                self.sel_rmin.zorder = newz

                #  Re-collapse to normalize
                #  Note:  only one update (with the final values) will be sent
                self.canvas.layers['miniatures'].collapse_zorder()


        elif id == MIN_TO_BACK:
            #  This assumes that we always start out with a z-order
            #     that starts at 0 and goes up to the number of
            #     minis - 1.  If this isn't the case, then execute
            #     a self.canvas.layers['miniatures'].collapse_zorder()
            #     before getting the oldz to test


            #  Save the selected minis current z-order
            oldz = self.sel_rmin.zorder

            # Make sure the mini isn't sticky front or back
            if (oldz != MIN_STICKY_BACK) and (oldz != MIN_STICKY_FRONT):
##                print "old z-order = " + str(oldz)

                #  Since 0 is the lowest in a normalized order, be one less
                newz = -1
##                print "new z-order = " + str(newz)

                self.sel_rmin.zorder = newz


                #  Re-collapse to normalize
                #  Note:  only one update (with the final values) will be sent
                self.canvas.layers['miniatures'].collapse_zorder()


        elif id == MIN_FRONTBACK_UNLOCK:
            #print "Unlocked/ unstickified..."
            if self.sel_rmin.zorder == MIN_STICKY_BACK:
                self.sel_rmin.zorder = MIN_STICKY_BACK + 1

            elif self.sel_rmin.zorder == MIN_STICKY_FRONT:
                self.sel_rmin.zorder = MIN_STICKY_FRONT - 1

        elif id == MIN_LOCK_BACK:
            #print "lock back"
            self.sel_rmin.zorder = MIN_STICKY_BACK

        elif id == MIN_LOCK_FRONT:
            #print "lock front"
            self.sel_rmin.zorder = MIN_STICKY_FRONT

        # Pretty much, we always want to refresh when we go through here
        # This helps us remove the redundant self.Refresh() on EVERY menu event
        # that we process above.
        self.canvas.Refresh(False)
        self.canvas.send_map_data()


    def on_miniature(self, evt):
        session = self.canvas.frame.session
        if (session.my_role() != session.ROLE_GM) and (session.my_role() != session.ROLE_PLAYER) and (session.use_roles()):
            self.top_frame.openrpg.get_component("chat").InfoPost("You must be either a player or GM to use the miniature Layer")
            return
        min_url = self.min_url.GetValue()
        # build url
        if min_url == "" or min_url == "http://":
            return
        if min_url[:7] != "http://" :
            min_url = "http://" + min_url
        # make label
        if self.auto_label and min_url[-4:-3] == '.':
            start = min_url.rfind("/") + 1
            min_label = min_url[start:len(min_url)-4]
            if self.use_serial:
                min_label = '%s %d' % ( min_label, self.canvas.layers['miniatures'].next_serial() )
        else:
            min_label = ""
        if self.min_url.FindString(min_url) == -1:
            self.min_url.Append(min_url)
        try:
            id = 'mini-' + self.canvas.frame.session.get_next_id()
            self.canvas.layers['miniatures'].add_miniature(id, min_url, label=min_label)
        except:
            # When there is an exception here, we should be decrementing the serial_number for reuse!!
            unablemsg= "Unable to load/resolve URL: " + min_url + " on resource \"" + min_label + "\"!!!\n\n"
            #print unablemsg
            dlg = wx.MessageDialog(self,unablemsg, 'Url not found',wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()
            self.canvas.layers['miniatures'].rollback_serial()

        self.canvas.send_map_data()
        self.canvas.Refresh(False)

        #except Exception, e:
            #wx.MessageBox(str(e),"Miniature Error")

    def on_label(self,evt):
        self.auto_label = not self.auto_label
        self.auto_label_cb.SetValue(self.auto_label)
        #self.send_map_data()
        #self.Refresh()

    def on_min_list(self,evt):
        session = self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM):
            self.top_frame.openrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return
        #d = min_list_panel(self.frame.GetParent(),self.canvas.layers,"Miniature list")
        d = min_list_panel(self.canvas.frame,self.canvas.layers,"Miniature list")
        if d.ShowModal() == wx.ID_OK:
            d.Destroy()
        self.canvas.Refresh(False)

    def on_serial(self, evt):
        self.use_serial = not self.use_serial

    def on_map_board_menu_item(self,evt):
        id = evt.GetId()
        if id == MAP_REFRESH_MINI_URLS:                          # Note: this doesn't change the mini, so no need to update the map
            for mini in self.canvas.layers['miniatures'].miniatures:       #  For all minis
                mini.set_bmp(load_img(mini.path,"miniature",mini))                    #  Reload their bmp member
            self.canvas.Refresh(False)
