/*************************************************************************
 *
 *	$RCSfile: xsectester.hxx,v $
 *
 *	$Revision: 1.1.1.1 $
 *
 *	last change: $Author: mt $ $Date: 2004/07/12 13:15:30 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _XSECTESTER_HXX
#define _XSECTESTER_HXX

#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/io/XOutputStream.hpp>
#include <com/sun/star/io/XInputStream.hpp>
#include <com/sun/star/xml/sax/XParser.hpp>
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#include <com/sun/star/xml/sax/XAttributeList.hpp>
#include <com/sun/star/lang/XServiceInfo.hpp>
#include <cppuhelper/implbase6.hxx>

#include <drafts/com/sun/star/xml/crypto/eval/XXMLSecTester.hpp>
#include <drafts/com/sun/star/xml/crypto/sax/XSignatureCreationResultListener.hpp>
#include <drafts/com/sun/star/xml/crypto/sax/XSignatureVerifyResultListener.hpp>
#include <drafts/com/sun/star/xml/crypto/sax/XSAXEventKeeperStatusChangeListener.hpp>
#include <drafts/com/sun/star/xml/crypto/sax/XSecuritySAXEventKeeper.hpp>
#include <drafts/com/sun/star/xml/crypto/sax/XReferenceResolvedListener.hpp>
#include <drafts/com/sun/star/xml/crypto/XXMLSignature.hpp>
#include <drafts/com/sun/star/xml/wrapper/XXMLDocumentWrapper.hpp>
#include <drafts/com/sun/star/xml/csax/XMLAttribute.hpp>

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif

#ifndef INCLUDED_STACK
#include <stack>
#define INCLUDED_STACK
#endif

/* xml security framework components */
#define SIGNATURECREATOR_COMPONENT  "drafts.com.sun.star.xml.crypto.sax.SignatureCreator"
#define SIGNATUREVERIFIER_COMPONENT "drafts.com.sun.star.xml.crypto.sax.SignatureVerifier"
#define JAVAFLATFILTER_COMPONENT    "drafts.com.sun.star.xml.crypto.eval.JavaFlatFilter"
#define SAXEVENTKEEPER_COMPONENT    "drafts.com.sun.star.xml.crypto.sax.SAXEventKeeper"

/* java based bridge components */
#define SEINITIALIZER_JAVA_COMPONENT      "com.sun.star.xml.security.bridge.jxsec.SEInitializer_JxsecImpl"
#define XMLSIGNATURE_JAVA_COMPONENT       "com.sun.star.xml.security.bridge.jxsec.XMLSignature_JxsecImpl"
#define XMLDOCUMENTWRAPPER_JAVA_COMPONENT "com.sun.star.xml.security.bridge.jxsec.XMLDocumentWrapper_JxsecImpl"

/* c based bridge components */
#define SEINITIALIZER_C_COMPONENT "com.sun.star.xml.security.bridge.xmlsec.SEInitializer_XmlSecImpl"
#define XMLSIGNATURE_C_COMPONENT "com.sun.star.xml.security.bridge.xmlsec.XMLSignature_XmlSecImpl"
#define XMLDOCUMENT_C_COMPONENT "com.sun.star.xml.security.bridge.xmlsec.XMLDocumentWrapper_XmlSecImpl"

/* security related elements and attributes */
#define SIGNATURE_STR       "Signature"
#define REFERENCE_STR       "Reference"
#define SIGNEDINFO_STR      "SignedInfo"
#define KEYINFO_STR         "KeyInfo"
#define KEYVALUE_STR        "KeyValue"
#define KEYNAME_STR         "KeyName"
#define X509DATA_STR        "X509Data"
#define ENCRYPTEDKEY_STR    "EncryptedKey"
#define RETRIEVALMETHOD_STR "RetrievalMethod"
#define OTHER_ELEMENT_STR   "OTHER_ELEMENT_STR"
#define REFNUM_ATTR_STR     "refNum"
#define URI_ATTR_STR        "URI"

class XSecTester;

/*
 * The XSecTester class is a C++ version of SecurityFramworkController.java
 *
 */
 
class SecurityEntity
{
private:
	static int m_nNextSecurityId;
	rtl::OUString m_ouKeyURI;

protected:
	com::sun::star::uno::Reference< 
		com::sun::star::lang::XMultiServiceFactory > mxMSF;
		
	com::sun::star::uno::Reference< 
		drafts::com::sun::star::xml::crypto::sax::XReferenceResolvedListener > 
		m_xReferenceListener;
		
	com::sun::star::uno::Reference< 
		drafts::com::sun::star::xml::crypto::sax::XSecuritySAXEventKeeper > 
		m_xSAXEventKeeper;

	com::sun::star::uno::Reference< 
		drafts::com::sun::star::xml::crypto::XXMLSecurityContext > 
		m_xXMLSecurityContext;

	com::sun::star::uno::Reference< 
		drafts::com::sun::star::xml::crypto::XXMLSignature > 
		m_xXMLSignature;
	
	int m_nSecurityId;

private:	
	int getNextSecurityId() const;

protected:
	SecurityEntity(
		const com::sun::star::uno::Reference< 
			drafts::com::sun::star::xml::crypto::sax::XSecuritySAXEventKeeper >& 
			xSAXEventKeeper,
		const com::sun::star::uno::Reference< 
			drafts::com::sun::star::xml::crypto::XXMLSecurityContext >& 
			xXMLSecurityContext,
		const com::sun::star::uno::Reference< 
			drafts::com::sun::star::xml::crypto::XXMLSignature >& 
			xXMLSignature,
		const com::sun::star::uno::Reference< 
			com::sun::star::lang::XMultiServiceFactory >&
			rsMSF);
	
public:
	void setKeyId(int nId);
	
	int getSecurityId() const;
	
	com::sun::star::uno::Reference< 
		drafts::com::sun::star::xml::crypto::sax::XReferenceResolvedListener > 
		getReferenceListener() const;
		
	bool setKey( const rtl::OUString& ouUri, bool bIsExporting );
	
	void setKeyURI(const rtl::OUString& ouUri);
	
	bool endMission();
};


class SignatureEntity : public SecurityEntity
{
private:
	std::vector< rtl::OUString > m_vReferenceIds;
	int m_nSignatureElementCollectorId;

	bool hasReference(const rtl::OUString& ouUri) const;

public:
	SignatureEntity(
		const com::sun::star::uno::Reference< 
			drafts::com::sun::star::xml::crypto::sax::XSecuritySAXEventKeeper >&
			xSAXEventKeeper,
		bool bIsExporting, 
		XSecTester* pListener,
		const com::sun::star::uno::Reference< 
			drafts::com::sun::star::xml::crypto::XXMLSecurityContext >&
			xXMLSecurityContext,
		const com::sun::star::uno::Reference<
			drafts::com::sun::star::xml::crypto::XXMLSignature >&
			xXMLSignature,
		const com::sun::star::uno::Reference<
			com::sun::star::lang::XMultiServiceFactory >&
			rsMSF);
	~SignatureEntity(){};
	
	void setReferenceNumber() const;
	bool setReference( const rtl::OUString& ouUri, bool bIsExporting ) const;
	void addReferenceURI( const rtl::OUString& ouUri );
};

struct AncestorEvent
{
	AncestorEvent( sal_Int32 nAttrNum ):aAttributeList(nAttrNum){};
	
	bool bIsStartElement;
	rtl::OUString ouName;
	
	com::sun::star::uno::Sequence< 
		drafts::com::sun::star::xml::csax::XMLAttribute >
		aAttributeList;
};
	
class XSecTester : public cppu::WeakImplHelper6
< 
	drafts::com::sun::star::xml::crypto::sax::XSignatureCreationResultListener,
	drafts::com::sun::star::xml::crypto::sax::XSignatureVerifyResultListener,
	drafts::com::sun::star::xml::crypto::sax::XSAXEventKeeperStatusChangeListener,
	drafts::com::sun::star::xml::crypto::eval::XXMLSecTester,
	com::sun::star::lang::XServiceInfo,
	com::sun::star::xml::sax::XDocumentHandler
>
{
private:
	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > mxMSF;
	
	sal_Int32 m_nTotalSignatureNumber;
	sal_Int32 m_nSuccessfulSignatureNumber;

	com::sun::star::uno::Reference<
		com::sun::star::xml::sax::XDocumentHandler > 
		m_xExportHandler;
		
	com::sun::star::uno::Reference<
		drafts::com::sun::star::xml::crypto::sax::XSecuritySAXEventKeeper >
		m_xSAXEventKeeper;
		
	com::sun::star::uno::Reference<
		drafts::com::sun::star::xml::wrapper::XXMLDocumentWrapper > 
		m_xXMLDocumentWrapper;
		
	com::sun::star::uno::Reference<
		com::sun::star::xml::sax::XDocumentHandler > 
		m_xOutputHandler;
		
	com::sun::star::uno::Reference< 
		com::sun::star::xml::sax::XParser >
		m_xSaxParser;

	std::stack< void* > m_stCurrentPath;
	std::stack< bool > m_stCurrentPathType;
	
	std::vector< AncestorEvent* > m_vAncestorEvents;
	std::vector< SignatureEntity* > m_vSignatureList;
	
	std::vector< rtl::OUString > m_vUnsolvedReferenceURIs;
	std::vector< int > m_vUnsolvedReferenceKeeperIds;
	std::vector< int > m_vUnsolvedReferenceRefNums;
	
	bool m_bIsExporting;
	bool m_bIsBlocking;
	
	bool m_bIsInsideCollectedElement;
	bool m_bIsSAXEventKeeperOnTheSAXChain;
	
	com::sun::star::uno::Reference<
		drafts::com::sun::star::xml::crypto::XXMLSecurityContext > 
		m_xXMLSecurityContext;
		
	com::sun::star::uno::Reference<
		drafts::com::sun::star::xml::crypto::XXMLSignature > 
		m_xXMLSignature;
	
	rtl::OUString m_ouJavaCryptokenDir;
	rtl::OUString m_ouCCryptokenDir;
	rtl::OUString m_ouXMLDocumentWrapperComponentName;
	
private:
	com::sun::star::uno::Reference< 
		com::sun::star::io::XOutputStream > 
		createOutputStream( const rtl::OUString& ouFile );
		
	rtl::OUString parseFile(
		const rtl::OUString& ouInputFileName, 
		const rtl::OUString& ouOutputFileName, 
		bool bIsExporting,
		bool bIsJavaBased);
		
	com::sun::star::uno::Reference< 
		com::sun::star::io::XInputStream > 
		createInputStream( const rtl::OUString& ouFile );
	
	void changeOutput();
	
	bool foundSecurityRelated();
	
	void findKeyOrReference(SecurityEntity* pSecurityEntity, const rtl::OUString& ouUri, bool bIsFindKey);
	
	bool checkSecurityElement(
		const rtl::OUString& ouLocalName,
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XAttributeList>& xAttribs);
			
	void checkReference(
		const rtl::OUString& ouLocalName,
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XAttributeList>& xAttribs,
		const rtl::OUString& ouId);
		
	void endMission();
	
	void addStartAncestorEvent(
		const rtl::OUString& ouName,
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XAttributeList>& xAttribs);
		
	void addEndAncestorEvent( const rtl::OUString& ouName );
	
	void flushAncestorEvents(
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XDocumentHandler >& xDocumentHandler);
	
	void XSecTester::sendAncestorStartElementEvent(
		const rtl::OUString& ouName, 
		const com::sun::star::uno::Sequence<
			drafts::com::sun::star::xml::csax::XMLAttribute >& xAttrList,
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XDocumentHandler >& xDocumentHandler) const;
		
	void XSecTester::sendAncestorEndElementEvent(
		const rtl::OUString& ouName,
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XDocumentHandler >& xDocumentHandler) const;
		
	std::vector< AncestorEvent* >::const_iterator XSecTester::checkAncestorStartElementEvent( 
		const std::vector< AncestorEvent* >::const_iterator& ii,
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XDocumentHandler >& xDocumentHandler) const;
	
public:
	XSecTester(const com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory >& rxMSF)
		:mxMSF( rxMSF ){};
	virtual ~XSecTester(){};
	
	/* XSignatureCreationResultListener */
	virtual void SAL_CALL signatureCreated( 
		sal_Int32 securityId, 
		drafts::com::sun::star::xml::crypto::sax::SignatureCreationResult creationResult )
		throw (com::sun::star::uno::RuntimeException);

	/* XSignatureVerifyResultListener */
	virtual void SAL_CALL signatureVerified( 
		sal_Int32 securityId, 
		drafts::com::sun::star::xml::crypto::sax::SignatureVerifyResult verifyResult )
		throw (com::sun::star::uno::RuntimeException);
		
	/* XSAXEventKeeperStatusChangeListener */
	virtual void SAL_CALL blockingStatusChanged( sal_Bool isBlocking )
		throw (com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL collectionStatusChanged( 
		sal_Bool isInsideCollectedElement )
		throw (com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL bufferStatusChanged( sal_Bool isBufferEmpty )
		throw (com::sun::star::uno::RuntimeException);
	
	/* XXMLSecTester */
	virtual rtl::OUString SAL_CALL transfer_without_sec( 
		const rtl::OUString& inputFileName, 
		const rtl::OUString& outputFileName,
		sal_Bool isBridgeInvolved)
		throw (com::sun::star::uno::RuntimeException);
	virtual rtl::OUString SAL_CALL export_xml(
		const rtl::OUString& inputFileName, 
		const rtl::OUString& outputFileName,
		sal_Bool isJavaBased)
		throw (com::sun::star::uno::RuntimeException);
	virtual rtl::OUString SAL_CALL import_xml(
		const rtl::OUString& inputFileName, 
		const rtl::OUString& outputFileName,
		sal_Bool isJavaBased)
		throw (com::sun::star::uno::RuntimeException);
		
	virtual void SAL_CALL setCryptoDir(
		const rtl::OUString & javaDirName,
		const rtl::OUString & cDirName)
		throw (com::sun::star::uno::RuntimeException);

	/* XServiceInfo */
	virtual rtl::OUString SAL_CALL getImplementationName(  ) 
		throw (com::sun::star::uno::RuntimeException);
	virtual sal_Bool SAL_CALL supportsService( const rtl::OUString& ServiceName ) 
		throw (com::sun::star::uno::RuntimeException);
	virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL getSupportedServiceNames(  ) 
		throw (com::sun::star::uno::RuntimeException);

	/* XDocumentHandler */
	virtual void SAL_CALL endDocument()
		throw (com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL startDocument()
		throw (com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL characters(const class rtl::OUString&)
		throw (com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL processingInstruction(const rtl::OUString&, const rtl::OUString&)
		throw (com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL ignorableWhitespace(const rtl::OUString&)
		throw (com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL startElement(
		const rtl::OUString&, 
		const com::sun::star::uno::Reference< com::sun::star::xml::sax::XAttributeList >&)
		throw (com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL endElement(const rtl::OUString&)
		throw (com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL setDocumentLocator(
		const com::sun::star::uno::Reference< com::sun::star::xml::sax::XLocator >&)
		throw (com::sun::star::uno::RuntimeException);
};

rtl::OUString XSecTester_getImplementationName()
	throw ( com::sun::star::uno::RuntimeException );

sal_Bool SAL_CALL XSecTester_supportsService( const rtl::OUString& ServiceName ) 
	throw ( com::sun::star::uno::RuntimeException );

com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL XSecTester_getSupportedServiceNames(  ) 
	throw ( com::sun::star::uno::RuntimeException );

com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
SAL_CALL XSecTester_createInstance( 
	const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > & rSMgr)
	throw ( com::sun::star::uno::Exception );

#endif


