/*************************************************************************
 *
 *	$RCSfile: xsectester.cxx,v $
 *
 *	$Revision: 1.1.1.1 $
 *
 *	last change: $Author: mt $ $Date: 2004/07/12 13:15:30 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "xsectester.hxx"

#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 * Can not build under solaris.
 * Delete the memory.h including by AF
#include <memory.h>
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <osl/time.h>

#include <com/sun/star/ucb/XSimpleFileAccess.hpp>
#include <com/sun/star/io/XActiveDataSource.hpp>
#include <com/sun/star/xml/sax/InputSource.hpp>
#include <com/sun/star/xml/crypto/XSEInitializer.hpp>
#include <com/sun/star/xml/crypto/sax/SignatureCreationResult.hpp>
#include <com/sun/star/xml/crypto/sax/SignatureVerifyResult.hpp>

namespace cssu = com::sun::star::uno;
namespace cssl = com::sun::star::lang;
namespace cssi = com::sun::star::io;
namespace cssxc = com::sun::star::xml::crypto;
namespace cssxs = com::sun::star::xml::sax;

#define RTL_ASCII_USTRINGPARAM( asciiStr ) asciiStr, strlen( asciiStr ), RTL_TEXTENCODING_ASCII_US

#define SERVICE_NAME "com.sun.star.xml.crypto.eval.XSecTester"
#define IMPLEMENTATION_NAME "com.sun.star.xml.security.eval.XSecTester"

cssu::Reference< cssi::XOutputStream > XSecTester::createOutputStream( 
	const rtl::OUString& ouFile )
{
	cssu::Reference< cssi::XOutputStream > rc = NULL;
	
	try 
	{
		const rtl::OUString sSimpleFileAccess ( 
			RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.ucb.SimpleFileAccess"));
			
		cssu::Reference < com::sun::star::ucb::XSimpleFileAccess > xSimpleFileAccess
			( mxMSF->createInstance( sSimpleFileAccess ), cssu::UNO_QUERY );
		
		if (xSimpleFileAccess->exists( ouFile ))
		{
			xSimpleFileAccess->kill( ouFile );
		}
		
		rc = xSimpleFileAccess->openFileWrite( ouFile );
	}
	catch( cssu::Exception& ) 
	{
		rc = NULL;
	}
	
	return rc;
}

cssu::Reference< cssi::XInputStream > XSecTester::createInputStream(
	const rtl::OUString& ouFile )
{
	cssu::Reference< cssi::XInputStream > rc = NULL;
	
	try 
	{
		const rtl::OUString sSimpleFileAccess ( 
			RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.ucb.SimpleFileAccess"));
			
		cssu::Reference < com::sun::star::ucb::XSimpleFileAccess > xSimpleFileAccess
			( mxMSF->createInstance( sSimpleFileAccess ), cssu::UNO_QUERY );
		
		rc = xSimpleFileAccess->openFileRead( ouFile );
	}
	catch( cssu::Exception& ) 
	{
		rc = NULL;
	}
	
	return rc;
}

rtl::OUString XSecTester::parseFile(
	const rtl::OUString& ouInputFileName, 
	const rtl::OUString& ouOutputFileName, 
	bool bIsExporting,
	bool bIsJavaBased)
{
	rtl::OUString ouMessage;
	
	cssu::Reference<cssi::XInputStream> xInputStream = createInputStream(ouInputFileName);
	
	if (xInputStream != NULL ) 
	{
		/* initialization */
		rtl::OUString SEInitializer_comp;
		rtl::OUString XMLSignature_comp;
		rtl::OUString tokenPath;
		cssu::Reference < cssxc::XSEInitializer > xSEInitializer;
		
		if (bIsJavaBased)
		{
			SEInitializer_comp = rtl::OUString::createFromAscii( SEINITIALIZER_JAVA_COMPONENT );
			XMLSignature_comp = rtl::OUString::createFromAscii( XMLSIGNATURE_JAVA_COMPONENT);
			m_ouXMLDocumentWrapperComponentName = rtl::OUString::createFromAscii( XMLDOCUMENTWRAPPER_JAVA_COMPONENT );
			tokenPath = m_ouJavaCryptokenDir;
		}
		else
		{
			SEInitializer_comp = rtl::OUString::createFromAscii( SEINITIALIZER_C_COMPONENT );
			XMLSignature_comp = rtl::OUString::createFromAscii( XMLSIGNATURE_C_COMPONENT);
			m_ouXMLDocumentWrapperComponentName = rtl::OUString::createFromAscii( XMLDOCUMENT_C_COMPONENT );
			tokenPath = m_ouCCryptokenDir;
		}
		
		xSEInitializer = cssu::Reference < cssxc::XSEInitializer > (
			 mxMSF->createInstance( SEInitializer_comp ),
			 cssu::UNO_QUERY );		
			 
		m_xXMLSignature = cssu::Reference<cssxc::XXMLSignature> (
			mxMSF->createInstance( XMLSignature_comp ),
			cssu::UNO_QUERY );
			
		if ( xSEInitializer.is() && m_xXMLSignature.is())
		{
			/* create SAX Parser */
			const rtl::OUString sSaxParser ( 
				RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Parser") );
			m_xSaxParser = cssu::Reference < cssxs::XParser > ( mxMSF->createInstance( sSaxParser ), cssu::UNO_QUERY );
	
			/* create SAX Writer */
			const rtl::OUString sSaxWriter ( 
				RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Writer") );
			cssu::Reference < cssi::XActiveDataSource > xSaxWriter
				( mxMSF->createInstance( sSaxWriter ), cssu::UNO_QUERY );
			
			cssu::Reference< cssi::XOutputStream > xOutputStream = createOutputStream(ouOutputFileName);
			xSaxWriter->setOutputStream( xOutputStream );
	
			cssxs::InputSource aInput;
			aInput.sSystemId = ouInputFileName;
			aInput.aInputStream = xInputStream;
			
			cssu::Reference < cssxs::XDocumentHandler > xSaxWriterHandler( xSaxWriter, cssu::UNO_QUERY);
	
			m_xXMLSecurityContext = 
				xSEInitializer->createSecurityContext(tokenPath);
			
			m_bIsExporting = bIsExporting;
			m_xExportHandler = xSaxWriterHandler;
			m_xOutputHandler = xSaxWriterHandler;
			
			m_xXMLDocumentWrapper = NULL;
			m_xSAXEventKeeper = NULL;
			m_bIsSAXEventKeeperOnTheSAXChain = false;
	
			m_bIsBlocking = false;
			m_bIsInsideCollectedElement = false;
			
			OSL_ASSERT(m_vSignatureList.size() == 0);
			OSL_ASSERT(m_vUnsolvedReferenceURIs.size() == 0);
			OSL_ASSERT(m_vUnsolvedReferenceKeeperIds.size() == 0);
			OSL_ASSERT(m_vUnsolvedReferenceRefNums.size() == 0);
			OSL_ASSERT(m_stCurrentPath.empty());
			OSL_ASSERT(m_stCurrentPathType.empty());
			OSL_ASSERT(m_vAncestorEvents.empty());
	
			changeOutput();
	
			/* foundSecurityRelated(); */
			
			/* Begin to parse */
			TimeValue startTime, endTime;
			osl_getSystemTime( &startTime );
			
			xSaxWriterHandler->startDocument();
			
			if (m_bIsExporting) 
			{
				m_xSaxParser->setDocumentHandler(this);
				m_xSaxParser->parseStream(aInput);
			}
			else 
			{
				m_xSaxParser->setDocumentHandler(this);
				m_xSaxParser->parseStream(aInput);
			}
			
			endMission();
			xSaxWriterHandler->endDocument();
	
			osl_getSystemTime( &endTime );
	
			flushAncestorEvents( NULL );
			
			xOutputStream->closeOutput();
			xInputStream->closeInput();
			
			
			/*
			 * Free the security context
			 */
			xSEInitializer->freeSecurityContext(m_xXMLSecurityContext);
			m_xXMLSecurityContext = NULL;
			
			/* Calculate the time */
			double diff = ((double)((endTime.Nanosec + endTime.Seconds*1000000000.0)
					- (startTime.Nanosec + startTime.Seconds*1000000000.0))) / 
				((double)1000000000.0);
	
			char buf[32];
			sprintf(buf, "%.2f", diff);
			ouMessage += rtl::OUString(RTL_ASCII_USTRINGPARAM(buf));
		}
		else
		{
			ouMessage += rtl::OUString::createFromAscii( "N/A" );
		}
		
	}
	else
	{
		ouMessage += rtl::OUString::createFromAscii( "-" );
	}
	
	return ouMessage;
}

/* XSignatureCreationResultListener */
void SAL_CALL XSecTester::signatureCreated(
	sal_Int32 securityId, 
	cssxc::sax::SignatureCreationResult creationResult )
	throw (cssu::RuntimeException)
{
	m_nTotalSignatureNumber++;
	if (creationResult == cssxc::sax::SignatureCreationResult_CREATIONSUCCEED) 
	{
		m_nSuccessfulSignatureNumber++;
	}
}

/* XSignatureVerifyResultListener */
void SAL_CALL XSecTester::signatureVerified(
	sal_Int32 securityId, 
	cssxc::sax::SignatureVerifyResult verifyResult )
	throw (cssu::RuntimeException)
{
	m_nTotalSignatureNumber++;
	if (verifyResult == cssxc::sax::SignatureVerifyResult_VERIFYSUCCEED) 
	{
		m_nSuccessfulSignatureNumber++;
	}
}
	
/* XSAXEventKeeperStatusChangeListener */
void SAL_CALL XSecTester::blockingStatusChanged( sal_Bool isBlocking )
	throw (cssu::RuntimeException)
{
	this->m_bIsBlocking = isBlocking;
}
	
void SAL_CALL XSecTester::collectionStatusChanged( sal_Bool isInsideCollectedElement )
	throw (cssu::RuntimeException)
{
	this->m_bIsInsideCollectedElement = isInsideCollectedElement;
	
	if ( !m_bIsInsideCollectedElement && !m_bIsBlocking)
	{
		m_bIsSAXEventKeeperOnTheSAXChain = false;
	}
	else
	{
		m_bIsSAXEventKeeperOnTheSAXChain = true;
	}
	changeOutput();
}
	
void SAL_CALL XSecTester::bufferStatusChanged( sal_Bool isBufferEmpty )
	throw (cssu::RuntimeException)
{
	if (isBufferEmpty)
	{
		m_xXMLDocumentWrapper = NULL;
		
		m_xSAXEventKeeper = NULL;
		m_bIsSAXEventKeeperOnTheSAXChain = false;
		changeOutput();
	}
}

/* XXMLSecTester */
rtl::OUString SAL_CALL XSecTester::export_xml( const rtl::OUString& inputFileName, const rtl::OUString& outputFileName, sal_Bool isJavaBased)
	throw (cssu::RuntimeException)
{
	rtl::OUString ouMessage;
	
	m_nTotalSignatureNumber = 0;
	m_nSuccessfulSignatureNumber = 0;
	
	ouMessage += parseFile(inputFileName, outputFileName, sal_True, isJavaBased);
	
	rtl::OUString ouRemark = rtl::OUString::valueOf(m_nSuccessfulSignatureNumber) +
		rtl::OUString(RTL_ASCII_USTRINGPARAM( "/" ))
		+ rtl::OUString::valueOf(m_nTotalSignatureNumber);
	ouMessage += rtl::OUString(RTL_ASCII_USTRINGPARAM("\t")) + ouRemark;

	return ouMessage;
}
	
rtl::OUString SAL_CALL XSecTester::import_xml( const rtl::OUString& inputFileName, const rtl::OUString& outputFileName, sal_Bool isJavaBased)
	throw (cssu::RuntimeException)
{
	rtl::OUString ouMessage;

	m_nTotalSignatureNumber = 0;
	m_nSuccessfulSignatureNumber = 0;

	ouMessage += parseFile(inputFileName, outputFileName, sal_False, isJavaBased);

	rtl::OUString ouRemark = rtl::OUString::valueOf(m_nSuccessfulSignatureNumber) +
		rtl::OUString(RTL_ASCII_USTRINGPARAM( "/" ))
		+ rtl::OUString::valueOf(m_nTotalSignatureNumber);
	ouMessage += rtl::OUString(RTL_ASCII_USTRINGPARAM("\t")) + ouRemark;

	return ouMessage;
}

rtl::OUString SAL_CALL XSecTester::transfer_without_sec( 
	const rtl::OUString& inputFileName, 
	const rtl::OUString& outputFileName,
	sal_Bool isBridgeInvolved)
	throw (cssu::RuntimeException)
{
	rtl::OUString ouMessage;
	
	cssu::Reference< cssi::XInputStream > xInputStream = createInputStream(inputFileName);
	
	if (xInputStream != NULL ) 
	{
		/* create SAX Parser */
		const rtl::OUString sSaxParser ( 
			RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Parser") );
		m_xSaxParser = cssu::Reference < cssxs::XParser > ( mxMSF->createInstance( sSaxParser ), cssu::UNO_QUERY );

		/* create SAX Writer */
		const rtl::OUString sSaxWriter ( 
			RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Writer") );
		cssu::Reference < cssi::XActiveDataSource > xSaxWriter
			( mxMSF->createInstance( sSaxWriter ), cssu::UNO_QUERY );
		cssu::Reference < cssxs::XDocumentHandler > xSaxWriterHandler( 
			xSaxWriter, cssu::UNO_QUERY);
			
		if (!isBridgeInvolved)
		{
			/* connect the SAX Parser and the SAX Writer */
			m_xSaxParser->setDocumentHandler ( xSaxWriterHandler );
		}
		else
		{
			/* create Java Flat Filter */
			const rtl::OUString sJavaFlatFilter( 
				RTL_CONSTASCII_USTRINGPARAM( JAVAFLATFILTER_COMPONENT ) );
			cssu::Reference < cssxs::XParser > xJavaFilterParser
				( mxMSF->createInstance( sJavaFlatFilter ), cssu::UNO_QUERY );
			cssu::Reference < cssxs::XDocumentHandler > xJavaFilterHandler(
				xJavaFilterParser, cssu::UNO_QUERY );

			/* connect the SAX Parser, the Java Flat Filter and the SAX Writer */
			xJavaFilterParser->setDocumentHandler( xSaxWriterHandler );
			m_xSaxParser->setDocumentHandler ( xJavaFilterHandler );
		}
		

		/* set output stream */
		cssu::Reference< cssi::XOutputStream > xOutputStream =
				createOutputStream(outputFileName);
		xSaxWriter->setOutputStream( xOutputStream );

		/* prepare input stream */
		cssxs::InputSource aInput;
		aInput.sSystemId = inputFileName;
		aInput.aInputStream = xInputStream;
		
		TimeValue startTime, endTime;
		osl_getSystemTime( &startTime );

		m_xSaxParser->parseStream ( aInput );
		
		xOutputStream->closeOutput();
		xInputStream->closeInput();
		
		osl_getSystemTime( &endTime );
		
		double diff = ((double)((endTime.Nanosec + endTime.Seconds*1000000000.0)
				 - (startTime.Nanosec + startTime.Seconds*1000000000.0)))/((double)1000000000.0);
		char buf[32];
		sprintf(buf, "%.2f", diff);
		ouMessage += rtl::OUString(RTL_ASCII_USTRINGPARAM(buf));
	}

	return ouMessage;
}

void SAL_CALL XSecTester::setCryptoDir(const rtl::OUString & javaDirName, const rtl::OUString & cDirName)
	throw (cssu::RuntimeException)
{
	m_ouJavaCryptokenDir = javaDirName;
	m_ouCCryptokenDir = cDirName;
}

rtl::OUString XSecTester_getImplementationName ()
	throw (cssu::RuntimeException)
{
	return rtl::OUString ( RTL_CONSTASCII_USTRINGPARAM ( IMPLEMENTATION_NAME ) );
}

sal_Bool SAL_CALL XSecTester_supportsService( const rtl::OUString& ServiceName ) 
	throw (cssu::RuntimeException)
{
	return ServiceName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(SERVICE_NAME));
}

cssu::Sequence< rtl::OUString > SAL_CALL XSecTester_getSupportedServiceNames(  ) 
	throw (cssu::RuntimeException)
{
	cssu::Sequence < rtl::OUString > aRet(1);
	rtl::OUString* pArray = aRet.getArray();
	pArray[0] =  rtl::OUString ( RTL_CONSTASCII_USTRINGPARAM ( SERVICE_NAME ) );
	return aRet;
}
#undef SERVICE_NAME

cssu::Reference< cssu::XInterface > SAL_CALL XSecTester_createInstance( 
	const cssu::Reference< cssl::XMultiServiceFactory > & rSMgr)
	throw( cssu::Exception )
{
	return (cppu::OWeakObject*) new XSecTester( rSMgr );
}

/* XServiceInfo */
rtl::OUString SAL_CALL XSecTester::getImplementationName(  ) 
	throw (cssu::RuntimeException)
{
	return XSecTester_getImplementationName();
}
sal_Bool SAL_CALL XSecTester::supportsService( const rtl::OUString& rServiceName ) 
	throw (cssu::RuntimeException)
{
	return XSecTester_supportsService( rServiceName );
}
cssu::Sequence< rtl::OUString > SAL_CALL XSecTester::getSupportedServiceNames(  ) 
	throw (cssu::RuntimeException)
{
	return XSecTester_getSupportedServiceNames();
}
