/*************************************************************************
 *
 *	$RCSfile: moz_profile.cxx,v $
 *
 *	$Revision: 1.2 $
 *
 *	last change: $Author: mmi $ $Date: 2004/07/28 02:27:26 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include <rtl/ustring.hxx>
#include <unotools/streamhelper.hxx>

#ifndef	_OSL_SECURITY_HXX_
#include <osl/security.hxx>
#endif

using namespace ::com::sun::star;

#define MAGICNUMBER		0x76644441
#define LENGTH_OF_LONG		4
#define LENGTH_OF_NODE		32
#define ROOTNODE_OF_HEADER	12
#define OFFSET_OF_TYPE		10
#define OFFSET_OF_NAMELOCATION	4
#define OFFSET_OF_NAMELENGTH	8
#define OFFSET_OF_VALUELOCATION	20
#define OFFSET_OF_VALUELENGTH	16
#define OFFSET_OF_LEFT		12
#define OFFSET_OF_ENTRY		20
#define OFFSET_OF_SUBKEY	16

#define KEY_COMMON		"Common"
#define KEY_PROFILES		"Profiles"
#define ENTRY_CURRENTPROFILE	"CurrentProfile"
#define ENTRY_DIRECTORY		"directory"

int readStream(rtl::OUString sRegistryFileName, ULONG startPoint, int length, uno::Sequence< sal_Int8 >& aData)
{
	SvFileStream* pStream = new SvFileStream( sRegistryFileName, STREAM_READ );
	
	if (pStream == NULL)
	{
		return -1;
	}
	
	pStream->Seek( STREAM_SEEK_TO_END );
	ULONG nBytes = pStream->Tell();

	if (nBytes < startPoint+length)
	{
		delete pStream;
		return -1;
	}
	
	pStream->Seek( STREAM_SEEK_TO_BEGIN );
	SvLockBytesRef xLockBytes = new SvLockBytes( pStream, TRUE );
	uno::Reference< io::XInputStream > xInputStream = new utl::OInputStreamHelper( xLockBytes, nBytes );

	if (!xInputStream.is())
	{
		delete pStream;
		return -1;
	}
	
	xInputStream->skipBytes((sal_Int32)startPoint);
	int numbers = xInputStream->readBytes( aData, length );

	xInputStream->closeInput();

	return numbers;
}

ULONG getULONGFromBuffer(const sal_Int8* pData, ULONG offset)
{
	ULONG data = (unsigned char)pData[offset+3];
	data <<= 8;
	data += (unsigned char)pData[offset+2];
	data <<= 8;
	data += (unsigned char)pData[offset+1];
	data <<= 8;
	data += (unsigned char)pData[offset];
	
	return data;
}

int getIntFromBuffer(const sal_Int8* pData, ULONG offset)
{
	int data = (unsigned char)pData[offset+1];
	data <<= 8;
	data += (unsigned char)pData[offset];
	
	return data;
}

bool getString(rtl::OUString sRegistryFileName, ULONG startPoint, int length, rtl::OUString& data)
{
	if (length > 1024)
	{
		length = 1024;
	}
	
	uno::Sequence< sal_Int8 > aString( length );
	int numbers = readStream(sRegistryFileName, startPoint, length, aString);

	if (numbers < length)
	{
		return false;
	}
	
	const sal_Int8* readBytes = ( const sal_Int8* )aString.getArray();
					
	sal_Char cString[1025];
	for (int i=0; i<length; i++)
	{
		cString[i] = (sal_Char)(*(readBytes+i));
	}
	
//	cString[length]=0;
//	fprintf(stdout, "%s\n", cString);
					
	data = rtl::OStringToOUString(rtl::OString((const sal_Char*)cString, length), RTL_TEXTENCODING_UTF8);
	return true;
}

bool getULONG(rtl::OUString sRegistryFileName, ULONG startPoint, ULONG& data)
{
	uno::Sequence< sal_Int8 > aNumber( LENGTH_OF_LONG );
	int numbers = readStream(sRegistryFileName, startPoint, LENGTH_OF_LONG, aNumber);

	if (numbers < LENGTH_OF_LONG)
	{
		return false;
	}

	const sal_Int8* readBytes = ( const sal_Int8* )aNumber.getArray();
	
	data = getULONGFromBuffer(readBytes, 0);
	return true;
}

bool checkMagic(rtl::OUString sRegistryFileName)
{
	ULONG magic;
	
	if (getULONG(sRegistryFileName, 0, magic))
	{
		return (magic == MAGICNUMBER);
	}
	else
	{
		return false;
	}
}

bool findSubKey(rtl::OUString sRegistryFileName, ULONG startPoint, const char *keyName, ULONG& keyLocation)
{
	if (startPoint == 0)
	{
		return false;
	}
	
	uno::Sequence< sal_Int8 > aNode( LENGTH_OF_NODE );
	int numbers = readStream(sRegistryFileName, startPoint, LENGTH_OF_NODE, aNode);

	if (numbers == LENGTH_OF_NODE)
	{
		const sal_Int8* readBytes = ( const sal_Int8* )aNode.getArray();
		ULONG subkeyLocation = getULONGFromBuffer(readBytes, OFFSET_OF_SUBKEY);
		
		while (subkeyLocation != 0)
		{
			uno::Sequence< sal_Int8 > aSubNode( LENGTH_OF_NODE );
			numbers = readStream(sRegistryFileName, subkeyLocation, LENGTH_OF_NODE, aSubNode);
			
			if (numbers == LENGTH_OF_NODE)
			{
				const sal_Int8* subkeyReadBytes = ( const sal_Int8* )aSubNode.getArray();
				
				ULONG nameLocation = getULONGFromBuffer(subkeyReadBytes, OFFSET_OF_NAMELOCATION);
				int nameLength = getIntFromBuffer(subkeyReadBytes, OFFSET_OF_NAMELENGTH);
				rtl::OUString ouName;
				
				if (getString(sRegistryFileName, nameLocation, nameLength, ouName))
				{
					if (!ouName.compareToAscii(keyName))
					{
						keyLocation = subkeyLocation;
						return true;
					}
				}
				else
				{
					return false;
				}
				
				subkeyLocation = getULONGFromBuffer(subkeyReadBytes, OFFSET_OF_LEFT);
			}
			else
			{
				return false;
			}
		}
	}
	
	return false;
}

bool findEntry(rtl::OUString sRegistryFileName, ULONG startPoint, const char *entryName, ULONG& entryLocation)
{
	if (startPoint == 0)
	{
		return false;
	}
	
	uno::Sequence< sal_Int8 > aNode( LENGTH_OF_NODE );
	int numbers = readStream(sRegistryFileName, startPoint, LENGTH_OF_NODE, aNode);

	if (numbers == LENGTH_OF_NODE)
	{
		const sal_Int8* readBytes = ( const sal_Int8* )aNode.getArray();
		ULONG _entryLocation = getULONGFromBuffer(readBytes, OFFSET_OF_ENTRY);
		
		while (_entryLocation != 0)
		{
			uno::Sequence< sal_Int8 > aSubNode( LENGTH_OF_NODE );
			numbers = readStream(sRegistryFileName, _entryLocation, LENGTH_OF_NODE, aSubNode);
			
			if (numbers == LENGTH_OF_NODE)
			{
				const sal_Int8* entryReadBytes = ( const sal_Int8* )aSubNode.getArray();
				
				ULONG nameLocation = getULONGFromBuffer(entryReadBytes, OFFSET_OF_NAMELOCATION);
				int nameLength = getIntFromBuffer(entryReadBytes, OFFSET_OF_NAMELENGTH);
				rtl::OUString ouName;
				
				if (getString(sRegistryFileName, nameLocation, nameLength, ouName))
				{
					if (!ouName.compareToAscii(entryName))
					{
						entryLocation = _entryLocation;
						return true;
					}
				}
				else
				{
					return false;
				}
				
				_entryLocation = getULONGFromBuffer(entryReadBytes, OFFSET_OF_LEFT);
			}
			else
			{
				return false;
			}
		}
	}
	
	return false;
}

bool getEntryValue(rtl::OUString sRegistryFileName, ULONG startPoint, rtl::OUString& sValue)
{
	if (startPoint == 0)
	{
		return false;
	}
	
	uno::Sequence< sal_Int8 > aNode( LENGTH_OF_NODE );
	int numbers = readStream(sRegistryFileName, startPoint, LENGTH_OF_NODE, aNode);

	if (numbers == LENGTH_OF_NODE)
	{
		const sal_Int8* readBytes = ( const sal_Int8* )aNode.getArray();
		
		short type = readBytes[OFFSET_OF_TYPE+1];
		type<<=8;
		type += readBytes[OFFSET_OF_TYPE];
		
		if (type > 0x10) /* an entry */
		{
			ULONG valueLocation = getULONGFromBuffer(readBytes, OFFSET_OF_VALUELOCATION);
			int valueLength = (int)getULONGFromBuffer(readBytes, OFFSET_OF_VALUELENGTH);
			
			return getString(sRegistryFileName, valueLocation, valueLength, sValue);
		}
	}
	
	return false;
}

bool getMozillaCurrentProfile(rtl::OUString& profilePath)
{
	::osl::Security aSec;
	::rtl::OUString strHome;
	sal_Bool bRes = aSec.getHomeDir( strHome );
	
	if ( sal_False == bRes)
	{
		//fprintf(stdout, "can't get user home directory!\n");
		return false;
	}
	
	//fprintf(stdout, "home:[%s]\n", rtl::OUStringToOString(strHome, RTL_TEXTENCODING_ASCII_US).getStr());
                                          
#ifdef WNT
	rtl::OUString aRegistryFileName = strHome.copy(8);
	aRegistryFileName += rtl::OUString::createFromAscii("/../Application Data/Mozilla/registry.dat");

	//fprintf(stdout, "registry.dat:[%s]\n", rtl::OUStringToOString(aRegistryFileName, RTL_TEXTENCODING_ASCII_US).getStr());
#else
	rtl::OUString aRegistryFileName = strHome.copy(7);
	aRegistryFileName += rtl::OUString::createFromAscii("/.mozilla/appreg");

	//fprintf(stdout, "registry.dat:[%s]\n", rtl::OUStringToOString(aRegistryFileName, RTL_TEXTENCODING_ASCII_US).getStr());
#endif    
	
	if (checkMagic(aRegistryFileName))
	{
		ULONG rootLocation;
			
		if (getULONG(aRegistryFileName, ROOTNODE_OF_HEADER, rootLocation))
		{
			ULONG commonLocation;
			if (findSubKey(aRegistryFileName, rootLocation, KEY_COMMON, commonLocation))
			{
				ULONG profilesLocation;
				if (findSubKey(aRegistryFileName, commonLocation, KEY_PROFILES, profilesLocation))
				{
					ULONG currentprofileLocation;
					if (findEntry(aRegistryFileName, profilesLocation, ENTRY_CURRENTPROFILE, currentprofileLocation))
					{
						rtl::OUString sCurrentProfile;
						
						if (getEntryValue(aRegistryFileName, currentprofileLocation, sCurrentProfile))
						{
							ULONG defaultprofileLocation;
							if (findSubKey(aRegistryFileName, 
								profilesLocation,
								rtl::OUStringToOString(sCurrentProfile, RTL_TEXTENCODING_ASCII_US).getStr(),
								defaultprofileLocation))
							{
								ULONG directoryLocation;
								if (findEntry(aRegistryFileName, defaultprofileLocation, ENTRY_DIRECTORY, directoryLocation))
								{
									return getEntryValue(aRegistryFileName, directoryLocation, profilePath);
								}
							}
						}
					}
				}
			}
		}
	}
	
	return false;
}

/*
int SAL_CALL main( int argc, char **argv )
{
	rtl::OUString sProfilePath;
	
	if (getMozillaCurrentProfile(sProfilePath))
	{
		fprintf(stdout, "profile:[%s]\n", rtl::OUStringToOString(sProfilePath, RTL_TEXTENCODING_ASCII_US).getStr());
		return 0;
	}
	else
	{
		fprintf(stdout, "error in profile!\n");
		return -1;
	}
} 
*/

/*
 * the following source is just for testing
 */
#if 0
void getNode(rtl::OUString sRegistryFileName, ULONG startPoint, int indent)
{
	if (startPoint == 0)
	{
		return;
	}
	
	uno::Sequence< sal_Int8 > aNode( LENGTH_OF_NODE );
	int numbers = readStream(sRegistryFileName, startPoint, LENGTH_OF_NODE, aNode);

	if (numbers == LENGTH_OF_NODE)
	{
		const sal_Int8* readBytes = ( const sal_Int8* )aNode.getArray();
		bool bNoError = true;

		rtl::OUString ouName;
		rtl::OUString ouValue;
		
		ULONG nameLocation = getULONGFromBuffer(readBytes, OFFSET_OF_NAMELOCATION);
		int nameLength = getIntFromBuffer(readBytes, OFFSET_OF_NAMELENGTH);
		
		bNoError &= getString(sRegistryFileName, nameLocation, nameLength, ouName);
		
		short type = readBytes[OFFSET_OF_TYPE+1];
		type<<=8;
		type += readBytes[OFFSET_OF_TYPE];
		
		if (type > 0x10) /* an entry */
		{
			ULONG valueLocation = getULONGFromBuffer(readBytes, OFFSET_OF_VALUELOCATION);
			int valueLength = (int)getULONGFromBuffer(readBytes, OFFSET_OF_VALUELENGTH);
			
			bNoError &= getString(sRegistryFileName, valueLocation, valueLength, ouValue);
		}
		
		/* output */
		for (int i=0;i<indent*4;i++) fprintf(stdout, " ");
		if (type > 0x10)
		{
			fprintf(stdout, "ENTRY:");
			fprintf(stdout, "[%s]=[%s]\n",
				rtl::OUStringToOString(ouName, RTL_TEXTENCODING_ASCII_US).getStr(),
				rtl::OUStringToOString(ouValue, RTL_TEXTENCODING_ASCII_US).getStr());
		}
		else
		{
			fprintf(stdout, "KEY:");
			fprintf(stdout, "[%s]\n", rtl::OUStringToOString(ouName, RTL_TEXTENCODING_ASCII_US).getStr());
		}
		
		if (bNoError)
		{
			if (type < 0x10) /* a key */
			{
				ULONG entryLocation = getULONGFromBuffer(readBytes, OFFSET_OF_ENTRY);
				getNode(sRegistryFileName, entryLocation, indent+1);
				
				ULONG subkeyLocation = getULONGFromBuffer(readBytes, OFFSET_OF_SUBKEY);
				getNode(sRegistryFileName, subkeyLocation, indent+1);
			}
			
			ULONG leftLocation = getULONGFromBuffer(readBytes, OFFSET_OF_LEFT);
			getNode(sRegistryFileName, leftLocation, indent);
		}
	}
}

void getNodeTree(rtl::OUString sRegistryFileName, ULONG startPoint)
{
	getNode(sRegistryFileName, startPoint, 0);
}
#endif
