/*************************************************************************
 *
 *	$RCSfile: xsecparser.hxx,v $
 *
 *	$Revision: 1.2 $
 *
 *	last change: $Author: mmi $ $Date: 2004/08/12 02:29:21 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _XSEC_CTL_PARSER_HXX
#define _XSEC_CTL_PARSER_HXX

#include <xsecctl.hxx>

#include <com/sun/star/xml/sax/XParser.hpp>
#include <com/sun/star/lang/XInitialization.hpp>
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#include <com/sun/star/xml/sax/XAttributeList.hpp>

#include <cppuhelper/implbase2.hxx>

class XSecParser: public cppu::WeakImplHelper2 
< 
	com::sun::star::xml::sax::XDocumentHandler,
	com::sun::star::lang::XInitialization
>
/****** XSecController.hxx/CLASS XSecParser ***********************************
 *
 *   NAME
 *	XSecParser -- a SAX parser that can detect security elements
 *
 *   FUNCTION
 *	The XSecParser object is connected on the SAX chain and detects 
 *	security elements in the SAX event stream, then notifies
 *	the XSecController.
 *
 *   HISTORY
 *	05.01.2004 -	Interface supported: XDocumentHandler, XInitialization
 *
 *   NOTES
 *	This class is used when importing a document.
 *
 *   AUTHOR
 *	Michael Mi
 *	Email: michael.mi@sun.com
 ******************************************************************************/
{
	friend class XSecController;
private:
	/*
	 * the following members are used to reserve the signature information,
	 * including X509IssuerName, X509SerialNumber, and X509Certificate,etc.
	 */
	rtl::OUString m_ouX509IssuerName;
	rtl::OUString m_ouX509SerialNumber;
	rtl::OUString m_ouX509Certificate;
	rtl::OUString m_ouDigestValue;
	rtl::OUString m_ouSignatureValue;
	rtl::OUString m_ouDate;
	//rtl::OUString m_ouTime;

	/*
	 * whether inside a particular element
	 */
	bool m_bInX509IssuerName;
	bool m_bInX509SerialNumber;
	bool m_bInX509Certificate;
	bool m_bInDigestValue;
	bool m_bInSignatureValue;
	bool m_bInDate;
	//bool m_bInTime;
	
	/*
	 * the XSecController collaborating with XSecParser
	 */
	XSecController* m_pXSecController;
	
	/*
	 * the next XDocumentHandler on the SAX chain
	 */
	com::sun::star::uno::Reference< 
		com::sun::star::xml::sax::XDocumentHandler > m_xNextHandler;

	/*
	 * this string is used to remember the current handled reference's URI,
	 *
	 * because it can be decided whether a stream reference is xml based or binary based
	 * only after the Transforms element is read in, so we have to reserve the reference's
	 * URI when the startElement event is met.
	 */
	rtl::OUString m_currentReferenceURI;
	bool m_bReferenceUnresolved; 

private:
	rtl::OUString getIdAttr(const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XAttributeList >& xAttribs );
	
public:
	XSecParser( XSecController* pXSecController, 
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XDocumentHandler >& xNextHandler );
	~XSecParser(){};
	
	/*
	 * XDocumentHandler 
	 */
	virtual void SAL_CALL startDocument(  )
		throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);
		
	virtual void SAL_CALL endDocument(  )
		throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);
		
	virtual void SAL_CALL startElement(
		const rtl::OUString& aName, 
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XAttributeList >& xAttribs )
		throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);
		
	virtual void SAL_CALL endElement( const rtl::OUString& aName ) 
		throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);
		
	virtual void SAL_CALL characters( const rtl::OUString& aChars )
		throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);
		
	virtual void SAL_CALL ignorableWhitespace( const rtl::OUString& aWhitespaces )
		throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);
		
	virtual void SAL_CALL processingInstruction(
		const rtl::OUString& aTarget,
		const rtl::OUString& aData )
		throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);
		
	virtual void SAL_CALL setDocumentLocator(
		const com::sun::star::uno::Reference<
			com::sun::star::xml::sax::XLocator >& xLocator )
		throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);
		
	/*
	 * XInitialization 
	 */
	virtual void SAL_CALL initialize(
		const com::sun::star::uno::Sequence< com::sun::star::uno::Any >& aArguments )
		throw(com::sun::star::uno::Exception, com::sun::star::uno::RuntimeException);
};
	
#endif	
	
