/*************************************************************************
 *
 *  $RCSfile: xmlstyle.hxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: rt $ $Date: 2005/01/11 14:24:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _XMLOFF_XMLSTYLE_HXX
#define _XMLOFF_XMLSTYLE_HXX

#ifndef _SAL_CONFIG_H_
#include "sal/config.h"
#endif

#ifndef INCLUDED_XMLOFF_DLLAPI_H
#include "xmloff/dllapi.h"
#endif

#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif

#ifndef _RSCSFX_HXX //autogen wg. SfxStyleFamily
#include <rsc/rscsfx.hxx>
#endif

#ifndef _RTTI_HXX
#include <tools/rtti.hxx>
#endif
#ifndef _UNIVERSALL_REFERENCE_HXX
#include <uniref.hxx>
#endif

#ifndef _XMLOFF_XMLTKMAP_HXX
#include "xmltkmap.hxx"
#endif
#ifndef _XMLOFF_XMLICTXT_HXX
#include "xmlictxt.hxx"
#endif

class SvXMLStylesContext_Impl;
class SvXMLUnitConverter;
class SvXMLImportPropertyMapper;

namespace com { namespace sun { namespace star { namespace container
{
	class XNameContainer;
} } } }

enum XMLStyleStylesElemTokens
{
	XML_TOK_STYLE_STYLE,
	XML_TOK_STYLE_PAGE_MASTER,
	XML_TOK_TEXT_LIST_STYLE,
	XML_TOK_TEXT_OUTLINE,
	XML_TOK_STYLES_GRADIENTSTYLES,
	XML_TOK_STYLES_HATCHSTYLES,
	XML_TOK_STYLES_BITMAPSTYLES,
	XML_TOK_STYLES_TRANSGRADIENTSTYLES,
	XML_TOK_STYLES_MARKERSTYLES,
	XML_TOK_STYLES_DASHSTYLES,
	XML_TOK_TEXT_NOTE_CONFIG,
	XML_TOK_TEXT_BIBLIOGRAPHY_CONFIG,
	XML_TOK_TEXT_LINENUMBERING_CONFIG,
	XML_TOK_STYLE_DEFAULT_STYLE,
	XML_TOK_STYLE_STYLES_ELEM_END=XML_TOK_UNKNOWN
};

class XMLOFF_DLLPUBLIC SvXMLStyleContext : public SvXMLImportContext
{
	::rtl::OUString		aName;
	::rtl::OUString		aDisplayName;
	::rtl::OUString		aParentName;// Will be moved to XMLPropStyle soon!!!!
	::rtl::OUString		aFollow;	// Will be moved to XMLPropStyle soon!!!!

	::rtl::OUString		aHelpFile;	// Will be removed very soon!!!!

	sal_uInt32			nHelpId;	// Will be removed very soon!!!!
	sal_uInt16			nFamily;

	sal_Bool			bValid : 1;	// Set this to false in CreateAndInsert
									// if the style shouldn't be processed
									// by Finish() or si somehow invalid.
	sal_Bool			bNew : 1;	// Set this to false in CreateAnsInsert
									// if the style is already existing.
	sal_Bool			bDefaultStyle : 1;

protected:

	virtual void SetAttribute( sal_uInt16 nPrefixKey,
							   const ::rtl::OUString& rLocalName,
							   const ::rtl::OUString& rValue );

	void SetFamily( sal_uInt16 nSet ) { nFamily = nSet; }


public:

	TYPEINFO();

	SvXMLStyleContext( SvXMLImport& rImport, sal_uInt16 nPrfx,
		const ::rtl::OUString& rLName,
		const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList >& xAttrList,
	sal_uInt16 nFamily=0, sal_Bool bDefaultStyle = sal_False );

	virtual ~SvXMLStyleContext();

	virtual SvXMLImportContext *CreateChildContext( sal_uInt16 nPrefix,
		const ::rtl::OUString& rLocalName,
		const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList > & xAttrList );

	virtual void StartElement(
		const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList > & xAttrList );

	const ::rtl::OUString&	GetName() const { return aName; }
	const ::rtl::OUString&	GetDisplayName() const { return aDisplayName.getLength() ? aDisplayName : aName; }
    const ::rtl::OUString&  GetParentName() const { return aParentName; }
	const ::rtl::OUString&	GetFollow() const { return aFollow; }

	const ::rtl::OUString&	GetHelpFile() const { return aHelpFile; }
	sal_uInt32	GetHelpId() const { return nHelpId; }

	sal_uInt16 GetFamily() const { return nFamily; }

	BOOL IsValid() const { return bValid; }
	void SetValid( sal_Bool b ) { bValid = b; }

	BOOL IsNew() const { return bNew; }
	void SetNew( sal_Bool b ) { bNew = b; }

	// This method is called for every default style
	virtual void SetDefaults();

	// This method is called for every style. It must create it and insert
	// it into the document.
	virtual void CreateAndInsert( sal_Bool bOverwrite );

	// This method is called for every style. It must create it and insert
	// it into the document if this hasn't happened already in CreateAndInsert().
	virtual void CreateAndInsertLate( sal_Bool bOverwrite );

	// This method is called fpr every style after all styles have been
	// inserted into the document.
	virtual void Finish( sal_Bool bOverwrite );

	sal_Bool IsDefaultStyle() const { return bDefaultStyle; }

	/** if this method returns true, its parent styles context
		should not add it to its container.<br>
		Transient styles can't be accessed from its
		parent SvXMLStylesContext after theyre imported and
		the methods	CreateAndInsert(), CreateAndInsertLate()
		and Finish() will not be called.
		The default return value is false
	*/
	virtual BOOL IsTransient() const;
};

class XMLOFF_DLLPUBLIC SvXMLStylesContext : public SvXMLImportContext
{
	const ::rtl::OUString sParaStyleServiceName;
	const ::rtl::OUString sTextStyleServiceName;

	SvXMLStylesContext_Impl	*pImpl;
	SvXMLTokenMap			*pStyleStylesElemTokenMap;


	::com::sun::star::uno::Reference <
					::com::sun::star::container::XNameContainer > xParaStyles;
	::com::sun::star::uno::Reference <
					::com::sun::star::container::XNameContainer > xTextStyles;

	UniReference < SvXMLImportPropertyMapper > xParaImpPropMapper;
	UniReference < SvXMLImportPropertyMapper > xTextImpPropMapper;
	UniReference < SvXMLImportPropertyMapper > xShapeImpPropMapper;
	mutable UniReference < SvXMLImportPropertyMapper > xChartImpPropMapper;
	mutable UniReference < SvXMLImportPropertyMapper > xPageImpPropMapper;

	SAL_DLLPRIVATE const SvXMLTokenMap& GetStyleStylesElemTokenMap();

    SAL_DLLPRIVATE SvXMLStylesContext(SvXMLStylesContext &); // not defined
    SAL_DLLPRIVATE void operator =(SvXMLStylesContext &); // not defined

protected:

	sal_uInt32 GetStyleCount() const;
	SvXMLStyleContext *GetStyle( sal_uInt32 i );
	const SvXMLStyleContext *GetStyle( sal_uInt32 i ) const;

	virtual SvXMLStyleContext *CreateStyleChildContext( sal_uInt16 nPrefix,
		const ::rtl::OUString& rLocalName,
		const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList > & xAttrList );

	virtual SvXMLStyleContext *CreateStyleStyleChildContext( sal_uInt16 nFamily,
		sal_uInt16 nPrefix, const ::rtl::OUString& rLocalName,
		const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList > & xAttrList );

	virtual SvXMLStyleContext *CreateDefaultStyleStyleChildContext(
		sal_uInt16 nFamily, sal_uInt16 nPrefix,
		const ::rtl::OUString& rLocalName,
		const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList > & xAttrList );

	virtual sal_Bool InsertStyleFamily( sal_uInt16 nFamily ) const;

public:
	TYPEINFO();

	SvXMLStylesContext( SvXMLImport& rImport, sal_uInt16 nPrfx,
		const ::rtl::OUString& rLName,
		const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList > & xAttrList );

	virtual ~SvXMLStylesContext();

	// Create child element.
	virtual SvXMLImportContext *CreateChildContext( sal_uInt16 nPrefix,
		const ::rtl::OUString& rLocalName,
		const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList > & xAttrList );

	// This method must be overloaded to insert styles into the document.
	virtual void EndElement();

	// This allows to add an SvXMLStyleContext to this context from extern
	void AddStyle(SvXMLStyleContext& rNew);

	const SvXMLStyleContext *FindStyleChildContext(
									  sal_uInt16 nFamily,
									  const ::rtl::OUString& rName,
									  BOOL bCreateIndex=sal_False ) const;
	virtual sal_uInt16 GetFamily( const ::rtl::OUString& rFamily ) const;
	virtual UniReference < SvXMLImportPropertyMapper > GetImportPropertyMapper(
						sal_uInt16 nFamily ) const;

	virtual ::com::sun::star::uno::Reference <
					::com::sun::star::container::XNameContainer >
		GetStylesContainer( sal_uInt16 nFamily ) const;
	virtual ::rtl::OUString GetServiceName( sal_uInt16 nFamily ) const;

	void CopyStylesToDoc( sal_Bool bOverwrite, sal_Bool bFinish=sal_True );
	void FinishStyles( sal_Bool bOverwrite );

	// This method must be called to release the references to all styles
	// that are stored in the context.
	void Clear();
};

#endif	//  _XMLOFF_XMLSTYLE_HXX

