/*************************************************************************
 *
 *  $RCSfile: HelpCompiler.java,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/01/27 10:13:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/*******************************************************************************
 * TODO
 * *************************************************************************
 *  
 ******************************************************************************/

package com.sun.star.help;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;

public class HelpCompiler implements HelpURLStreamHandlerFactory.Notify {

	private static final String makeRelPrefix = ".." + File.separator;
	private static HelpURLStreamHandlerFactory urlHandler;
	public static void initURLHandler() {
		try {
			// Determine the urlfactory ...
			String urlmode = HelpDatabases.getURLMode();
			urlHandler = new HelpURLStreamHandlerFactory(urlmode);
			URL.setURLStreamHandlerFactory(urlHandler);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	private Hashtable streamTable;
	private String inputFile, src, module, lang;
	private String resEmbStylesheet;

	// HACK: Only the first instance of HelpCompiler will ever get notified
	// (needed for generating the dependency files). TODO: Move the notify mechanism
	// out of the HelpCompiler class instead of overwriting the static dependencyList
	// with every new HelpCompiler instance
	private static List dependencyList;

	public HelpCompiler(
		Hashtable streamTable,
		String inputFile,
		String src,
		String resEmbStylesheet,
		String module,
		String lang) {
		this.streamTable = streamTable;
		this.inputFile = inputFile;
		this.src = src;
		this.resEmbStylesheet = resEmbStylesheet;
		this.module = module;
		this.lang = lang;
		dependencyList = new ArrayList();

		// ... and clear the returned document
		HelpURLStreamHandlerFactory.setMode(null);

		// works only once ...        
		urlHandler.setNotify(this);
	}

	private Object[] switchFind(Node node) {
		HashSet hs = new HashSet();
		Node next;
		TreeWalker tw = new TreeWalker(node);
		while ((next = tw.getNextElement("switchinline")) != null) {
			Element el = (Element) next;
			if (!el.getAttribute("select").equals("appl"))
				continue;

			NodeList nl = el.getChildNodes();
			for (int i = 0; i < nl.getLength(); ++i) {
				if (nl.item(i).getNodeName().equals("caseinline")) {
					String appl = ((Element) nl.item(i)).getAttribute("select");
					hs.add(appl);
				} else if (nl.item(i).getNodeName().equals("defaultinline")) {
					hs.add("DEFAULT");
				}
			}
		}

		hs.add("DEFAULT");
		return hs.toArray();
	}

	// returns a node representing the whole stuff compiled for the current
	// application.
	private Node clone(Node node, String appl) {
		Node parent = node.cloneNode(false);
		NodeList nl = node.getChildNodes();
		for (int i = 0; i < nl.getLength(); ++i) {
			Node n = nl.item(i);
			if ((n.getNodeName().equals("switchinline")
				|| n.getNodeName().equals("switch"))
				&& ((Element) n).getAttribute("select").equals("appl")) {
				NodeList cl = n.getChildNodes();
				if (appl.equals("DEFAULT")) {
					for (int j = 0; j < cl.getLength(); ++j) {
						Node caseNode = cl.item(j);
						if (caseNode.getNodeName().equals("defaultinline")) {
							NodeList cnl = caseNode.getChildNodes();
							for (int k = 0; k < cnl.getLength(); ++k)
								parent.appendChild(
									clone(
										caseNode.getChildNodes().item(k),
										appl));
							break;
						}
					}
				} else {
					for (int j = 0; j < cl.getLength(); ++j) {
						Node caseNode = cl.item(j);
						if (caseNode.getNodeName().equals("caseinline")
							&& ((Element) caseNode).getAttribute("select").equals(
								appl)) {
							NodeList cnl = caseNode.getChildNodes();
							for (int k = 0; k < cnl.getLength(); ++k)
								parent.appendChild(
									clone(
										caseNode.getChildNodes().item(k),
										appl));
							break;
						}
					}
				}
			} else
				parent.appendChild(clone(nl.item(i), appl));
		}
		return parent;
	}

	public boolean compile() throws UnsupportedEncodingException {
		// we now have the jaroutputstream, which will contain the document.
		// now determine the document as a dom tree in variable docResolved
		String absolutePath;
		String sourcePath;
		File inputFil = new File(inputFile);
		try {
			absolutePath = inputFil.getCanonicalPath();
		} catch (IOException e3) {
			absolutePath = inputFil.getAbsolutePath();
		}
		try {
			sourcePath = new File(src).getCanonicalPath();
		} catch (IOException e3) {
			sourcePath = new File(inputFile).getAbsolutePath();
		}

		byte[] embResolved = null;
		try {
			embResolved = getSourceDocument(inputFil.toURL().toExternalForm());
		} catch (MalformedURLException e4) {
			System.err.println(
				"ERROR: malformed URL '" + inputFile + "': " + e4.getMessage());
			return false;
		}

		// now add path to the document
		// resolve the dom
		if (embResolved == null) {
			System.err.println("ERROR: file not existing: " + sourcePath);
			System.exit(1);
		}

		ByteArrayInputStream inByte = new ByteArrayInputStream(embResolved);
		InputStreamReader inread;
		try {
			inread = new InputStreamReader(inByte, "UTF8");
		} catch (UnsupportedEncodingException e) {
			System.err.println(
				"ERROR: unsupported Encoding '"
					+ inputFile
					+ "': "
					+ e.getMessage());
			return false;
		}

		InputSource inputSource = new InputSource(inread);
		inputSource.setEncoding("UTF8");
		Document docResolvedOrg = null;
		try {
			docResolvedOrg = XmlDocument.createXmlDocument(inputSource, false);
		} catch (Exception e) {
			System.err.println(
				"ERROR: XmlDocument.createXmlDocument() failed for '"
					+ inputFile
					+ "': "
					+ e.getMessage());
			return false;
		}

		// now find all applications for which one has to compile
		String documentId = null;
		String fileName = null;
		String title = null;
		// returns all applications for which one has to compile
		Object[] applications = switchFind(docResolvedOrg);
		for (int i = 0; i < applications.length; ++i) {
			String appl = (String) applications[i];
			// returns a clone of the document with swich-cases resolved
			Element docResolved =
				(Element) clone(docResolvedOrg.getDocumentElement(), appl);
			// now determine the id of the document, which is part of the
			// bookmark - tag (HID)
			Node test;
			TreeWalker treewalker = new TreeWalker(docResolved);
			// a number to determine the anchor of the whole stuff
			HashSet hidlist = new HashSet();
			HashSet extendedHelpText = new HashSet();
			Hashtable keywords = new Hashtable();
			Hashtable helptexts = new Hashtable();

			while ((test = treewalker.getNext()) != null) {
				if (fileName == null
					&& test.getNodeName().equals("filename")) {
					NodeList list = test.getChildNodes();
					Node node = list.item(0);
					if (node.getNodeType() == Node.TEXT_NODE)
						fileName = ((Text) node).getData();
				} else if (
					title == null && test.getNodeName().equals("title")) {
					NodeList list = test.getChildNodes();
					Node node = list.item(0);
					if (node != null && node.getNodeType() == Node.TEXT_NODE)
						title = ((Text) node).getData();
					else
						title = "<notitle>";
				} else if (test.getNodeName().equals("bookmark")) {
					Element el = (Element) test;
					String branch = el.getAttribute("branch");
					String hid = null;
					String anchor = el.getAttribute("id");
					if (branch.startsWith("hid")) {
						int index = branch.lastIndexOf('/');
						if (index != -1) {
							hid = branch.substring(1 + index);
							// one shall serve as a documentId
							if (documentId == null)
								documentId = hid;
							extendedHelpText.add(hid);
							hidlist.add(
								anchor == null
									|| anchor.length() == 0
										? hid
										: hid + "#" + anchor);
						} else
							continue;
					} else if (branch.equals("index")) {
						LinkedList ll = new LinkedList();

						NodeList list = el.getChildNodes();
						for (int j = 0; i < list.getLength(); ++i) {
							Node nd = list.item(i);
							if (!nd.getNodeName().equals("bookmark_value"))
								continue;
							String embedded =
								((Element) nd).getAttribute("embedded");
							boolean isEmbedded =
								embedded != null
									&& "true".equals(embedded.toLowerCase());
							if (isEmbedded)
								continue;

							String keyword =
								((Text) nd.getFirstChild()).getData();
							ll.add(keyword);
						}
						if (!ll.isEmpty())
							keywords.put(anchor, ll);
					} else if (branch.equals("contents")) {
						// currently not used
					}
				} else if (test.getNodeName().equals("ahelp")) {
					String text = dump(test);
					String name = ((Element) test).getAttribute("hid");
					helptexts.put(name, text);
					Iterator iter = extendedHelpText.iterator();
					while (iter.hasNext()) {
						name = (String) iter.next();
						helptexts.put(name, text);
					}

					if (!extendedHelpText.isEmpty())
						extendedHelpText = new HashSet();
				}
			} // now save the info

			addEntryToJarFile(
				appl,
				"text",
				docResolved.toString().getBytes("UTF8"));
			addEntryToJarFile(appl, "hidlist", hidlist);
			addEntryToJarFile(appl, "helptexts", helptexts);
			addEntryToJarFile(appl, "keywords", keywords);
		} // end iteration over all applications

		try {
			addEntryToJarFile(
				"document",
				"id",
				documentId != null
					? documentId.getBytes("UTF8")
					: "".getBytes("UTF8"));
			addEntryToJarFile(
				"document",
				"path",
				fileName != null
					? fileName.getBytes("UTF8")
					: "".getBytes("UTF8"));
			addEntryToJarFile(
				"document",
				"title",
				title != null ? title.getBytes("UTF8") : "".getBytes("UTF8"));
			String actMod = module;
			if (fileName != null && fileName.length() != 0) {
				if (fileName.startsWith("/text/")) {
					actMod = fileName.substring("/text/".length());
					actMod = actMod.substring(0, actMod.indexOf('/'));
				}
			}
			addEntryToJarFile("document", "module", actMod.getBytes("UTF8"));
		} catch (IOException e1) {
			System.err.println(
				"ERROR: IOException in compile(): '" + e1.getMessage());
			return false;
		}
		return true;
	}

	/* (non-Javadoc)
	
	 * @see com.sun.star.help.HelpURLStreamHandlerFactory.Notify#notify(java.net.URL)
	 */

	public void notify(URL requestedURL) {
		dependencyList.add(requestedURL);
	}

	/**
	 * Returns the embedding resolved document
	 */

	HelpIndexer.ParseStuff stuff = null;

	private byte[] getSourceDocument(String filePath) { // initialize ...
		if (stuff == null) {
			stuff = new HelpIndexer.ParseStuff(resEmbStylesheet);
			// Setting the parameters
			stuff.setParameter("Language", lang);
			try {
				stuff.setParameter(
					"fsroot",
					(new File(src)).toURL().toString());
			} catch (MalformedURLException e) {
				System.err.println(
					"ERROR: malformed URL '" + src + "': " + e.getMessage());
				System.exit(1);
			}
		} // ... and parse
		return stuff.parse(filePath);
	}

	private String dump(Node node) {
		String app = new String();
		if (node.hasChildNodes()) {
			NodeList list = node.getChildNodes();
			for (int i = 0; i < list.getLength(); ++i)
				app += dump(list.item(i));
		}
		if (node.getNodeType() == Node.TEXT_NODE) {
			return ((Text) node).getData();
		}
		return app;
	}

	private void addEntryToJarFile(
		String appl,
		String entryName,
		Object keywords) {
		if (keywords == null)
			return;

		streamTable.put(
			(appl + "/" + entryName).toLowerCase().trim(),
			keywords);
	}

	private void addEntryToJarFile(
		String prefix,
		String entryName,
		byte[] bytesToAdd) {
		if (bytesToAdd == null)
			return;

		streamTable.put(
			(prefix + "/" + entryName).toLowerCase().trim(),
			bytesToAdd);
	}
}
