/*
 * TranslateMacro.java
 *
 * Created on 30. Juli 2003, 11:52
 */
package com.sun.star.wizards.tutorial.executer;

import java.util.StringTokenizer;
import java.util.Vector;

/**
 * DOCUMENT ME!
 *
 * @author mc114771
 */
public class TranslateMacro {
	private static TranslateMacro m_trans = null;

	/**
	 * Static initializer for this class. Creates the only instance for that.
	 */
	static {
		new TranslateMacro();
	}

	/**
	 * Creates a new AccessibilityTools object.
	 */
	private TranslateMacro() {
		m_trans = this;
	}

	/**
	 * Creates a new instance of TranslateMacro
	 *
	 * @param macroName DOCUMENT ME!
	 * @param ORGMacro DOCUMENT ME!
	 * @param transPaths DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public static String translateMacro(String macroName, String ORGMacro, Vector transPaths) {
		String transNewMacro = null;
		String header = m_trans.getHeader(ORGMacro);
		String body = m_trans.getBody(ORGMacro);

		transNewMacro = m_trans.transHeader(macroName, header);

		if (!body.equals("")) {
			transNewMacro += ("\n" + m_trans.transBody(body, transPaths));
		}

		return transNewMacro;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param ORGMacro DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	private String getHeader(String ORGMacro) {
		String header = ORGMacro;

		try {
			int index = ORGMacro.indexOf("Sub Action()");
			header = ORGMacro.substring(index);
			index = index + header.indexOf("End Sub") + "End Sub".length();
			header = ORGMacro.substring(0, index);
		} catch (StringIndexOutOfBoundsException ex) {
		}

		return header.trim();
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param ORGMacro DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	private String getBody(String ORGMacro) {
		String body = "";

		try {
			body = ORGMacro.substring(ORGMacro.indexOf("Sub Step_"));
			body = body.trim();
		} catch (StringIndexOutOfBoundsException ex) {
		}

		return body;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param macroName DOCUMENT ME!
	 * @param header DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	private String transHeader(String macroName, String header) {
		String transHeader = "";
		String part1 = "";
		String part2 = "";
		transHeader = header;

		if ((transHeader.indexOf("ExecuteForm") > -1) && (transHeader.indexOf("Index") > -1)) {
			part1 = transHeader.substring(0, transHeader.indexOf("Index"));
			part2 = transHeader.substring(transHeader.indexOf("Index") + "Index".length());
			transHeader = part1 + "Name" + part2;
		}

		if ((transHeader.indexOf("Localisation") > -1) && (transHeader.indexOf("True") > -1)) {
			part1 = transHeader.substring(0, transHeader.indexOf("True"));
			part2 = transHeader.substring(transHeader.indexOf("True") + "True".length());
			transHeader = part1 + "False" + part2;
		}

		return transHeader;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param macro DOCUMENT ME!
	 * @param actionsize DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	private String getAction(String macro, int actionsize) {
		String action = null;

		try {
			String temp = macro.substring(macro.indexOf("Sub Step_" + actionsize));
			action = temp.substring(0, temp.indexOf("End Sub") + 7);
			action = action.trim();
		} catch (StringIndexOutOfBoundsException ex) {
		}

		return action;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param action DOCUMENT ME!
	 * @param paths DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	private String transAction(String action, Vector paths) {
		String result = "";

		try {
			StringTokenizer tokenizer = new StringTokenizer(action, "" + '"');
			int pathsIndex = 0;

			while (tokenizer.hasMoreTokens()) {
				String token = tokenizer.nextToken();

				if (token.indexOf("    path") > -1) {
					result += (token + '"');

					if (pathsIndex < paths.size()) {
						String[] temp = (String[]) paths.get(pathsIndex);

						for (int i = 0; i < temp.length; i++) {
							tokenizer.nextToken();

							String path = temp[i];
							result += (path + '"');
							result += (tokenizer.nextToken() + '"');
						}

						pathsIndex++;
					}
				} else {
					result += (token + '"');
				}
			}

			result = result.substring(0, result.lastIndexOf('"'));
		} catch (StringIndexOutOfBoundsException ex) {
			result = "";
		}

		return result;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param body DOCUMENT ME!
	 * @param transPaths DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	private String transBody(String body, Vector transPaths) {
		String newBody = "";

		try {
			if (body.indexOf("Dim path") < 0) {
				return body;
			}

			char step = body.charAt(body.indexOf("Step_") + 5);
			int stepSize = Character.getNumericValue(step);

			for (int i = 0, j = 0; i <= stepSize; i++) {
				String action = getAction(body, i);

				if (action != null) {
					String temp = transAction(action, (Vector) transPaths.get(j));

					if (!temp.equals("")) {
						newBody = temp + "\n" + newBody;
						j++;
					}
				}
			}
		} catch (ArrayIndexOutOfBoundsException ex) {
			ex.printStackTrace();
		}

		return newBody;
	}
}
