/*************************************************************************
 *
 *  $RCSfile: salobj.h,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kz $ $Date: 2003/11/18 14:49:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SALOBJ_H
#define _SV_SALOBJ_H

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_SYSDATA_HXX
#include <sysdata.hxx>
#endif
#ifndef _SV_SALOBJ_HXX
#include <salobj.hxx>
#endif

// -----------------
// - SalObjectData -
// -----------------

class WinSalObject : public SalObject
{
public:
	HWND					mhWnd;					// Window handle
	HWND					mhWndChild; 			// Child Window handle
	HWND					mhLastFocusWnd; 		// Child-Window, welches als letztes den Focus hatte
	SystemChildData 		maSysData;				// SystemEnvData
	RGNDATA*				mpClipRgnData;			// ClipRegion-Data
	RGNDATA*				mpStdClipRgnData;		// Cache Standard-ClipRegion-Data
	RECT*					mpNextClipRect; 		// Naechstes ClipRegion-Rect
	BOOL					mbFirstClipRect;		// Flag for first cliprect to insert
	WinSalObject*				mpNextObject;			// pointer to next object


    WinSalObject();
    virtual ~WinSalObject();

	virtual void					ResetClipRegion();
	virtual USHORT					GetClipRegionType();
	virtual void					BeginSetClipRegion( ULONG nRects );
	virtual void					UnionClipRegion( long nX, long nY, long nWidth, long nHeight );
	virtual void					EndSetClipRegion();
	virtual void					SetPosSize( long nX, long nY, long nWidth, long nHeight );
	virtual void					Show( BOOL bVisible );
	virtual void					Enable( BOOL nEnable );
	virtual void					GrabFocus();
	virtual void					SetBackground();
	virtual void					SetBackground( SalColor nSalColor );
	virtual const SystemEnvData*	GetSystemData() const;
};

#endif // _SV_SALOBJ_H
