/*************************************************************************
 *
 *  $RCSfile: kdeint.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: kz $ $Date: 2004/08/30 16:22:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <kdeint.hxx>
#include <tools/config.hxx>
#include <settings.hxx>

#include <osl/thread.h>

#include <unistd.h>
#include <cstdio>

using namespace rtl;
using namespace osl;

KDEIntegrator::KDEIntegrator()
{
	meType = DtKDE;
}

KDEIntegrator::~KDEIntegrator()
{
}

static const char* pTryFiles[] =
  {
	"/usr/share/config/kdeglobals",
	"/opt/kde/share/config/kdeglobals",
	"~/.kde2/share/config/kdeglobals",
	"~/.kde/share/config/kdeglobals",
	"~/.kderc"
  };

void KDEIntegrator::GetSystemLook( AllSettings& rSettings )
{
    rtl_TextEncoding aEncoding = osl_getThreadTextEncoding();

	for( unsigned int i = 0; (i < sizeof( pTryFiles )/sizeof(pTryFiles[0])); i++ )
	  {
		String aFile;
		if( pTryFiles[i][0] == '~' )
		  {
			aFile = aHomeDir;
			aFile += String( pTryFiles[i]+1, aEncoding );
		  }
		else
		  aFile = String( ByteString( pTryFiles[i] ), aEncoding );

		if( access( ByteString( aFile, aEncoding ).GetBuffer(), R_OK ) )
		  continue;

#if OSL_DEBUG_LEVEL > 1
		fprintf( stderr, "using %s for style settings\n", ByteString( aFile, aEncoding ).GetBuffer() );
#endif

		StyleSettings aStyleSettings( rSettings.GetStyleSettings() );

		Config aConfig( aFile );
		ByteString aLine;
		if( aConfig.HasGroup( "WM" ) )
		  {
			aConfig.SetGroup( "WM" );

			aLine = aConfig.ReadKey( "activeBackground" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  aStyleSettings.
				SetActiveColor( Color( aLine.GetToken( 0, ',' ).ToInt32(),
									   aLine.GetToken( 1, ',' ).ToInt32(),
									   aLine.GetToken( 2, ',' ).ToInt32() ) );
			aLine = aConfig.ReadKey( "activeBlend" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  aStyleSettings.
				SetActiveColor2( Color( aLine.GetToken( 0, ',' ).ToInt32(),
										aLine.GetToken( 1, ',' ).ToInt32(),
										aLine.GetToken( 2, ',' ).ToInt32() ) );

			aLine = aConfig.ReadKey( "inactiveBackground" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  aStyleSettings.
				SetDeactiveColor( Color( aLine.GetToken( 0, ',' ).ToInt32(),
										 aLine.GetToken( 1, ',' ).ToInt32(),
										 aLine.GetToken( 2, ',' ).ToInt32() ) );
			aLine = aConfig.ReadKey( "inactiveBlend" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  aStyleSettings.
				SetDeactiveColor2( Color( aLine.GetToken( 0, ',' ).ToInt32(),
										  aLine.GetToken( 1, ',' ).ToInt32(),
										  aLine.GetToken( 2, ',' ).ToInt32() ) );

			aLine = aConfig.ReadKey( "inactiveForeground" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  aStyleSettings.
				SetDeactiveTextColor( Color( aLine.GetToken( 0, ',' ).ToInt32(),
											 aLine.GetToken( 1, ',' ).ToInt32(),
											 aLine.GetToken( 2, ',' ).ToInt32() ) );
			aLine = aConfig.ReadKey( "activeForeground" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  aStyleSettings.
				SetActiveTextColor( Color( aLine.GetToken( 0, ',' ).ToInt32(),
										   aLine.GetToken( 1, ',' ).ToInt32(),
										   aLine.GetToken( 2, ',' ).ToInt32() ) );

			aLine = aConfig.ReadKey( "titleFont" );
			if( aLine.Len() )
			  {
				Font aFont= aStyleSettings.GetTitleFont();
				String aFontName( aLine, RTL_TEXTENCODING_UTF8 );
				if( aFontName.GetTokenCount( ',' ) > 0 )
					aFontName = aFontName.GetToken( 0, ',' );
				aFont.SetName( aFontName );
				aStyleSettings.SetTitleFont( aFont );
			  }
		  }

		if( aConfig.HasGroup( "General" ) )
		  {
			aConfig.SetGroup( "General" );

			aLine = aConfig.ReadKey( "foreground" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  {
				Color aFore( aLine.GetToken( 0, ',' ).ToInt32(),
							 aLine.GetToken( 1, ',' ).ToInt32(),
							 aLine.GetToken( 2, ',' ).ToInt32() );
				aStyleSettings.SetDialogTextColor( aFore );
				aStyleSettings.SetMenuTextColor( aFore );
				aStyleSettings.SetButtonTextColor( aFore );
				aStyleSettings.SetRadioCheckTextColor( aFore );
				aStyleSettings.SetGroupTextColor( aFore );
				aStyleSettings.SetLabelTextColor( aFore );
				aStyleSettings.SetInfoTextColor( aFore );
			  }

			aLine = aConfig.ReadKey( "background" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  {
				Color aBack( aLine.GetToken( 0, ',' ).ToInt32(),
							 aLine.GetToken( 1, ',' ).ToInt32(),
							 aLine.GetToken( 2, ',' ).ToInt32() );
				aStyleSettings.Set3DColors( aBack );
				aStyleSettings.SetFaceColor( aBack );
				aStyleSettings.SetDialogColor( aBack );
				aStyleSettings.SetMenuColor( aBack );
				aStyleSettings.SetMenuBarColor( aBack );
				if( aBack == COL_LIGHTGRAY )
				  aStyleSettings.SetCheckedColor( Color( 0xCC, 0xCC, 0xCC ) );
				else
				  {
					Color aColor2 = aStyleSettings.GetLightColor();
					aStyleSettings.
					  SetCheckedColor( Color( (BYTE)(((USHORT)aBack.GetRed()+(USHORT)aColor2.GetRed())/2),
											  (BYTE)(((USHORT)aBack.GetGreen()+(USHORT)aColor2.GetGreen())/2),
											  (BYTE)(((USHORT)aBack.GetBlue()+(USHORT)aColor2.GetBlue())/2)
											  ) );
				  }
			  }

			aLine = aConfig.ReadKey( "selectForeground" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  aStyleSettings.
                SetHighlightTextColor( Color( aLine.GetToken( 0, ',' ).ToInt32(),
											  aLine.GetToken( 1, ',' ).ToInt32(),
											  aLine.GetToken( 2, ',' ).ToInt32() ) );

			aLine = aConfig.ReadKey( "selectBackground" );
			if( aLine.GetTokenCount( ',' ) >= 3 )
			  aStyleSettings.
                SetHighlightColor( Color( aLine.GetToken( 0, ',' ).ToInt32(),
										  aLine.GetToken( 1, ',' ).ToInt32(),
										  aLine.GetToken( 2, ',' ).ToInt32() ) );

			aLine = aConfig.ReadKey( "font" );
			if( aLine.Len() )
			  {
				Font aFont = aStyleSettings.GetAppFont();
				String aFontName( aLine, RTL_TEXTENCODING_UTF8 );
				if( aFontName.GetTokenCount( ',' ) > 0 )
					aFontName = aFontName.GetToken( 0, ',' );
				aFont.SetName( aFontName );

				aStyleSettings.SetAppFont( aFont );
				aStyleSettings.SetHelpFont( aFont );
                aStyleSettings.SetTitleFont( aFont );
                aStyleSettings.SetFloatTitleFont( aFont );
				aStyleSettings.SetMenuFont( aFont );
				aStyleSettings.SetToolFont( aFont );
				aStyleSettings.SetLabelFont( aFont );
				aStyleSettings.SetInfoFont( aFont );
				aStyleSettings.SetRadioCheckFont( aFont );
				aStyleSettings.SetPushButtonFont( aFont );
				aStyleSettings.SetFieldFont( aFont );
				aStyleSettings.SetIconFont( aFont );
				aStyleSettings.SetGroupFont( aFont );
			  }
		  }

		rSettings.SetStyleSettings( aStyleSettings );
	  }
}
