/*************************************************************************
 *
 *  $RCSfile: rptpsound.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: hr $ $Date: 2004/05/10 15:56:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#if defined(SOLARIS) || defined(MACOSX)
#include <poll.h>
#else
#include <sys/poll.h>
#endif

#include <salsound.h>
#include <salimpsound.hxx>

#include <salunx.h>
#include <saldata.hxx>
#include <saldisp.hxx>
#include <psprint/strhelper.hxx>
#include <string.h>
#include <unistd.h>

using namespace vcl_sal;
using namespace vos;
using namespace psp;

BOOL						RPTPSound::s_bConnected			= FALSE;
BOOL						RPTPSound::s_bFailedOnce		= FALSE;
OConnectorSocket			RPTPSound::s_aConnector;
RPTPSound::RPTPSoundList	RPTPSound::s_aSounds;

int RPTPSound::getFileDescriptor()
{
	return *(int*)(oslSocket)s_aConnector;
}

BOOL RPTPSound::connect()
{
	if( s_bConnected && s_aConnector.isValid() )
		return TRUE;

	if( s_bFailedOnce )
		return FALSE;

	s_bConnected = FALSE;

	static const char* env = getenv( "AUDIOSERVER" );
	static const char* portenv = env ? strchr( env, ':' ) : NULL;
	static char sBuf[1024];

	if( ! env && GetSalData() && GetSalData()->GetDisplay() &&
		DisplayString( GetSalData()->GetDisplay()->GetDisplay() ) )
	{
		env = strdup( DisplayString( GetSalData()->GetDisplay()->GetDisplay() ) );
		portenv = strchr( env, ':' );
	}

	int nPort = portenv ? atoi( portenv+1 ) : 5556;
	nPort = nPort ? nPort : 5556;

	strncpy( sBuf, "uninitialized", 14 );
	if( env && portenv )
	{
		if( portenv != env )
		{
			strncpy( sBuf, env, portenv - env );
			sBuf[ portenv - env ] = 0;
		}
		else
			strncpy( sBuf, "localhost", 10 );
	}
	else
		strncpy( sBuf, "localhost", 10 );

	SalDbgAssert( "resolving \"%s\", env = \"%s\", portenv = \"%s\"\n",
				  sBuf,
				  env ? env : "<unset>",
				  portenv ? portenv : "<unset>"
				  );

	::rtl::OUString aHost( sBuf, strlen(sBuf), gsl_getSystemTextEncoding() );

	OInetSocketAddr aAddr( OSocketAddr::resolveHostname( aHost ) );
	aAddr.setPort( nPort );
	s_aConnector = OConnectorSocket();
	TimeValue aTimeout = { 0, 100000 };
	if( s_aConnector.connect( aAddr, &aTimeout ) == ISocketTypes::TResult_Ok )
	{
		s_bConnected = TRUE;
		readLine();
		sendCommand( "set notify=done,pause,continue" );
		GetSalData()->GetLib()->Insert( getFileDescriptor(),
										NULL,
										(YieldFunc)pending,
										(YieldFunc)queued,
										(YieldFunc)handleEvents );
	}
	else
	{
		SalDbgAssert( "RPTPSound::connect to \"%s\" on port %d failed\n", sBuf, nPort );
		s_bFailedOnce = TRUE;
	}
	return s_bConnected;
}

void RPTPSound::disconnect()
{
	if( s_bConnected )
	{
		s_bConnected = FALSE;
		GetSalData()->GetLib()->Remove( getFileDescriptor() );
		s_aConnector.write( "quit\r\n", 6 );
		s_aConnector.close();
		SalDbgAssert( "RPTPSound::disconnect\n" );
	}
}

int RPTPSound::pending( int nFD, void* pObj )
{
	struct pollfd aPollfd;
	aPollfd.fd			= nFD;
	aPollfd.events		= POLLIN;

	poll( &aPollfd, 1, 0 );

	return aPollfd.revents & POLLIN ? 1 : 0;
}

int RPTPSound::queued( int nFD, void* pObj )
{
	return pending( nFD, pObj );
}

int RPTPSound::handleEvents( int nFD, void* pObj )
{
	SalDbgAssert( "RPTPSound::handleEvents\n" );
	ByteString aLine = readLine();
	int nPos;
	if( aLine.GetChar( 0 ) == '@' &&
		( nPos = aLine.Search( "event=" ) ) != STRING_NOTFOUND )
	{
		ULONG nID = ~0;
		RPTPSound* pSound = NULL;

		ByteString aEvent = aLine.Copy( nPos+6 );
		aEvent = GetCommandLineToken( 0, aEvent );
		aEvent.ToLowerAscii();

		if( ( nPos = aLine.Search( "id=#" ) ) != STRING_NOTFOUND )
		{
			nID = aLine.Copy( nPos+4 ).ToInt32();
			pSound = getSoundById( nID );
		}

		if( pSound && pSound->m_pSalSound )
		{
			if( aEvent == "done" )
			{
				if( pSound->m_pSalSound->m_bLoop )
					pSound->play();
				else
					pSound->m_pSalSound->changeStateStop();
			}
			else if( aEvent == "pause" )
				pSound->m_pSalSound->changeStatePause();
			else if( aEvent == "continue" )
				pSound->m_pSalSound->changeStateCont();
		}
	}
	return 0;
}

ByteString RPTPSound::readLine()
{
	static char pAnswerBuffer[ 1024 ];

	if( ! s_bConnected && ! connect() )
		return ByteString();

	memset( pAnswerBuffer, 0, sizeof( pAnswerBuffer ) );
	if( s_aConnector.read( pAnswerBuffer, 1 ) == 1 )
	{
		int nTimes = 0;
		int nPos = 1;
		while( nTimes < 1000 && nPos < sizeof( pAnswerBuffer )-1 )
		{
			while( s_aConnector.recv( pAnswerBuffer + nPos, 1 ) == 1 &&
				   nPos < sizeof( pAnswerBuffer )-1 )
			{
				nPos++;
				if( pAnswerBuffer[ nPos-2 ] == '\r' &&
					pAnswerBuffer[ nPos-1 ] == '\n' )
				{
					pAnswerBuffer[ nPos-2 ] = 0;
					goto doreturn;
				}
			}
            TimeValue aVal;
            aVal.Seconds = 0;
            aVal.Nanosec = 1000000;
            osl_waitThread( &aVal );
		}
	}
  doreturn:
	SalDbgAssert( "read line \"%s\"\n", pAnswerBuffer );
	return ByteString( pAnswerBuffer );
}

ByteString RPTPSound::sendCommand( const ByteString& rCommand )
{
	if( ! s_bConnected && ! connect() )
		return ByteString();

	SalDbgAssert( "RPTPSound::sendCommand( \"%s\" )\n", rCommand.GetBuffer() );
	
	ByteString aCommand( rCommand );
	aCommand += "\r\n";
	s_aConnector.write( aCommand.GetBuffer(), aCommand.Len() );
	return readLine();
}

RPTPSound* RPTPSound::getSoundById( ULONG nID )
{
	for( int i = 0; i < s_aSounds.Count(); i++ )
	{
		RPTPSound* pSound = s_aSounds.GetObject( i );
		if( pSound->m_nID == nID )
			return pSound;
	}
	return NULL;
}

ULONG RPTPSound::getMaxId()
{
	ULONG nID = 0;
	for( int i = 0; i < s_aSounds.Count(); i++ )
	{
		RPTPSound* pSound = s_aSounds.GetObject( i );
		if( pSound->m_nID > nID )
			nID = pSound->m_nID;
	}
	return nID;
}

RPTPSound::RPTPSound( X11SalSound* pSalSound ) :
		VSound( pSalSound ),
		m_nID( 0 )
{
	s_aSounds.Insert( this );
}

RPTPSound::~RPTPSound()
{
	s_aSounds.Remove( this );
	m_pSalSound = NULL;
	stop();
	if( s_aSounds.Count() == 0 )
		disconnect();
}

void RPTPSound::play()
{
	if( ! m_pSalSound )
		return;

	ByteString aCommand( "find sound=" );

	aCommand += m_pSalSound->m_aSoundFile;
	ByteString aAnswer = sendCommand( aCommand );
	if( ! aAnswer.Len() || ! s_bConnected )
	{
		m_pSalSound->setError( SOUNDERR_INVALID_FILE );
		return;
	}
	if( aAnswer.GetChar( 0 ) != '+' )
	{
		// the sound is not on the server
		// try to put it (does not really work with rplayd 3.3.0)
		aCommand = "put";
		
		initBuffer();

		if( ! m_pBuffer )
		{
			m_pSalSound->setError( SOUNDERR_INVALID_FILE );
			return;
		}

		aCommand += " sound=";
		aCommand += m_pSalSound->m_aSoundFile;
		aCommand += " size=";
		aCommand += ByteString::CreateFromInt64((ULONG)m_aStat.st_size);
		
		aAnswer = sendCommand( aCommand );
		
		if( aAnswer.GetChar( 0 ) == '+' )
			s_aConnector.write( m_pBuffer, m_aStat.st_size );
		// if this fails proceed anyway, because at least rplayd 3.3.0
		// does not seem to grok the "put" command

		releaseBuffer();
	}

	aCommand = "play ";
	aCommand += m_pSalSound->m_aSoundFile;
	aAnswer = sendCommand( aCommand );
	if( aAnswer.GetChar( 0 ) == '+' )
	{
		int nPos = aAnswer.Search( "id=#" );
		if( nPos != STRING_NOTFOUND )
			m_nID = aAnswer.Copy( nPos+4 ).ToInt32();
	}
	else
		m_pSalSound->setError( SOUNDERR_DEVICE_NOT_READY );

	SalDbgAssert( "RPTPSound::play() yields id %d\n", m_nID );
}

void RPTPSound::stop()
{
	ByteString aAnswer;
	if( m_nID )
	{
		ByteString aCommand( "stop id=#" );
		aCommand += ByteString::CreateFromInt64(m_nID);
		aAnswer = sendCommand( aCommand );
	}
	if( aAnswer.GetChar( 0 ) != '+' && m_pSalSound)
		m_pSalSound->setError( SOUNDERR_INVALID_FILE );
}

void RPTPSound::pause()
{
	if( m_nID )
	{
		ByteString aCommand( "pause id=#" );
		aCommand += ByteString::CreateFromInt64(m_nID);
		sendCommand( aCommand );
	}
}

void RPTPSound::cont()
{
	if( m_nID )
	{
		ByteString aCommand( "continue id=#" );
		aCommand += ByteString::CreateFromInt64(m_nID);
		sendCommand( aCommand );
	}
}

BOOL RPTPSound::isValid()
{
	if( ! s_bConnected )
		connect();
	if( ! s_bConnected )
		return FALSE;

	return stat( m_pSalSound->m_aSoundFile.GetBuffer(), &m_aStat ) ? FALSE : TRUE;
}

