/*************************************************************************
 *
 *  $RCSfile: dbmp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2004/02/20 08:52:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <dbmp.hxx>
#include <bmpacc.hxx>

// -------------
// - SalBitmap -
// -------------

DummyBitmap::DummyBitmap() :
	mpDIB( NULL )
{
}

// -----------------------------------------------------------------------------

DummyBitmap::~DummyBitmap()
{
	Destroy();
}

// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------

BitmapBuffer* DummyBitmap::ImplCreateDIB( const Size& rSize, USHORT nBitCount, const BitmapPalette& rPal )
{
	DBG_ASSERT( nBitCount == 1 || nBitCount == 4 || nBitCount == 8 || nBitCount == 24, "Unsupported BitCount!" );

	BitmapBuffer* pDIB;

	if( rSize.Width() && rSize.Height() )
	{
		pDIB = new BitmapBuffer;

		if( pDIB )
		{
			const USHORT nColors = ( nBitCount <= 8 ) ? ( 1 << nBitCount ) : 0;
			
			pDIB->mnFormat = BMP_FORMAT_BOTTOM_UP;

			switch( nBitCount )
			{
				case( 1 ): pDIB->mnFormat |= BMP_FORMAT_1BIT_MSB_PAL; break;
				case( 4 ): pDIB->mnFormat |= BMP_FORMAT_4BIT_MSN_PAL; break;
				case( 8 ): pDIB->mnFormat |= BMP_FORMAT_8BIT_PAL; break;
			
				default:
					pDIB->mnFormat |= BMP_FORMAT_24BIT_TC_BGR;
				break;
			}

			pDIB->mnWidth = rSize.Width();
			pDIB->mnHeight = rSize.Height();
			pDIB->mnScanlineSize = AlignedWidth4Bytes( pDIB->mnWidth * nBitCount );
			pDIB->mnBitCount = nBitCount;
			
			if( nColors )
			{
				pDIB->maPalette = rPal;
				pDIB->maPalette.SetEntryCount( nColors );
			}

			pDIB->mpBits = new BYTE[ pDIB->mnScanlineSize * pDIB->mnHeight ];
			rtl_zeroMemory( pDIB->mpBits, pDIB->mnScanlineSize * pDIB->mnHeight );
		}
	}
	else
		pDIB = NULL;

	return pDIB;
}

// -----------------------------------------------------------------------------

bool DummyBitmap::Create( const Size& rSize, USHORT nBitCount, const BitmapPalette& rPal )
{
	Destroy();
	mpDIB = ImplCreateDIB( rSize, nBitCount, rPal );

	return( mpDIB != NULL );
}

// -----------------------------------------------------------------------------

bool DummyBitmap::Create( const SalBitmap& rSSalBmp )
{
	Destroy();

    const DummyBitmap& rSalBmp = static_cast<const DummyBitmap&>( rSSalBmp );

	if( rSalBmp.mpDIB )
	{
		mpDIB = ImplCreateDIB( rSalBmp.GetSize(), rSalBmp.GetBitCount(), rSalBmp.mpDIB->maPalette );
		
		if( mpDIB )
			memcpy( mpDIB->mpBits, rSalBmp.mpDIB->mpBits, mpDIB->mnScanlineSize * mpDIB->mnHeight );
	}
	return( ! rSalBmp.mpDIB  || 
			( rSalBmp.mpDIB && ( mpDIB != NULL ) )
            );
}

// -----------------------------------------------------------------------------

bool DummyBitmap::Create( const SalBitmap& rSalBmp, SalGraphics* pGraphics )
{
	return FALSE;
}

// -----------------------------------------------------------------------------

bool DummyBitmap::Create( const SalBitmap& rSalBmp, USHORT nNewBitCount )
{
	return FALSE;
}

// -----------------------------------------------------------------------------

void DummyBitmap::Destroy()
{
	if( mpDIB )
	{
		delete[] mpDIB->mpBits;
		delete mpDIB, mpDIB = NULL;
	}
}

// -----------------------------------------------------------------------------

Size DummyBitmap::GetSize() const
{
	Size aSize;

	if( mpDIB )
		aSize.Width() = mpDIB->mnWidth, aSize.Height() = mpDIB->mnHeight;
	
	return aSize;
}

// -----------------------------------------------------------------------------

USHORT DummyBitmap::GetBitCount() const
{
	USHORT nBitCount;

	if( mpDIB )
		nBitCount = mpDIB->mnBitCount;
	else
		nBitCount = 0;

	return nBitCount;
}

// -----------------------------------------------------------------------------

BitmapBuffer* DummyBitmap::AcquireBuffer( bool bReadOnly )
{
	return mpDIB;
}

// -----------------------------------------------------------------------------

void DummyBitmap::ReleaseBuffer( BitmapBuffer* pBuffer, bool bReadOnly )
{
}

