/*************************************************************************
 *
 *  $RCSfile: salinst.hxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/17 15:26:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SALINST_HXX
#define _SV_SALINST_HXX

#ifdef __cplusplus

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#endif // __cplusplus

#ifndef _SV_SV_H
#include <sv.h>
#endif

#ifndef _VCL_DLLAPI_H
#include "dllapi.h"
#endif

#ifdef __cplusplus

struct SystemParentData;
struct SalPrinterQueueInfo;
struct SalStatus;
struct ImplJobSetup;
class SalGraphics;
class SalFrame;
class SalObject;
class SalSound;
class SalOpenGL;
class SalMenu;
class SalMenuItem;
class SalVirtualDevice;
class SalInfoPrinter;
class SalPrinter;
class SalTimer;
class ImplPrnQueueList;
class SalI18NImeStatus;
class SalSystem;
class SalBitmap;
struct SalItemParams;
class SalSession;
struct SystemGraphicsData;

namespace vos { class IMutex; }

// ---------------
// - SalInstance -
// ---------------

class VCL_DLLPUBLIC SalInstance
{
public:
    typedef bool(*Callback)(void*,void*,int);
private:
    void*						m_pEventInst;
    void*						m_pErrorInst;
    Callback					m_pEventCallback;
    Callback					m_pErrorCallback;
    
public:
    SalInstance() :
            m_pEventInst( NULL ),
            m_pErrorInst( NULL ),
            m_pEventCallback( NULL ),
            m_pErrorCallback( NULL )
    {}
    virtual ~SalInstance();

    // Frame
    // DisplayName for Unix ???
    virtual SalFrame*      	CreateChildFrame( SystemParentData* pParent, ULONG nStyle ) = 0;
    virtual SalFrame*      	CreateFrame( SalFrame* pParent, ULONG nStyle ) = 0;
    virtual void				DestroyFrame( SalFrame* pFrame ) = 0;

    // Object (System Child Window)
    virtual SalObject*			CreateObject( SalFrame* pParent ) = 0;
    virtual void				DestroyObject( SalObject* pObject ) = 0;

    // VirtualDevice
    // nDX and nDY in Pixel
    // nBitCount: 0 == Default(=as window) / 1 == Mono
    // pData allows for using a system dependent graphics or device context
    virtual SalVirtualDevice*	CreateVirtualDevice( SalGraphics* pGraphics,
                                                     long nDX, long nDY,
                                                     USHORT nBitCount, const SystemGraphicsData *pData = NULL ) = 0;
    virtual void				DestroyVirtualDevice( SalVirtualDevice* pDevice ) = 0;

    // Printer
    // pSetupData->mpDriverData can be 0
    // pSetupData must be updatet with the current
    // JobSetup
    virtual SalInfoPrinter*	CreateInfoPrinter( SalPrinterQueueInfo* pQueueInfo,
                                               ImplJobSetup* pSetupData ) = 0;
    virtual void				DestroyInfoPrinter( SalInfoPrinter* pPrinter ) = 0;
    virtual SalPrinter*		CreatePrinter( SalInfoPrinter* pInfoPrinter ) = 0;
    virtual void				DestroyPrinter( SalPrinter* pPrinter ) = 0;

    virtual void				GetPrinterQueueInfo( ImplPrnQueueList* pList ) = 0;
    virtual void				GetPrinterQueueState( SalPrinterQueueInfo* pInfo ) = 0;
    virtual void				DeletePrinterQueueInfo( SalPrinterQueueInfo* pInfo ) = 0;
    virtual String             GetDefaultPrinter() = 0;

    // SalSound
    virtual SalSound*			CreateSalSound() = 0;
    // SalTimer
    virtual SalTimer*			CreateSalTimer() = 0;
    // SalOpenGL
    virtual SalOpenGL*			CreateSalOpenGL( SalGraphics* pGraphics ) = 0;
    // SalI18NImeStatus
    virtual SalI18NImeStatus*	CreateI18NImeStatus() = 0;
    // SalSystem
    virtual SalSystem*			CreateSalSystem() = 0;
    // SalBitmap
    virtual SalBitmap*			CreateSalBitmap() = 0;

    // YieldMutex
    virtual vos::IMutex*		GetYieldMutex() = 0;
    virtual ULONG				ReleaseYieldMutex() = 0;
    virtual void				AcquireYieldMutex( ULONG nCount ) = 0;

	// wait next event and dispatch
    // must returned by UserEvent (SalFrame::PostEvent)
    // and timer
    virtual void				Yield( BOOL bWait ) = 0;
    virtual bool				AnyInput( USHORT nType ) = 0;

                            // Menues
    virtual SalMenu*        CreateMenu( BOOL bMenuBar ) = 0;
    virtual void            DestroyMenu( SalMenu* pMenu) = 0;
    virtual SalMenuItem*    CreateMenuItem( const SalItemParams* pItemData ) = 0;
    virtual void            DestroyMenuItem( SalMenuItem* pItem ) = 0;

    // may return NULL to disable session management
    virtual SalSession*		CreateSalSession() = 0;

    // methods for XDisplayConnection

    // the parameters for the callbacks are:
    //    void* pInst:          pInstance form the SetCallback call
    //    void* pEvent:         address of the system specific event structure
    //    int   nBytes:         length of the system specific event structure
    void				SetEventCallback( void* pInstance, Callback pCallback )
    { m_pEventInst = pInstance; m_pEventCallback = pCallback; }
    Callback GetEventCallback() const 
    { return m_pEventCallback; }
    bool				CallEventCallback( void* pEvent, int nBytes )
    { return m_pEventCallback ? m_pEventCallback( m_pEventInst, pEvent, nBytes ) : false; }
    void				SetErrorEventCallback( void* pInstance, Callback pCallback )
    { m_pErrorInst = pInstance; m_pErrorCallback = pCallback; }
    Callback			GetErrorEventCallback() const
    { return m_pErrorCallback; }
    bool				CallErrorCallback( void* pEvent, int nBytes )
    { return m_pErrorCallback ? m_pErrorCallback( m_pErrorInst, pEvent, nBytes ) : false; }

    enum ConnectionIdentifierType { AsciiCString, Blob };
    virtual void*				GetConnectionIdentifier( ConnectionIdentifierType& rReturnedType, int& rReturnedBytes ) = 0;
};

// called from SVMain
SalInstance* CreateSalInstance();
void DestroySalInstance( SalInstance* pInst );

// -------------------------
// - SalInstance-Functions -
// -------------------------

void SalAbort( const XubString& rErrorText );

VCL_DLLPUBLIC const ::rtl::OUString& SalGetDesktopEnvironment();

#endif // __cplusplus

// -----------
// - SalData -
// -----------

void InitSalData();                         // called from Application-Ctor
void DeInitSalData();                       // called from Application-Dtor

void InitSalMain();
void DeInitSalMain();

// ----------
// - SVMain -
// ----------

// Callbacks (indepen in \sv\source\app\svmain.cxx)
VCL_DLLPUBLIC BOOL SVMain();

#endif // _SV_SALINST_HXX
