/*************************************************************************
 *
 *  $RCSfile: mapmod.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/13 17:39:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_MAPMOD_HXX
#define _SV_MAPMOD_HXX

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _FRACT_HXX
#include <tools/fract.hxx>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif

#ifndef _VCL_DLLAPI_H
#include "dllapi.h"
#endif

#ifndef _TOOLS_RESID_HXX
#include <tools/resid.hxx>
#endif
#ifndef _VCL_MAPUNIT_HXX
#include <mapunit.hxx>
#endif

class SvStream;

// --------------
// - ImplMapMode -
// --------------

class ImplMapMode
{
	friend class	MapMode;
	friend class	OutputDevice;

private:
	USHORT			mnRefCount;
	MapUnit 		meUnit;
	Point			maOrigin;
	Fraction		maScaleX;
	Fraction		maScaleY;
	BOOL			mbSimple;

	friend SvStream& operator>>( SvStream& rIStm, ImplMapMode& rMapMode );
	friend SvStream& operator<<( SvStream& rOStm, const ImplMapMode& rMapMode );

public:
					ImplMapMode();
					ImplMapMode( const ImplMapMode& rImpMapMode );
};

// -----------
// - MapMode -
// -----------

class VCL_DLLPUBLIC MapMode
{
	friend class	    OutputDevice;

private:
	ImplMapMode*	    mpImplMapMode;

	SAL_DLLPRIVATE void ImplMakeUnique();

public:
					MapMode();
					MapMode( const MapMode& rMapMode );
					MapMode( MapUnit eUnit );
					MapMode( MapUnit eUnit, const Point& rLogicOrg,
							 const Fraction& rScaleX, const Fraction& rScaleY );
					~MapMode();

	void			SetMapUnit( MapUnit eUnit );
	MapUnit 		GetMapUnit() const
						{ return mpImplMapMode->meUnit; }

	void			SetOrigin( const Point& rOrigin );
	const Point&	GetOrigin() const
						{ return mpImplMapMode->maOrigin; }

	void			SetScaleX( const Fraction& rScaleX );
	const Fraction& GetScaleX() const
						{ return mpImplMapMode->maScaleX; }
	void			SetScaleY( const Fraction& rScaleY );
	const Fraction& GetScaleY() const
						{ return mpImplMapMode->maScaleY; }

	MapMode&		operator=( const MapMode& rMapMode );
	BOOL			operator==( const MapMode& rMapMode ) const;
	BOOL			operator!=( const MapMode& rMapMode ) const
						{ return !(MapMode::operator==( rMapMode )); }
	BOOL			IsDefault() const;
	BOOL			IsSameInstance( const MapMode& rMapMode ) const
						{ return (mpImplMapMode == rMapMode.mpImplMapMode); }

	friend VCL_DLLPUBLIC SvStream& operator>>( SvStream& rIStm, MapMode& rMapMode );
	friend VCL_DLLPUBLIC SvStream& operator<<( SvStream& rOStm, const MapMode& rMapMode );
};

#endif	// _SV_MAPMOD_HXX
