/*************************************************************************
 *
 *  $RCSfile: brdwin.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/13 17:26:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_BRDWIN_HXX
#define _SV_BRDWIN_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_WINDOW_HXX
#include <window.hxx>
#endif

class ImplBorderWindowView;

// --------------------------
// - ImplBorderWindow-Types -
// --------------------------

#define BORDERWINDOW_STYLE_OVERLAP			((USHORT)0x0001)
#define BORDERWINDOW_STYLE_BORDER			((USHORT)0x0002)
#define BORDERWINDOW_STYLE_FLOAT			((USHORT)0x0004)
#define BORDERWINDOW_STYLE_FRAME			((USHORT)0x0008)
#define BORDERWINDOW_STYLE_APP				((USHORT)0x0010)

#define BORDERWINDOW_HITTEST_TITLE			((USHORT)0x0001)
#define BORDERWINDOW_HITTEST_LEFT			((USHORT)0x0002)
#define BORDERWINDOW_HITTEST_MENU			((USHORT)0x0004)
#define BORDERWINDOW_HITTEST_TOP			((USHORT)0x0008)
#define BORDERWINDOW_HITTEST_RIGHT			((USHORT)0x0010)
#define BORDERWINDOW_HITTEST_BOTTOM 		((USHORT)0x0020)
#define BORDERWINDOW_HITTEST_TOPLEFT		((USHORT)0x0040)
#define BORDERWINDOW_HITTEST_TOPRIGHT		((USHORT)0x0080)
#define BORDERWINDOW_HITTEST_BOTTOMLEFT 	((USHORT)0x0100)
#define BORDERWINDOW_HITTEST_BOTTOMRIGHT	((USHORT)0x0200)
#define BORDERWINDOW_HITTEST_CLOSE			((USHORT)0x0400)
#define BORDERWINDOW_HITTEST_ROLL			((USHORT)0x0800)
#define BORDERWINDOW_HITTEST_DOCK			((USHORT)0x1000)
#define BORDERWINDOW_HITTEST_HIDE			((USHORT)0x2000)
#define BORDERWINDOW_HITTEST_HELP			((USHORT)0x4000)
#define BORDERWINDOW_HITTEST_PIN			((USHORT)0x8000)

#define BORDERWINDOW_DRAW_TITLE 			((USHORT)0x0001)
#define BORDERWINDOW_DRAW_BORDER			((USHORT)0x0002)
#define BORDERWINDOW_DRAW_FRAME 			((USHORT)0x0004)
#define BORDERWINDOW_DRAW_CLOSE 			((USHORT)0x0008)
#define BORDERWINDOW_DRAW_ROLL				((USHORT)0x0010)
#define BORDERWINDOW_DRAW_DOCK				((USHORT)0x0020)
#define BORDERWINDOW_DRAW_HIDE				((USHORT)0x0040)
#define BORDERWINDOW_DRAW_HELP				((USHORT)0x0080)
#define BORDERWINDOW_DRAW_PIN				((USHORT)0x0100)
#define BORDERWINDOW_DRAW_MENU				((USHORT)0x0200)
#define BORDERWINDOW_DRAW_ALL				(BORDERWINDOW_DRAW_TITLE |		\
											 BORDERWINDOW_DRAW_BORDER | 	\
											 BORDERWINDOW_DRAW_FRAME |		\
											 BORDERWINDOW_DRAW_CLOSE |		\
											 BORDERWINDOW_DRAW_ROLL |		\
											 BORDERWINDOW_DRAW_DOCK |		\
											 BORDERWINDOW_DRAW_HIDE |		\
											 BORDERWINDOW_DRAW_HELP |		\
											 BORDERWINDOW_DRAW_PIN  |		\
											 BORDERWINDOW_DRAW_MENU)

#define BORDERWINDOW_TITLE_NORMAL			((USHORT)0x0001)
#define BORDERWINDOW_TITLE_SMALL			((USHORT)0x0002)
#define BORDERWINDOW_TITLE_TEAROFF			((USHORT)0x0004)
#define BORDERWINDOW_TITLE_NONE 			((USHORT)0x0008)

// --------------------
// - ImplBorderWindow -
// --------------------

class ImplBorderWindow : public Window
{
	friend class Window;
	friend class ImplBorderWindowView;
	friend class ImplSmallBorderWindowView;
	friend class ImplStdBorderWindowView;

private:
	ImplBorderWindowView*	mpBorderView;
	Window* 				mpMenuBarWindow;
	long					mnMinWidth;
	long					mnMinHeight;
	long					mnMaxWidth;
	long					mnMaxHeight;
	long					mnRollHeight;
	long					mnOrgMenuHeight;
	USHORT					mnTitleType;
	USHORT					mnBorderStyle;
	BOOL					mbFloatWindow;
	BOOL					mbSmallOutBorder;
	BOOL					mbFrameBorder;
	BOOL					mbPined;
	BOOL					mbRollUp;
	BOOL					mbMenuHide;
	BOOL					mbDockBtn;
	BOOL					mbHideBtn;
	BOOL					mbHelpBtn;
    BOOL                    mbMenuBtn;
	BOOL					mbDisplayActive;

	void					ImplInit( Window* pParent,
									  WinBits nStyle, USHORT nTypeStyle,
									  SystemParentData* pParentData );
	void					ImplInit( Window* pParent,
									  WinBits nStyle, USHORT nTypeStyle, 
									  const ::com::sun::star::uno::Any& );

                            // Copy assignment is forbidden and not implemented.
	                        ImplBorderWindow (const ImplBorderWindow &);
                            ImplBorderWindow& operator= (const ImplBorderWindow &);

public:
							ImplBorderWindow( Window* pParent,
											  SystemParentData* pParentData,
											  WinBits nStyle = 0,
											  USHORT nTypeStyle = 0 );
							ImplBorderWindow( Window* pParent, WinBits nStyle = 0,
											  USHORT nTypeStyle = 0 );
							ImplBorderWindow( Window* pParent,
											  WinBits nStyle, USHORT nTypeStyle, 
											  const ::com::sun::star::uno::Any& );
							~ImplBorderWindow();

	virtual void			MouseMove( const MouseEvent& rMEvt );
	virtual void			MouseButtonDown( const MouseEvent& rMEvt );
	virtual void			Tracking( const TrackingEvent& rTEvt );
	virtual void			Paint( const Rectangle& rRect );
	virtual void			Activate();
	virtual void			Deactivate();
	virtual void			Resize();
	virtual void			RequestHelp( const HelpEvent& rHEvt );
	virtual void			StateChanged( StateChangedType nType );
	virtual void			DataChanged( const DataChangedEvent& rDCEvt );

	void					InitView();
	void					UpdateView( BOOL bNewView, const Size& rNewOutSize );
	void					InvalidateBorder();

	void					Draw( const Rectangle& rRect, OutputDevice* pDev, const Point& rPos );

	void					SetDisplayActive( BOOL bActive );
	BOOL					IsDisplayActive() const { return mbDisplayActive; }
	void					SetTitleType( USHORT nTitleType, const Size& rSize );
	void					SetBorderStyle( USHORT nStyle );
	USHORT					GetBorderStyle() const { return mnBorderStyle; }
	void					SetPin( BOOL bPin );
	void					SetRollUp( BOOL bRollUp, const Size& rSize );
	void					SetCloser();
	void					SetDockButton( BOOL bDockButton );
	void					SetHideButton( BOOL bHideButton );
	void					SetHelpButton( BOOL bHelpButton );
	void					SetMenuButton( BOOL bMenuButton );

	void					UpdateMenuHeight();
	void					SetMenuBarWindow( Window* pWindow );
	void					SetMenuBarMode( BOOL bHide );

	void					SetMinOutputSize( long nWidth, long nHeight )
								{ mnMinWidth = nWidth; mnMinHeight = nHeight; }
	void					SetMaxOutputSize( long nWidth, long nHeight )
								{ mnMaxWidth = nWidth; mnMaxHeight = nHeight; }

	void					GetBorder( sal_Int32& rLeftBorder, sal_Int32& rTopBorder,
									   sal_Int32& rRightBorder, sal_Int32& rBottomBorder ) const;
	long					CalcTitleWidth() const;

    Rectangle               GetMenuRect() const;
};

// =======================================================================

// -----------------------
// - ImplBorderFrameData -
// -----------------------

struct ImplBorderFrameData
{
	ImplBorderWindow*		mpBorderWindow;
	OutputDevice*			mpOutDev;
	Rectangle				maTitleRect;
	Rectangle				maPinRect;
	Rectangle				maCloseRect;
	Rectangle				maRollRect;
	Rectangle				maDockRect;
	Rectangle				maMenuRect;
	Rectangle				maHideRect;
	Rectangle				maHelpRect;
	Point					maMouseOff;
	long					mnWidth;
	long					mnHeight;
	long					mnTrackX;
	long					mnTrackY;
	long					mnTrackWidth;
	long					mnTrackHeight;
	sal_Int32				mnLeftBorder;
	sal_Int32				mnTopBorder;
	sal_Int32				mnRightBorder;
	sal_Int32				mnBottomBorder;
	long					mnNoTitleTop;
	long					mnBorderSize;
	long					mnTitleHeight;
	long					mnTitleOff;
	USHORT					mnHitTest;
	USHORT					mnPinState;
	USHORT					mnCloseState;
	USHORT					mnRollState;
	USHORT					mnDockState;
	USHORT					mnMenuState;
	USHORT					mnHideState;
	USHORT					mnHelpState;
	USHORT					mnTitleType;
	BOOL					mbFloatWindow;
	BOOL					mbDragFull;
    BOOL                    mbTitleClipped;
};

// =======================================================================

// ------------------------
// - ImplBorderWindowView -
// ------------------------

class ImplBorderWindowView
{
public:
	virtual 				~ImplBorderWindowView();

	virtual BOOL			MouseMove( const MouseEvent& rMEvt );
	virtual BOOL			MouseButtonDown( const MouseEvent& rMEvt );
	virtual BOOL			Tracking( const TrackingEvent& rTEvt );
	virtual String  		RequestHelp( const Point& rPos, Rectangle& rHelpRect );

	virtual void			Init( OutputDevice* pDev, long nWidth, long nHeight ) = 0;
	virtual void			GetBorder( sal_Int32& rLeftBorder, sal_Int32& rTopBorder,
									   sal_Int32& rRightBorder, sal_Int32& rBottomBorder ) const = 0;
	virtual long			CalcTitleWidth() const = 0;
	virtual void			DrawWindow( USHORT nDrawFlags, OutputDevice* pOutDev = NULL, const Point* pOffset = NULL ) = 0;
	virtual Rectangle       GetMenuRect() const;

	void					ImplInitTitle( ImplBorderFrameData* pData );
	USHORT					ImplHitTest( ImplBorderFrameData* pData, const Point& rPos );
	BOOL					ImplMouseMove( ImplBorderFrameData* pData, const MouseEvent& rMEvt );
	BOOL					ImplMouseButtonDown( ImplBorderFrameData* pData, const MouseEvent& rMEvt );
	BOOL					ImplTracking( ImplBorderFrameData* pData, const TrackingEvent& rTEvt );
	String					ImplRequestHelp( ImplBorderFrameData* pData, const Point& rPos, Rectangle& rHelpRect );
	long					ImplCalcTitleWidth( const ImplBorderFrameData* pData ) const;
};

// =======================================================================

// --------------------------
// - ImplNoBorderWindowView -
// --------------------------

class ImplNoBorderWindowView : public ImplBorderWindowView
{
public:
							ImplNoBorderWindowView( ImplBorderWindow* pBorderWindow );

	virtual void			Init( OutputDevice* pDev, long nWidth, long nHeight );
	virtual void			GetBorder( sal_Int32& rLeftBorder, sal_Int32& rTopBorder,
									   sal_Int32& rRightBorder, sal_Int32& rBottomBorder ) const;
	virtual long			CalcTitleWidth() const;
	virtual void			DrawWindow( USHORT nDrawFlags, OutputDevice* pOutDev, const Point* pOffset );
};


// =======================================================================

// -----------------------------
// - ImplSmallBorderWindowView -
// -----------------------------

class ImplSmallBorderWindowView : public ImplBorderWindowView
{
	ImplBorderWindow*		mpBorderWindow;
	OutputDevice*			mpOutDev;
	long					mnWidth;
	long					mnHeight;
	sal_Int32				mnLeftBorder;
	sal_Int32				mnTopBorder;
	sal_Int32				mnRightBorder;
	sal_Int32				mnBottomBorder;

public:
							ImplSmallBorderWindowView( ImplBorderWindow* pBorderWindow );

	virtual void			Init( OutputDevice* pOutDev, long nWidth, long nHeight );
	virtual void			GetBorder( sal_Int32& rLeftBorder, sal_Int32& rTopBorder,
									   sal_Int32& rRightBorder, sal_Int32& rBottomBorder ) const;
	virtual long			CalcTitleWidth() const;
	virtual void			DrawWindow( USHORT nDrawFlags, OutputDevice* pOutDev, const Point* pOffset );
};


// =======================================================================

// ---------------------------
// - ImplStdBorderWindowView -
// ---------------------------


class ImplStdBorderWindowView : public ImplBorderWindowView
{
	ImplBorderFrameData 	maFrameData;
	VirtualDevice*			mpATitleVirDev;
	VirtualDevice*			mpDTitleVirDev;

public:
							ImplStdBorderWindowView( ImplBorderWindow* pBorderWindow );
							~ImplStdBorderWindowView();

	virtual BOOL			MouseMove( const MouseEvent& rMEvt );
	virtual BOOL			MouseButtonDown( const MouseEvent& rMEvt );
	virtual BOOL			Tracking( const TrackingEvent& rTEvt );
	virtual String  		RequestHelp( const Point& rPos, Rectangle& rHelpRect );
	virtual Rectangle       GetMenuRect() const;

	virtual void			Init( OutputDevice* pDev, long nWidth, long nHeight );
	virtual void			GetBorder( sal_Int32& rLeftBorder, sal_Int32& rTopBorder,
									   sal_Int32& rRightBorder, sal_Int32& rBottomBorder ) const;
	virtual long			CalcTitleWidth() const;
	virtual void			DrawWindow( USHORT nDrawFlags, OutputDevice* pOutDev, const Point* pOffset );
};


#endif	// _SV_BRDWIN_HXX
