 /*************************************************************************
 *
 *  $RCSfile: filcmd.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2004/11/17 09:55:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _FILCMD_HXX_
#include "filcmd.hxx"
#endif
#ifndef _SHELL_HXX_
#include "shell.hxx"
#endif
#ifndef _PROV_HXX_
#include "prov.hxx"
#endif


using namespace fileaccess;
using namespace com::sun::star;
using namespace com::sun::star::ucb;


XCommandInfo_impl::XCommandInfo_impl( shell* pMyShell,const rtl::OUString& aUnqPath )
	: m_pMyShell( pMyShell ),
	  m_xProvider( pMyShell->m_pProvider )
{
}

XCommandInfo_impl::~XCommandInfo_impl()
{
}



void SAL_CALL
XCommandInfo_impl::acquire(
			     void )
  throw()
{
  OWeakObject::acquire();
}


void SAL_CALL
XCommandInfo_impl::release(
	void )
  throw()
{
	OWeakObject::release();
}


uno::Any SAL_CALL
XCommandInfo_impl::queryInterface(
				    const uno::Type& rType )
  throw( uno::RuntimeException )
{
	uno::Any aRet = cppu::queryInterface( rType,
										  SAL_STATIC_CAST( XCommandInfo*,this) );
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface( rType );
}


uno::Sequence< CommandInfo > SAL_CALL
XCommandInfo_impl::getCommands(
	void )
	throw( uno::RuntimeException )
{
	return m_pMyShell->m_sCommandInfo;
}


CommandInfo SAL_CALL
XCommandInfo_impl::getCommandInfoByName(
	const rtl::OUString& aName )
	throw( UnsupportedCommandException,
		   uno::RuntimeException)
{
	for( sal_Int32 i = 0; i < m_pMyShell->m_sCommandInfo.getLength(); i++ )
		if( m_pMyShell->m_sCommandInfo[i].Name == aName )
			return m_pMyShell->m_sCommandInfo[i];

	throw UnsupportedCommandException();
}


CommandInfo SAL_CALL
XCommandInfo_impl::getCommandInfoByHandle(
	sal_Int32 Handle )
	throw( UnsupportedCommandException,
		   uno::RuntimeException )
{
	for( sal_Int32 i = 0; i < m_pMyShell->m_sCommandInfo.getLength(); ++i )
		if( m_pMyShell->m_sCommandInfo[i].Handle == Handle )
			return m_pMyShell->m_sCommandInfo[i];

	throw UnsupportedCommandException();
}


sal_Bool SAL_CALL
XCommandInfo_impl::hasCommandByName(
	const rtl::OUString& aName )
	throw( uno::RuntimeException )
{
	for( sal_Int32 i = 0; i < m_pMyShell->m_sCommandInfo.getLength(); ++i )
		if( m_pMyShell->m_sCommandInfo[i].Name == aName )
			return true;

	return false;
}


sal_Bool SAL_CALL
XCommandInfo_impl::hasCommandByHandle(
	sal_Int32 Handle )
	throw( uno::RuntimeException )
{
	for( sal_Int32 i = 0; i < m_pMyShell->m_sCommandInfo.getLength(); ++i )
		if( m_pMyShell->m_sCommandInfo[i].Handle == Handle )
			return true;

	return false;
}
