/*************************************************************************
 *
 *  $RCSfile: btcpcon.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: kz $ $Date: 2004/06/11 12:19:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _BTCPCON_HXX
#define _BTCPCON_HXX

#define USE_SOCKETS

#include "tcpdef.hxx"

#ifndef _COMMUNI_HXX //autogen
#include <simplecm.hxx>
#endif

#ifndef _LIST_HXX //autogen
#include <list.hxx>
#endif

//*************************************************************************
class ClientContext
//*************************************************************************
{
private:
	CommunicationLink *pCommunicationLink;

public:
	ClientContext( CommunicationLink *pLink ) { pCommunicationLink = pLink; }

	BOOL IsEqual( CommunicationLink *pLink ) { return pLink == pCommunicationLink; }
	CommunicationLink *GetCommunicationLink() { return pCommunicationLink; }

	ByteString GetPeerName() { return pCommunicationLink->GetCommunicationPartner( CM_DOTTED ); }
		// e.g. 123.123.123.123
	ByteString GetPeerAddress() { return pCommunicationLink->GetCommunicationPartner( CM_FQDN ); }
		// e.g. xyz.stardiv.de
};

//*************************************************************************
class DataPack
//*************************************************************************
{
public:
	void*	pDataBuffer;		// zeigt auf die "echten" Daten
	ULONG	nDataSize;			// Lnge des Buffers
	ULONG	nDataType;			// Typ des Datenpackets
	ClientContext*	pConId;		// Id der Connection

	DataPack() {pDataBuffer = NULL; nDataSize = 0; nDataType = TCP_DATATYPE_NULL; pConId = NULL; }
	~DataPack() { if (pDataBuffer) delete (char*)pDataBuffer;}
};


DECLARE_LIST( ClientCtxList, ClientContext * );

//*************************************************************************
class TcpConBase
//*************************************************************************
{
protected:
	ByteString sTcpNr;
	ByteString sAddress;

	CommunicationManager *pComManager;

	BOOL bIsServer;
	BOOL bSynchronesEmpfangen;

	ClientCtxList aClientContextList;
	ClientContext *pClientContext;

	DECL_LINK( ConnectionOpenedHdl, CommunicationLink* pCL );
	DECL_LINK( ConnectionClosedHdl, CommunicationLink* pCL );
	DECL_LINK( DataReceivedHdl, CommunicationLink* pCL );


#define MaybeCallLink( Link, pData ) { if ( Link.IsSet() ) return (USHORT)Link.Call( pData ); else return 0; }

	Link aPacketRecievedLnk;
	Link aConnectionOpenedLnk;
	Link aConnectionClosedLnk;

	virtual USHORT PacketRecieved( DataPack* pData ) { MaybeCallLink( aPacketRecievedLnk, pData ) }

	virtual USHORT ConnectionOpened( ClientContext* pCtx ) { MaybeCallLink( aConnectionOpenedLnk, pCtx ) }
	virtual USHORT ConnectionClosed( ClientContext* pCtx ) { MaybeCallLink( aConnectionClosedLnk, pCtx ) }

	void LateInit();

public:
	TcpConBase( BOOL bDoSynchronesEmpfangen );

	virtual ~TcpConBase();

	void StartCommunication() { pComManager->StartCommunication(); }
	ClientContext *GetClientContext() { return pClientContext; }

	long int SendData( DataPack* pDPack );
	void ReceiveData( CommunicationLink* pCL );

	ByteString&	GetAddress() { sAddress = pComManager->GetMyName(CM_FQDN); return sAddress; }
	ByteString& GetTcpNr() { sTcpNr = pComManager->GetMyName(CM_DOTTED); return sTcpNr; }

	BOOL	IsServer(){ return bIsServer; };
	BOOL	ClientHasCon(){ return GetClientContext() != 0; }

	void 	SetStatusHdl( const Link &rLink ) { pComManager->SetInfoMsgHdl( rLink ); }


	void SetPacketRecievedHdl( Link aLink ) { aPacketRecievedLnk = aLink; }
	void SetConnectionOpenedHdl( Link aLink ) { aConnectionOpenedLnk = aLink; }
	void SetConnectionClosedHdl( Link aLink ) { aConnectionClosedLnk = aLink; }

	USHORT GetCommunicationLinkCount() { return pComManager->GetCommunicationLinkCount(); }
	CommunicationLinkRef GetCommunicationLink( USHORT nNr ) { return pComManager->GetCommunicationLink( nNr ); }

	void SetApplication( const ByteString& aApp ) { pComManager->SetApplication( aApp, TRUE ); }

};

//*************************************************************************
#endif

