#include <stdio.h>

// Default path to XMLBuildListParser.pm
#define USEPATH "h:\\work\\modules"

// Disable typedef warning
#pragma warning( disable : 4091 )

typedef SV;

class XmlBuildListException {
    private:
        const char* ExceptionMessage;
    public:
        XmlBuildListException(const char* Message)
            :ExceptionMessage(Message) {};
        const char* getMessage() {return ExceptionMessage;};
};

class XmlBuildList {
    protected:
        static bool PerlInitialized;
        static void initPerl(const char* ModulePath = USEPATH);
        // Set of arrays for each function, which uses char* arrays
        // as a return value. Each call to such function clears its array up
        // before it's being populated
        char **getJobBuildReqPlatforms_array, **getJobPlatforms_array,
             **getJobTypes_array, **getDirDependencies_array,
             **getJobDirectories_array, **getModuleDependencies_array,
             **getJobBuildReqs_array;
        char** extractArray(char** result_array);
        // C objects for $string1 & $string2 Perl variables
        SV* string_obj1; 
        SV* string_obj2; 
        SV* string_obj3;
        char** getModuleDependencies(const char* dependencyType);
        void deleteArray(char** StoredArray);
        char* getError();
        static void checkOperationSuccess();
    public:
        // alternative to constructor
        ~XmlBuildList();
        XmlBuildList(const char* buildListPath);
        const char* getProducts();
        void loadXMLFile(const char* buildListPath);
        char** getJobDirectories(const char* jobType = NULL, const char* jobPlatform = NULL);
        char** getModuleDependencies(char** products, const char* dependencyType);
        char** getModuleDependencies(char* product, const char* dependencyType);
        char** getJobBuildReqs(const char* jobBir, const char* jobPlatform);
        char* getModuleDepType(const char* depModuleName);
        char* getModuleProducts(const char* depModuleName);
	    char* getModuleName();
        char** getDirDependencies(const char* jobDir, const char* jobType, const char* jobPlatform);
        char** getJobTypes(const char* jobDir);
        char** getJobPlatforms(const char* jobDir);
        char** getJobBuildReqPlatforms(const char* jobDir, const char* buildReqName);
};

