/*************************************************************************
 *
 *  $RCSfile: callbackstructure.h,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kz $ $Date: 2004/07/30 15:40:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _callbackstructure_h
#define _callbackstructure_h

#include <sal/types.h>
#include <cppunit/autoregister/callbackfunc_fktptr.h>
#include <cppunit/autoregister/registerfunc.h>
#include <cppunit/autoregister/registertestfunction.h>
#include <cppunit/cmdlinebits.hxx>

// this structure will filled by the testshl tool and hand to the testdll

struct CallbackStructure
{
    // a version number, if we want to change/expand this struct 
    sal_Int32 nVersion;
    sal_Int64 nMagic;

    FktRegFuncPtr                aRegisterFunction;
    
    FktPtr_CallbackDispatch      aCallbackDispatch;

    //# FktPtr_TestResult_startTest  aStartTest;
    //# FktPtr_TestResult_addFailure aAddFailure; 
    //# FktPtr_TestResult_addError   aAddError;
    //# FktPtr_TestResult_endTest    aEndTest;  
    //# FktPtr_TestResult_shouldStop aShouldStop;
    //# 
    //# FktPtr_TestResult_addInfo    aAddInfo;
    //# FktPtr_TestResult_enterNode  aEnterNode;
    //# FktPtr_TestResult_leaveNode  aLeaveNode;
    
	const char* psForward;
    CmdLineBits nBits;

    // void* pJobList;

    sal_Int64 nMagic2;

    CallbackStructure()
            :nVersion(1),
             nMagic(SAL_CONST_INT64(0x0123456789abcdef)),
             aRegisterFunction(NULL),
             aCallbackDispatch(NULL),
             /* aStartTest(NULL),
             aAddFailure(NULL),
             aAddError(NULL),
             aEndTest(NULL),
             aShouldStop(NULL),
             aAddInfo(NULL),
             aEnterNode(NULL),
             aLeaveNode(NULL), */
			 psForward(NULL),
             nBits(0),
             /* pJobList(NULL), */
             nMagic2(0)
        {}
};

#endif
