/*************************************************************************
 *
 *  $RCSfile: gnome-set-default-application.c,v $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2004 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-application-registry.h>
 
/* 
 * This tool takes an application id and a list of mimetypes as arguments.
 * For each of the mime types specified the tool assignes the application
 * specified as the default application for opening documents of this mime
 * type.
 */
 
int main( int argc, const char *argv[] )
{
    GList *mime_types = NULL;
    int i;
            
    if( argc < 3 )
    {
        fprintf(stderr, 
            "Usage: gnome-set-default-application <app-id> <mime-type> [<mime-type>]\n");
        exit(1);
    }

    if( !gnome_vfs_init() )
    {
        /* No output if gnome initialization fails, because GNOME might not even be installed */
        exit(1);
    }

    /* Retrieve list of mime types the app is registerd for */
    mime_types = gnome_vfs_application_registry_get_mime_types( argv[1] );

    /* Iterate of all schemas specified on command line */
    for( i=2; i<argc; i++ )
    {
        size_t n = strlen(argv[i]); 
        GList * mime_entry;

        /* Iterate over all mime types the specified application is registered for */
        for( mime_entry = mime_types;
             mime_entry != NULL;
             mime_entry = g_list_next(mime_entry))
        {
            /* skip over empty elements */
            if( NULL == mime_entry->data )
                continue;

            /* skip elements which are shorter than the schema provided */
            if( strlen((gchar *) mime_entry->data) < n )
                continue;

            if(0 == strncmp(argv[i], (gchar *) mime_entry->data, strlen(argv[i])))
            {
                gnome_vfs_mime_set_default_application((gchar *) mime_entry->data, argv[1]);
            }
        }
    }

    if( mime_types )
        g_list_free(mime_types);

    gnome_vfs_shutdown();
    return 0;
}

