/*************************************************************************
 *
 *  $RCSfile: numctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2004/07/06 11:32:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif


#include "swtypes.hxx"
#include "swmodule.hxx"
#include "cmdid.h"
#include "numctrl.hxx"
#include "wdocsh.hxx"
#include "uinums.hxx"
#include "misc.hrc"


SFX_IMPL_TOOLBOX_CONTROL( SwNumBulletCtrl, SfxBoolItem );

/*-----------------23.06.97 14.48-------------------

--------------------------------------------------*/
SwNumBulletCtrl::SwNumBulletCtrl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
		SfxToolBoxControl(nId, rTbx, rBind)
{
	rTbx.SetItemBits( nId, TIB_DROPDOWN | rTbx.GetItemBits( nId ) );
}

/*-----------------23.06.97 14.48-------------------

--------------------------------------------------*/
SwNumBulletCtrl::~SwNumBulletCtrl()
{
}

/*-----------------23.06.97 14.48-------------------

--------------------------------------------------*/
SfxPopupWindowType	__EXPORT SwNumBulletCtrl::GetPopupWindowType() const
{
	return SFX_POPUPWINDOW_ONTIMEOUT;
}

/*-----------------23.06.97 14.48-------------------

--------------------------------------------------*/
SfxPopupWindow* 	__EXPORT SwNumBulletCtrl::CreatePopupWindow()
{
	BOOL bWeb = PTR_CAST(SwWebDocShell, SfxObjectShell::Current()) != 0;
	PopupMenu* pPopup = new PopupMenu;
	SwUiNumRules* pUiNumRules = SW_MOD()->GetUiNumRules();
	BOOL bDefNames = TRUE;
	String sDefName;
	if(GetSlotId() == FN_NUM_NUMBERING_ON)
	{
		sDefName = bWeb ?
					pUiNumRules->GetStandardWebNumbering() :
						pUiNumRules->GetStandardNumbering();
	}
	else
	{
		sDefName = bWeb ?
					pUiNumRules->GetStandardWebBullets() :
						pUiNumRules->GetStandardBullets();;
	}
	for(USHORT i = 1; i <= pUiNumRules->nMaxRules; i++)
	{
		const SwNumRulesWithName* pRule = pUiNumRules->GetRules(i - 1);
		if(pRule)
		{
			bDefNames = FALSE;
			pPopup->InsertItem(i, pRule->GetName());
			if(pRule->GetName() == sDefName)
				pPopup->CheckItem(i, TRUE);
		}
	}
	if(bDefNames)
	{
		String sTemp(SW_RES(STR_NUMRULE_UNKNOWN));
		sTemp += ' ';
		for(USHORT i = 1; i <= pUiNumRules->nMaxRules; i++)
		{
			String sInsert(sTemp);
			sInsert += i;
			pPopup->InsertItem(i, sInsert);
			pPopup->EnableItem(i, FALSE);
		}
	}
	Link aLnk = LINK(this, SwNumBulletCtrl, PopupHdl);
	Rectangle aRect(GetToolBox().GetItemRect(GetId()));
	pPopup->SetSelectHdl(aLnk);
	pPopup->Execute(&GetToolBox(), aRect.BottomLeft());
	delete pPopup;
	GetToolBox().EndSelection();
	return 0;
}

/*-----------------23.06.97 14.48-------------------

--------------------------------------------------*/
void __EXPORT SwNumBulletCtrl::StateChanged( USHORT nSID,
											  SfxItemState eState,
											  const SfxPoolItem* pState )
{
	SfxToolBoxControl::StateChanged(nSID, eState, pState);
}


/*-----------------24.06.97 11.15-------------------

--------------------------------------------------*/
IMPL_LINK(SwNumBulletCtrl, PopupHdl, PopupMenu*, pPopup)
{
	int nId = pPopup->GetCurItemId();

	SfxStringItem aItem(FN_NUM_NUMBERING_ON, pPopup->GetItemText(nId));
	SfxViewFrame::Current()->GetDispatcher()->Execute(FN_NUM_NUMBERING_ON,
					SFX_CALLMODE_ASYNCHRON|SFX_CALLMODE_RECORD,
					&aItem,
					0L);

	return 0;
}






