/*************************************************************************
 *
 *  $RCSfile: fltbase.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:14:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef __FLTBASE_HXX__
#define __FLTBASE_HXX__

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

class SwFilterBase
{
protected:
	SvStream	*pIn;
	sal_Char	*pReadBuff;	//		Groessenangabe
	INT32		nBytesLeft;	// noch zu lesende Bytes des aktuelle Records

	CharSet		eQuellChar;	// Quell-Zeichensatz (interner Zeichensatz)
//	CharSet		eZielChar;	// Ziel-Zeichensatz

	USHORT		nTab;		// z.Zt. bearbeitete Tabelle
	USHORT		nReadBuffSize;// temporaerer Lesepuffer mit

	// ----------------------------------------------------------
	inline void ReadChar( char &rC );
	inline void ReadByte( BYTE &rN );
	inline void Read( short &rN );
	inline void ReadUnicode( sal_Unicode &rU );
	inline void Read( BYTE &rN0, USHORT &rN1, USHORT &rN2 );
	inline void Read( USHORT &rN );
	inline void Read( USHORT &rN1, USHORT &rN2 );
	inline void Read( USHORT &rN1, USHORT &rN2, USHORT &rN3, USHORT &rN4 );
	inline void Read( double &rF );
			void Read( String &rS );		// liest 0-terminierten C-String!
	inline void ClearBytesLeft( void );
};


inline void SwFilterBase::ReadChar( char &rC )
	{
	*pIn >> rC;
	nBytesLeft--;
	}

inline void SwFilterBase::ReadByte( BYTE &rN )
	{
	*pIn >> rN;
	nBytesLeft--;
	}

inline void SwFilterBase::ReadUnicode( sal_Unicode &rU )
{
	{
	sal_Char cC;
	*pIn >> cC;
	rU = ByteString::ConvertToUnicode(cC, eQuellChar);
	nBytesLeft--;
	}
}

inline void SwFilterBase::Read( short &rN )
	{
	*pIn >> rN;
	nBytesLeft -= 2;
	}

inline void SwFilterBase::Read( BYTE &rN0, USHORT &rN1, USHORT &rN2 )
	{
	*pIn >> rN0 >> rN1 >> rN2;
	nBytesLeft -= 5;
	}

inline void SwFilterBase::Read( USHORT &rN )
	{
	*pIn >> rN;
	nBytesLeft -= 2;
	}

inline void SwFilterBase::Read( USHORT &rN1, USHORT &rN2 )
	{
	*pIn >> rN1 >> rN2;
	nBytesLeft -= 4;
	}

inline void SwFilterBase::Read( USHORT &rN1, USHORT &rN2, USHORT &rN3, USHORT &rN4 )
	{
	*pIn >> rN1 >> rN2 >> rN3 >> rN4;
	nBytesLeft -= 8;
	}

inline void SwFilterBase::Read( double &rF )
	{
	*pIn >> rF;
	nBytesLeft -= 8;
	}

inline void SwFilterBase::ClearBytesLeft( void )
	{
	pIn->SeekRel( nBytesLeft );
	nBytesLeft = 0;
	}


#endif

